/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common;

import com.google.gwt.event.dom.client.BlurEvent;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.BaseSelector;

@Dependent
@Templated
public class BaseSelectorView
implements BaseSelector.View {
    private BaseSelector presenter;
    @DataField(value="generic-input")
    private final HTMLInputElement input;
    private Consumer<BlurEvent> onValueInputBlur;

    @Inject
    public BaseSelectorView(HTMLInputElement input) {
        this.input = input;
    }

    public void init(BaseSelector presenter) {
        this.presenter = presenter;
    }

    @Override
    public String getValue() {
        return this.input.value;
    }

    @Override
    public void setValue(String value) {
        this.input.value = value;
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.input.setAttribute("placeholder", placeholder);
    }

    @Override
    public void setOnInputChangeCallback(Consumer<Event> onValueChangeConsumer) {
        this.input.onkeyup = event -> this.consume(event, onValueChangeConsumer);
        this.input.onchange = event -> this.consume(event, onValueChangeConsumer);
    }

    @Override
    public void select() {
        this.input.select();
    }

    @Override
    public void setOnInputBlurCallback(Consumer<BlurEvent> onValueInputBlur) {
        this.onValueInputBlur = onValueInputBlur;
    }

    @Override
    public void setInputType(String type) {
        this.input.setAttribute("type", type);
    }

    @EventHandler(value={"generic-input"})
    void onGenericInputBlur(BlurEvent blurEvent) {
        this.getOnValueInputBlur().ifPresent(consumer -> consumer.accept(blurEvent));
    }

    Optional<Consumer<BlurEvent>> getOnValueInputBlur() {
        return Optional.ofNullable(this.onValueInputBlur);
    }

    private boolean consume(Event event, Consumer<Event> onValueChange) {
        onValueChange.accept(event);
        return true;
    }
}

