/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration;

import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLElement;
import elemental2.dom.MouseEvent;
import elemental2.dom.NodeList;
import java.util.Objects;
import org.kie.workbench.common.stunner.core.util.StringUtils;

class DragAndDropHelper {
    private final HTMLElement dragArea;
    private final HTMLElement addButtonContainer;
    private int clickedYPosition;
    private int startYPosition;
    private HTMLElement draggingElement;
    static final String DRAGGABLE_ITEM_CLASS = ".draggable";
    static final String TOP = "top";
    static final String PX = "px";

    public DragAndDropHelper(HTMLElement dragArea, HTMLElement addButtonContainer) {
        this.dragArea = dragArea;
        this.addButtonContainer = addButtonContainer;
        this.init();
    }

    private void init() {
        this.dragArea.onmousedown = this::onDragAreaMouseDown;
        this.dragArea.onmouseup = this::onDragAreaMouseUp;
        this.dragArea.onmousemove = this::onDragAreaMouseMove;
    }

    void refreshItemsPosition() {
        int addButtonTop;
        NodeList draggableItems = this.dragArea.querySelectorAll(DRAGGABLE_ITEM_CLASS);
        if (!Objects.isNull(draggableItems) && draggableItems.length > 0.0) {
            double itemHeight = this.getItemHeight((HTMLElement)draggableItems.getAt(0));
            addButtonTop = (int)(draggableItems.length * itemHeight);
            int i = 0;
            while ((double)i < draggableItems.length) {
                HTMLElement element = (HTMLElement)draggableItems.getAt(i);
                int top = (int)((double)this.position((Element)element) * itemHeight);
                this.setTop(element, top);
                ++i;
            }
        } else {
            addButtonTop = 0;
        }
        this.setTop(this.addButtonContainer, addButtonTop);
    }

    int position(Element element) {
        return Integer.valueOf(element.getAttribute("data-position"));
    }

    Element findElementByPosition(int position) {
        return this.dragArea.querySelector("[data-position=\"" + position + "\"]");
    }

    void swapElements(Element element, Element element2) {
        if (Objects.isNull(element) || Objects.isNull(element2)) {
            return;
        }
        int pos1 = this.position(element);
        int pos2 = this.position(element2);
        element.setAttribute("data-position", (double)pos2);
        element2.setAttribute("data-position", (double)pos1);
        this.refreshItemsPosition();
    }

    Object onDragAreaMouseDown(Event e) {
        MouseEvent event = (MouseEvent)e;
        if (!Objects.isNull(event.target)) {
            Element grabber = ((Element)event.target).closest(".drag-grabber");
            if (Objects.isNull(grabber)) {
                return this;
            }
            this.draggingElement = (HTMLElement)grabber.closest(DRAGGABLE_ITEM_CLASS);
            this.clickedYPosition = (int)event.clientY;
            this.startYPosition = this.getTop(this.getDragging());
        }
        return this;
    }

    int getStartYPosition() {
        return this.startYPosition;
    }

    int getClickedYPosition() {
        return this.clickedYPosition;
    }

    HTMLElement getDragging() {
        return this.draggingElement;
    }

    Object onDragAreaMouseUp(Event event) {
        this.draggingElement = null;
        this.clickedYPosition = 0;
        this.startYPosition = 0;
        this.refreshItemsPosition();
        return this;
    }

    int getTop(HTMLElement element) {
        String topString = element.style.getPropertyValue(TOP).replace(PX, "");
        if (StringUtils.isEmpty((String)topString)) {
            return 0;
        }
        return Integer.valueOf(topString);
    }

    void setTop(HTMLElement element, int top) {
        element.style.setProperty(TOP, top + PX);
    }

    Object onDragAreaMouseMove(Event e) {
        int oldPosition;
        if (Objects.isNull(this.getDragging())) {
            return this;
        }
        MouseEvent event = (MouseEvent)e;
        int delta = this.getDelta(event);
        int newPosition = this.getNewPosition();
        if (newPosition != (oldPosition = this.position((Element)this.getDragging()))) {
            this.swapElements(this.findElementByPosition(newPosition), (Element)this.getDragging());
        }
        this.setTop(this.getDragging(), this.startYPosition + delta);
        return this;
    }

    private double getItemHeight(HTMLElement element) {
        return element.offsetHeight;
    }

    int getNewPosition() {
        int itemHeight = (int)this.getItemHeight(this.getDragging());
        int topReference = this.getTop(this.getDragging()) + itemHeight / 2;
        int newPosition = topReference / (itemHeight == 0 ? 1 : itemHeight);
        return newPosition;
    }

    int getDelta(MouseEvent event) {
        return (int)event.clientY - this.getClickedYPosition();
    }
}

