/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Dependent
public class ItemDefinitionUpdateHandler {
    private final DataTypeManager dataTypeManager;
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final PropertiesPanelNotifier panelNotifier;

    @Inject
    public ItemDefinitionUpdateHandler(DataTypeManager dataTypeManager, ItemDefinitionUtils itemDefinitionUtils, PropertiesPanelNotifier panelNotifier) {
        this.dataTypeManager = dataTypeManager;
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.panelNotifier = panelNotifier;
    }

    public void update(DataType dataType, ItemDefinition itemDefinition) {
        String itemDefinitionBeforeUpdate = itemDefinition.getName().getValue();
        if (this.isStructure(dataType)) {
            itemDefinition.setTypeRef(null);
        } else {
            itemDefinition.setTypeRef(this.makeQName(dataType));
            itemDefinition.getItemComponent().clear();
        }
        itemDefinition.setIsCollection(Boolean.valueOf(dataType.isList()));
        itemDefinition.setName(this.makeName(dataType));
        itemDefinition.setAllowedValues(this.makeAllowedValues(dataType, itemDefinition));
        this.notifyPropertiesPanel(itemDefinitionBeforeUpdate, itemDefinition);
    }

    private void notifyPropertiesPanel(String itemDefinitionBeforeUpdate, ItemDefinition itemDefinition) {
        this.panelNotifier.withOldLocalPart(itemDefinitionBeforeUpdate).withNewQName(this.makeQName(itemDefinition)).notifyPanel();
    }

    UnaryTests makeAllowedValues(DataType dataType, ItemDefinition itemDefinition) {
        String constraint = dataType.getConstraint();
        if (StringUtils.isEmpty((String)constraint)) {
            return null;
        }
        if (!Objects.equals(constraint, this.getText(itemDefinition))) {
            return new UnaryTests(new Id(), new Description(), new Text(constraint), null, dataType.getConstraintType());
        }
        return itemDefinition.getAllowedValues();
    }

    Name makeName(DataType dataType) {
        return new Name(dataType.getName());
    }

    QName makeQName(DataType dataType) {
        return this.normaliseTypeRef(this.makeQName(dataType.getType()));
    }

    QName makeQName(ItemDefinition itemDefinition) {
        return this.normaliseTypeRef(this.makeQName(itemDefinition.getName().getValue()));
    }

    private String getText(ItemDefinition itemDefinition) {
        return this.itemDefinitionUtils.getConstraintText(itemDefinition);
    }

    private QName makeQName(String value) {
        return new QName("", value);
    }

    private QName normaliseTypeRef(QName typeRef) {
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    private boolean isStructure(DataType dataType) {
        return Objects.equals(dataType.getType(), this.dataTypeManager.structure());
    }
}

