/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import elemental2.dom.NodeList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcuts;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.selectpicker.JQuery;
import org.uberfire.client.views.pfly.selectpicker.JQueryList;

@Dependent
public class DataTypeListShortcutsView
implements DataTypeListShortcuts.View {
    static final String HIGHLIGHT = "key-highlight";
    private final ScrollHelper scrollHelper;
    final ListUtils utils = new ListUtils();
    private String currentUUID = "";
    private String previousUUID = "";
    private DataTypeListShortcuts presenter;

    @Inject
    public DataTypeListShortcutsView(ScrollHelper scrollHelper) {
        this.scrollHelper = scrollHelper;
    }

    public void init(DataTypeListShortcuts presenter) {
        this.presenter = presenter;
    }

    @Override
    public Optional<Element> getFirstDataTypeRow() {
        return this.utils.first(this.getVisibleDataTypeRows());
    }

    @Override
    public Optional<Element> getNextDataTypeRow() {
        List<Element> visibleDataTypes = this.getVisibleDataTypeRows();
        Optional<Element> next = this.getCurrentDataTypeRow(visibleDataTypes).flatMap(current -> this.utils.next(visibleDataTypes, (Element)current));
        return next.isPresent() ? next : this.utils.first(visibleDataTypes);
    }

    @Override
    public Optional<Element> getPrevDataTypeRow() {
        List<Element> visibleDataTypes = this.getVisibleDataTypeRows();
        Optional<Element> prev = this.getCurrentDataTypeRow(visibleDataTypes).flatMap(current -> this.utils.prev(visibleDataTypes, (Element)current));
        return prev.isPresent() ? prev : this.utils.last(visibleDataTypes);
    }

    @Override
    public Optional<DataTypeListItem> getCurrentDataTypeListItem() {
        return this.getDataTypeListItem(this.getCurrentUUID());
    }

    @Override
    public List<DataTypeListItem> getVisibleDataTypeListItems() {
        return this.getVisibleDataTypeRows().stream().map(this::getUUID).map(this::getDataTypeListItem).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public void highlight(Element element) {
        this.cleanCurrentHighlight();
        this.setCurrentUUID(this.getUUID(element));
        this.addHighlightClass(element);
        this.scrollTo(element);
    }

    @Override
    public void focusIn() {
        if (StringUtils.isEmpty((String)this.getCurrentUUID())) {
            this.getDataTypeListItem(this.getPreviousUUID()).ifPresent(listItem -> this.highlight((Element)listItem.getElement()));
        }
    }

    void scrollTo(Element target) {
        int padding = 20;
        HTMLElement container = this.presenter.getDataTypeList().getListItemsElement();
        this.scrollHelper.scrollTo(target, (Element)container, 20);
    }

    @Override
    public void reset() {
        this.cleanCurrentHighlight();
        this.setCurrentUUID("");
    }

    void cleanCurrentHighlight() {
        NodeList<Element> highlightedElements = this.querySelectorAll(".key-highlight");
        int i = 0;
        while ((double)i < highlightedElements.length) {
            ((Element)highlightedElements.getAt((int)i)).classList.remove(new String[]{HIGHLIGHT});
            ++i;
        }
    }

    NodeList<Element> querySelectorAll(String selector) {
        return this.presenter.getDataTypeList().getListItemsElement().querySelectorAll(selector);
    }

    void addHighlightClass(Element element) {
        element.classList.add(new String[]{HIGHLIGHT});
    }

    Optional<DataTypeListItem> getDataTypeListItem(String uuid) {
        return this.presenter.getDataTypeList().getItems().stream().filter(item -> Objects.equals(item.getDataType().getUUID(), uuid)).findFirst();
    }

    Optional<Element> getCurrentDataTypeRow(List<Element> elements) {
        String uuid = StringUtils.isEmpty((String)this.getCurrentUUID()) ? this.getPreviousUUID() : this.getCurrentUUID();
        return elements.stream().filter(e -> Objects.equals(uuid, this.getUUID((Element)e))).findFirst();
    }

    private String getUUID(Element element) {
        return element.getAttribute("data-row-uuid");
    }

    String getCurrentUUID() {
        return this.currentUUID;
    }

    String getPreviousUUID() {
        return this.previousUUID;
    }

    void setCurrentUUID(String currentUUID) {
        this.previousUUID = this.currentUUID;
        this.currentUUID = currentUUID;
    }

    private List<Element> getVisibleDataTypeRows() {
        ArrayList<Element> elements = new ArrayList<Element>();
        JQueryList<Element> filtered = this.filterVisible();
        for (int i = 0; i < filtered.length; ++i) {
            elements.add((Element)filtered.get(i));
        }
        return elements;
    }

    JQueryList<Element> filterVisible() {
        return JQuery.$((String)"[data-row-uuid]").filter(":visible");
    }

    class ListUtils {
        ListUtils() {
        }

        Optional<Element> next(List<Element> elements, Element element) {
            int index = elements.indexOf(element);
            return index > -1 && index < elements.size() - 1 ? Optional.of(elements.get(index + 1)) : Optional.empty();
        }

        Optional<Element> prev(List<Element> elements, Element element) {
            int index = elements.indexOf(element);
            return index > 0 && index < elements.size() ? Optional.of(elements.get(index - 1)) : Optional.empty();
        }

        Optional<Element> first(List<Element> elements) {
            return elements.isEmpty() ? Optional.empty() : Optional.of(elements.get(0));
        }

        Optional<Element> last(List<Element> elements) {
            return elements.isEmpty() ? Optional.empty() : Optional.of(elements.get(elements.size() - 1));
        }
    }
}

