/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.util.TypeRefUtils;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;

public abstract class NameAndDataTypeHeaderMetaData
extends EditablePopupHeaderMetaData<HasNameAndTypeRef, NameAndDataTypePopoverView.Presenter>
implements HasNameAndTypeRef {
    private final Optional<HasName> hasName;
    private final Supplier<HasTypeRef> hasTypeRef;
    private final Consumer<HasName> clearDisplayNameConsumer;
    private final BiConsumer<HasName, Name> setDisplayNameConsumer;
    private final BiConsumer<HasTypeRef, QName> setTypeRefConsumer;

    public NameAndDataTypeHeaderMetaData(HasExpression hasExpression, Optional<HasName> hasName, Consumer<HasName> clearDisplayNameConsumer, BiConsumer<HasName, Name> setDisplayNameConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, CellEditorControlsView.Presenter cellEditorControls, NameAndDataTypePopoverView.Presenter editor, Optional<String> editorTitle) {
        this(hasName, () -> TypeRefUtils.getTypeRefOfExpression(hasExpression.getExpression(), hasExpression), clearDisplayNameConsumer, setDisplayNameConsumer, setTypeRefConsumer, cellEditorControls, editor, editorTitle);
    }

    public NameAndDataTypeHeaderMetaData(Optional<HasName> hasName, Supplier<HasTypeRef> hasTypeRef, Consumer<HasName> clearDisplayNameConsumer, BiConsumer<HasName, Name> setDisplayNameConsumer, BiConsumer<HasTypeRef, QName> setTypeRefConsumer, CellEditorControlsView.Presenter cellEditorControls, NameAndDataTypePopoverView.Presenter editor, Optional<String> editorTitle) {
        super(cellEditorControls, editor, editorTitle);
        this.hasName = hasName;
        this.hasTypeRef = hasTypeRef;
        this.clearDisplayNameConsumer = clearDisplayNameConsumer;
        this.setDisplayNameConsumer = setDisplayNameConsumer;
        this.setTypeRefConsumer = setTypeRefConsumer;
    }

    @Override
    protected HasNameAndTypeRef getPresenter() {
        return this;
    }

    public String getTitle() {
        return this.getName().getValue();
    }

    public Name getName() {
        return this.hasName.orElse(HasName.NOP).getName();
    }

    public void setName(Name name) {
        this.hasName.ifPresent(hn -> {
            if (Objects.equals(name, this.getName())) {
                return;
            }
            if (name == null || name.getValue() == null || name.getValue().trim().isEmpty()) {
                this.clearDisplayNameConsumer.accept((HasName)hn);
            } else {
                this.setDisplayNameConsumer.accept((HasName)hn, name);
            }
        });
    }

    public QName getTypeRef() {
        return this.hasTypeRef.get().getTypeRef();
    }

    public void setTypeRef(QName typeRef) {
        if (Objects.equals(typeRef, this.getTypeRef())) {
            return;
        }
        this.setTypeRefConsumer.accept(this.hasTypeRef.get(), typeRef);
    }

    @Override
    public Group render(GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        return RendererUtils.getNameAndDataTypeHeaderText(this, context, blockWidth, blockHeight);
    }

    public DMNModelInstrumentedBase asDMNModelInstrumentedBase() {
        return this.hasTypeRef.get().asDMNModelInstrumentedBase();
    }

    public List<HasTypeRef> getHasTypeRefs() {
        return new ArrayList<HasTypeRef>(Collections.singletonList(this));
    }
}

