/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.container;

import com.ait.lienzo.client.core.types.Transform;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;

@Dependent
public class CellEditorControls
implements CellEditorControlsView.Presenter {
    private Optional<Supplier<DMNGridPanel>> gridPanelSupplier;
    private CellEditorControlsView view;

    public CellEditorControls() {
    }

    @Inject
    public CellEditorControls(CellEditorControlsView view) {
        this.view = view;
    }

    @Override
    public void setGridPanelSupplier(Optional<Supplier<DMNGridPanel>> gridPanelSupplier) {
        this.gridPanelSupplier = gridPanelSupplier;
    }

    @Override
    public void show(HasCellEditorControls.Editor<?> editor, Optional<String> editorTitle, int x, int y) {
        if (!this.gridPanelSupplier.isPresent()) {
            throw new IllegalStateException("A DMNGridPanel needs to have been set.");
        }
        int tx = this.getTransformedX(x);
        int ty = this.getTransformedY(y);
        this.view.show(editor, editorTitle, tx, ty);
    }

    @Override
    public void hide() {
        this.view.hide();
    }

    private int getTransformedX(int x) {
        DMNGridPanel gridPanel = this.gridPanelSupplier.get().get();
        Transform transform = gridPanel.getViewport().getTransform();
        return (int)((double)x * transform.getScaleX() + transform.getTranslateX()) + gridPanel.getAbsoluteLeft();
    }

    private int getTransformedY(int y) {
        DMNGridPanel gridPanel = this.gridPanelSupplier.get().get();
        Transform transform = gridPanel.getViewport().getTransform();
        return (int)((double)y * transform.getScaleY() + transform.getTranslateY()) + gridPanel.getAbsoluteTop();
    }
}

