/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorDividerItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorHeaderItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorTextItemView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;

@Templated
@Dependent
public class ListSelectorViewImpl
implements ListSelectorView {
    private static final String OPEN = "open";
    @DataField(value="items-container")
    private UnorderedList itemsContainer;
    private ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews;
    private ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews;
    private ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews;
    private ListSelectorView.Presenter presenter;

    public ListSelectorViewImpl() {
    }

    @Inject
    public ListSelectorViewImpl(UnorderedList itemsContainer, ManagedInstance<ListSelectorTextItemView> listSelectorTextItemViews, ManagedInstance<ListSelectorDividerItemView> listSelectorDividerItemViews, ManagedInstance<ListSelectorHeaderItemView> listSelectorHeaderItemViews) {
        this.itemsContainer = itemsContainer;
        this.listSelectorTextItemViews = listSelectorTextItemViews;
        this.listSelectorDividerItemViews = listSelectorDividerItemViews;
        this.listSelectorHeaderItemViews = listSelectorHeaderItemViews;
    }

    public void init(ListSelectorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setItems(List<HasListSelectorControl.ListSelectorItem> items) {
        DOMUtil.removeAllChildren((Node)this.itemsContainer);
        items.forEach(item -> this.makeListSelectorItemView((HasListSelectorControl.ListSelectorItem)item).ifPresent(child -> this.itemsContainer.appendChild((Node)child.getElement())));
    }

    private Optional<IsElement> makeListSelectorItemView(HasListSelectorControl.ListSelectorItem item) {
        Optional<Object> listSelectorItemView = Optional.empty();
        if (item instanceof HasListSelectorControl.ListSelectorTextItem) {
            HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
            ListSelectorTextItemView selector = (ListSelectorTextItemView)this.listSelectorTextItemViews.get();
            selector.setText(ti.getText());
            selector.setEnabled(ti.isEnabled());
            selector.addClickHandler(() -> {
                if (ti.isEnabled()) {
                    this.presenter.onItemSelected(item);
                }
            });
            listSelectorItemView = Optional.of(selector);
        } else if (item instanceof HasListSelectorControl.ListSelectorDividerItem) {
            listSelectorItemView = Optional.of(this.listSelectorDividerItemViews.get());
        } else if (item instanceof HasListSelectorControl.ListSelectorHeaderItem) {
            HasListSelectorControl.ListSelectorHeaderItem ti = (HasListSelectorControl.ListSelectorHeaderItem)item;
            ListSelectorHeaderItemView selector = (ListSelectorHeaderItemView)this.listSelectorHeaderItemViews.get();
            selector.setText(ti.getText());
            listSelectorItemView = Optional.of(selector);
        }
        return listSelectorItemView;
    }

    @Override
    public void show() {
        this.getElement().getClassList().add(OPEN);
    }

    @Override
    public void hide() {
        this.getElement().getClassList().remove(OPEN);
    }
}

