/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import java.util.List;
import org.kie.soup.commons.util.Lists;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;

public abstract class DMNGridColumn<G extends BaseGrid<? extends Expression>, T>
extends BaseGridColumn<T>
implements HasDOMElementResources {
    public static final double DEFAULT_WIDTH = 100.0;
    protected final G gridWidget;

    public DMNGridColumn(GridColumn.HeaderMetaData headerMetaData, GridColumnRenderer<T> columnRenderer, double width, G gridWidget) {
        this(new Lists.Builder().add((Object)headerMetaData).build(), columnRenderer, width, gridWidget);
    }

    public DMNGridColumn(List<GridColumn.HeaderMetaData> headerMetaData, GridColumnRenderer<T> columnRenderer, double width, G gridWidget) {
        super(headerMetaData, columnRenderer, width);
        this.gridWidget = gridWidget;
    }

    public G getGridWidget() {
        return this.gridWidget;
    }

    public void setWidth(double width) {
        this.setComponentWidth(width);
        super.setWidth(width);
    }

    public void setWidthInternal(double width) {
        this.setComponentWidth(width);
        super.setWidth(width);
    }

    protected void setComponentWidth(double width) {
        ((BaseGrid)this.gridWidget).getExpression().get().ifPresent(e -> {
            int index = this.gridWidget.getModel().getColumns().indexOf((Object)this);
            e.getComponentWidths().set(index, width);
        });
    }

    public void updateWidthOfPeers() {
        if (this.gridWidget instanceof BaseExpressionGrid) {
            BaseExpressionGrid beg = (BaseExpressionGrid)this.gridWidget;
            int parentColumnIndex = beg.getParentInformation().getColumnIndex();
            GridData parentGridData = beg.getParentInformation().getGridWidget().getModel();
            if (parentGridData != null && parentColumnIndex < parentGridData.getColumnCount()) {
                GridColumn parentColumn = (GridColumn)parentGridData.getColumns().get(parentColumnIndex);
                parentColumn.setWidth(beg.getWidth() + beg.getPadding() * 2.0);
            }
        }
    }

    public void destroyResources() {
        if (this.gridWidget instanceof BaseExpressionGrid) {
            ((BaseExpressionGrid)this.gridWidget).destroyResources();
        }
        this.getHeaderMetaData().stream().filter(md -> md instanceof HasDOMElementResources).map(md -> (HasDOMElementResources)md).forEach(HasDOMElementResources::destroyResources);
    }
}

