/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.canvas.controls.toolbox;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNCommonActionsToolboxFactory;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditBusinessKnowledgeModelToolboxAction;
import org.kie.workbench.common.dmn.client.canvas.controls.toolbox.DMNEditDecisionToolboxAction;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.ManagedInstanceStub;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.DeleteNodeToolboxAction;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNCommonActionsToolboxFactoryTest {
    private static final String E_UUID = "e1";
    @Mock
    private DeleteNodeToolboxAction deleteNodeAction;
    @Mock
    private DMNEditDecisionToolboxAction editDecisionToolboxActionInstance;
    private ManagedInstanceStub<DMNEditDecisionToolboxAction> editDecisionToolboxAction;
    @Mock
    private DMNEditBusinessKnowledgeModelToolboxAction editBusinessKnowledgeModelToolboxActionInstance;
    private ManagedInstanceStub<DMNEditBusinessKnowledgeModelToolboxAction> editBusinessKnowledgeModelToolboxAction;
    @Mock
    private ActionsToolboxView viewInstance;
    private ManagedInstanceStub<ActionsToolboxView> view;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Node element;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> commandManager;
    @Mock
    private DefaultCanvasCommandFactory commandFactory;
    @Mock
    private ManagedInstance<DeleteNodeToolboxAction> deleteNodeActions;
    private DMNCommonActionsToolboxFactory tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.element.getUUID()).thenReturn((Object)E_UUID);
        Mockito.when((Object)this.element.asNode()).thenReturn((Object)this.element);
        this.editDecisionToolboxAction = new ManagedInstanceStub((Object[])new DMNEditDecisionToolboxAction[]{this.editDecisionToolboxActionInstance});
        this.editBusinessKnowledgeModelToolboxAction = new ManagedInstanceStub((Object[])new DMNEditBusinessKnowledgeModelToolboxAction[]{this.editBusinessKnowledgeModelToolboxActionInstance});
        this.view = new ManagedInstanceStub((Object[])new ActionsToolboxView[]{this.viewInstance});
        this.tested = (DMNCommonActionsToolboxFactory)Mockito.spy((Object)new DMNCommonActionsToolboxFactory(this.editDecisionToolboxAction, this.editBusinessKnowledgeModelToolboxAction, this.view, this.commandManager, this.commandFactory, this.deleteNodeActions));
        ((DMNCommonActionsToolboxFactory)Mockito.doReturn(Collections.singleton(this.deleteNodeAction)).when((Object)this.tested)).superGetActions((AbstractCanvasHandler)Matchers.eq((Object)this.canvasHandler), (Element)Mockito.any(Element.class));
    }

    @Test
    public void testBuildToolboxForNoDecisionType() {
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)this.element);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)E_UUID, (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)1L, (long)actionsToolbox.size());
        Assert.assertEquals((Object)this.deleteNodeAction, actionsToolbox.iterator().next());
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)1))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testBuildToolboxForDecisionType() {
        NodeImpl decisionNode = new NodeImpl("decisionNode1");
        Decision decision = new Decision();
        Bounds bounds = Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)150.0);
        ViewImpl nodeContent = new ViewImpl((Object)decision, bounds);
        decisionNode.setContent((Object)nodeContent);
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)decisionNode);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)"decisionNode1", (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionsIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.deleteNodeAction, actionsIt.next());
        Assert.assertEquals((Object)this.editDecisionToolboxActionInstance, actionsIt.next());
        Assert.assertFalse((boolean)actionsIt.hasNext());
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)2))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testBuildToolboxForBusinessKnowledgeModelType() {
        NodeImpl bkmNode = new NodeImpl("bkmNode1");
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel();
        Bounds bounds = Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)150.0);
        ViewImpl nodeContent = new ViewImpl((Object)bkm, bounds);
        bkmNode.setContent((Object)nodeContent);
        Optional _toolbox = this.tested.build(this.canvasHandler, (Element)bkmNode);
        Assert.assertTrue((boolean)_toolbox.isPresent());
        Toolbox toolbox = (Toolbox)_toolbox.get();
        Assert.assertTrue((boolean)(toolbox instanceof ActionsToolbox));
        ActionsToolbox actionsToolbox = (ActionsToolbox)toolbox;
        Assert.assertEquals((Object)"bkmNode1", (Object)actionsToolbox.getElementUUID());
        Assert.assertEquals((long)2L, (long)actionsToolbox.size());
        Iterator actionsIt = actionsToolbox.iterator();
        Assert.assertEquals((Object)this.deleteNodeAction, actionsIt.next());
        Assert.assertEquals((Object)this.editBusinessKnowledgeModelToolboxActionInstance, actionsIt.next());
        Assert.assertFalse((boolean)actionsIt.hasNext());
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)1))).init((ActionsToolbox)Matchers.eq((Object)actionsToolbox));
        ((ActionsToolboxView)Mockito.verify((Object)this.viewInstance, (VerificationMode)Mockito.times((int)2))).addButton((Glyph)Mockito.any(Glyph.class), Mockito.anyString(), (Consumer)Mockito.any(Consumer.class));
    }

    @Test
    public void testIsAllowed() {
        Node node = (Node)Mockito.mock(Node.class);
        Definition content = (Definition)Mockito.mock(Definition.class);
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn((Object)decisionService);
        boolean actual = this.tested.isAllowed(this.canvasHandler, node);
        Assert.assertTrue((boolean)actual);
        ((DMNCommonActionsToolboxFactory)Mockito.verify((Object)this.tested, (VerificationMode)Mockito.never())).superIsAllowed(this.canvasHandler, node);
    }

    @Test
    public void testIsAllowedWhenIsNotDecisionService() {
        Node node = (Node)Mockito.mock(Node.class);
        Definition content = (Definition)Mockito.mock(Definition.class);
        Object def = Mockito.mock(Object.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)content);
        Mockito.when((Object)content.getDefinition()).thenReturn(def);
        ((DMNCommonActionsToolboxFactory)Mockito.doReturn((Object)false).when((Object)this.tested)).superIsAllowed(this.canvasHandler, node);
        boolean actual = this.tested.isAllowed(this.canvasHandler, node);
        Assert.assertFalse((boolean)actual);
    }
}

