/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.expressions.types.dtable.AddDecisionRuleCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionRuleFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DescriptionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.OutputClauseColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddDecisionRuleCommandTest {
    private DecisionTable dtable;
    private DecisionRule rule;
    private GridData uiModel;
    private GridRow uiModelRow;
    private DecisionTableUIModelMapper uiModelMapper;
    private AddDecisionRuleCommand command;
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private InputClauseColumn uiInputClauseColumn;
    @Mock
    private OutputClauseColumn uiOutputClauseColumn;
    @Mock
    private DescriptionColumn uiDescriptionColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private Command canvasOperation;

    @Before
    public void setup() {
        this.dtable = new DecisionTable();
        this.uiModel = new DMNGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModelRow = new BaseGridRow();
        this.uiModelMapper = new DecisionTableUIModelMapper(() -> this.uiModel, () -> Optional.of(this.dtable), this.listSelector);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((InputClauseColumn)Mockito.doReturn((Object)1).when((Object)this.uiInputClauseColumn)).getIndex();
        ((OutputClauseColumn)Mockito.doReturn((Object)2).when((Object)this.uiOutputClauseColumn)).getIndex();
        ((DescriptionColumn)Mockito.doReturn((Object)3).when((Object)this.uiDescriptionColumn)).getIndex();
    }

    private void makeCommand(int index) {
        this.rule = DecisionRuleFactory.makeDecisionRule((DecisionTable)this.dtable);
        this.command = (AddDecisionRuleCommand)Mockito.spy((Object)new AddDecisionRuleCommand(this.dtable, this.rule, this.uiModel, this.uiModelRow, index, this.uiModelMapper, this.canvasOperation));
    }

    @Test
    public void testGraphCommandAllow() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandCheck() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.allow((Object)this.graphCommandExecutionContext));
    }

    @Test
    public void testGraphCommandExecuteConstructedDescription() {
        this.makeCommand(0);
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)this.rule, this.dtable.getRule().get(0));
        Assert.assertTrue((this.rule.getDescription() != null ? 1 : 0) != 0);
        Assert.assertTrue((this.rule.getDescription().getValue() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"", (Object)this.rule.getDescription().getValue());
        Assert.assertEquals((Object)this.dtable, (Object)this.rule.getParent());
    }

    @Test
    public void testGraphCommandExecuteConstructedRuleInputs() {
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
        int inputsCount = 2;
        for (int i = 0; i < 2; ++i) {
            this.dtable.getInput().add(new InputClause());
        }
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)this.rule, this.dtable.getRule().get(0));
        Assert.assertEquals((long)2L, (long)this.rule.getInputEntry().size());
        Assert.assertEquals((long)0L, (long)this.rule.getOutputEntry().size());
        for (int inputIndex = 0; inputIndex < 2; ++inputIndex) {
            Assert.assertTrue((((UnaryTests)this.rule.getInputEntry().get(inputIndex)).getText() != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"", (Object)((UnaryTests)this.rule.getInputEntry().get(inputIndex)).getText().getValue());
            Assert.assertEquals((Object)this.rule, (Object)((UnaryTests)this.rule.getInputEntry().get(inputIndex)).getParent());
        }
        Assert.assertEquals((Object)this.dtable, (Object)this.rule.getParent());
    }

    @Test
    public void testGraphCommandExecuteConstructedRuleOutputs() {
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
        int outputsCount = 2;
        for (int i = 0; i < 2; ++i) {
            this.dtable.getOutput().add(new OutputClause());
        }
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)this.rule, this.dtable.getRule().get(0));
        Assert.assertEquals((long)0L, (long)this.rule.getInputEntry().size());
        Assert.assertEquals((long)2L, (long)this.rule.getOutputEntry().size());
        for (int outputIndex = 0; outputIndex < 2; ++outputIndex) {
            Assert.assertTrue((((LiteralExpression)this.rule.getOutputEntry().get(outputIndex)).getText() != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)"", (Object)((LiteralExpression)this.rule.getOutputEntry().get(outputIndex)).getText().getValue());
            Assert.assertEquals((Object)this.rule, (Object)((LiteralExpression)this.rule.getOutputEntry().get(outputIndex)).getParent());
        }
        Assert.assertEquals((Object)this.dtable, (Object)this.rule.getParent());
    }

    @Test
    public void testGraphCommandUndo() {
        this.makeCommand(0);
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.graphCommandExecutionContext));
        Assert.assertEquals((long)0L, (long)this.dtable.getRule().size());
    }

    @Test
    public void testGraphCommandExecuteInsertBelow() {
        DecisionRule existingRule = new DecisionRule();
        this.dtable.getRule().add(existingRule);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)2L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)existingRule, this.dtable.getRule().get(0));
        Assert.assertEquals((Object)this.rule, this.dtable.getRule().get(1));
    }

    @Test
    public void testGraphCommandExecuteInsertBelowThenUndo() {
        DecisionRule existingRule = new DecisionRule();
        this.dtable.getRule().add(existingRule);
        this.makeCommand(1);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        graphCommand.undo((Object)this.graphCommandExecutionContext);
        Assert.assertEquals((long)1L, (long)this.dtable.getRule().size());
        Assert.assertEquals((Object)existingRule, this.dtable.getRule().get(0));
    }

    @Test
    public void testCanvasCommandAllow() throws Exception {
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.allow((Object)this.canvasHandler));
    }

    @Test
    public void testCanvasCommandAddRuleAndThenUndo() throws Exception {
        this.dtable.getInput().add(new InputClause());
        this.dtable.getOutput().add(new OutputClause());
        this.makeCommand(0);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        org.kie.workbench.common.stunner.core.command.Command canvasAddRuleCommand = this.command.newCanvasCommand(this.canvasHandler);
        canvasAddRuleCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        this.assertDefaultUiRowValues(0);
        canvasAddRuleCommand.undo((Object)this.canvasHandler);
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateRowNumbers();
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateParentInformation();
    }

    @Test
    public void testCanvasCommandExecuteInsertBelow() {
        DecisionRule existingRule = new DecisionRule();
        BaseGridRow existingUiRow = new BaseGridRow();
        this.dtable.getRule().add(existingRule);
        this.uiModel.appendRow((GridRow)existingUiRow);
        this.dtable.getInput().add(new InputClause());
        this.dtable.getOutput().add(new OutputClause());
        this.makeCommand(1);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        canvasCommand.execute((Object)this.canvasHandler);
        Assert.assertEquals((long)2L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)existingUiRow, (Object)this.uiModel.getRow(0));
        Assert.assertEquals((Object)this.uiModelRow, (Object)this.uiModel.getRow(1));
        this.assertDefaultUiRowValues(1);
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command)).updateRowNumbers();
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command)).updateParentInformation();
    }

    @Test
    public void testCanvasCommandExecuteInsertBelowThenUndo() {
        DecisionRule existingRule = new DecisionRule();
        BaseGridRow existingUiRow = new BaseGridRow();
        this.dtable.getRule().add(existingRule);
        this.uiModel.appendRow((GridRow)existingUiRow);
        this.makeCommand(1);
        this.uiModel.appendColumn((GridColumn)this.uiInputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiOutputClauseColumn);
        this.uiModel.appendColumn((GridColumn)this.uiDescriptionColumn);
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.canvasHandler);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.canvasHandler);
        graphCommand.execute((Object)this.graphCommandExecutionContext);
        canvasCommand.execute((Object)this.canvasHandler);
        canvasCommand.undo((Object)this.canvasHandler);
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((Object)existingUiRow, (Object)this.uiModel.getRow(0));
        ((Command)Mockito.verify((Object)this.canvasOperation, (VerificationMode)Mockito.times((int)2))).execute();
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateRowNumbers();
        ((AddDecisionRuleCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)2))).updateParentInformation();
    }

    private void assertDefaultUiRowValues(int uiRowIndex) {
        GridRow uiGridRow = this.uiModel.getRow(uiRowIndex);
        Assert.assertEquals((Object)(uiRowIndex + 1), (Object)((GridCell)uiGridRow.getCells().get(0)).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)((GridCell)uiGridRow.getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)((GridCell)uiGridRow.getCells().get(2)).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)((GridCell)uiGridRow.getCells().get(3)).getValue().getValue());
    }
}

