/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetParametersCommand;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class SetParametersCommandTest {
    @Mock
    private Command canvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private FunctionDefinition function;
    private InformationItem parameter1;
    private InformationItem parameter2;
    private SetParametersCommand command;

    @Before
    public void setup() {
        this.function = new FunctionDefinition();
        this.parameter1 = new InformationItem();
        this.parameter2 = new InformationItem();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
    }

    @Test
    public void testGraphCommandAllow() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    private void setupCommand() {
        this.command = new SetParametersCommand(this.function, Arrays.asList(this.parameter1, this.parameter2), this.canvasOperation);
    }

    @Test
    public void testGraphCommandExecuteWithParameters() {
        InformationItem otherParameter = new InformationItem();
        this.function.getFormalParameter().add(otherParameter);
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertFormalParameters(this.parameter1, this.parameter2);
        Assert.assertEquals((Object)this.function, (Object)this.parameter1.getParent());
        Assert.assertEquals((Object)this.function, (Object)this.parameter2.getParent());
    }

    @Test
    public void testGraphCommandExecuteWithNoParameters() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        this.assertFormalParameters(this.parameter1, this.parameter2);
        Assert.assertEquals((Object)this.function, (Object)this.parameter1.getParent());
        Assert.assertEquals((Object)this.function, (Object)this.parameter2.getParent());
    }

    @Test
    public void testGraphCommandUndoWithParameters() {
        InformationItem otherParameter = new InformationItem();
        this.function.getFormalParameter().add(otherParameter);
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertFormalParameters(otherParameter);
    }

    @Test
    public void testGraphCommandUndoWithNoParameters() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        this.assertFormalParameters(new InformationItem[0]);
    }

    private void assertFormalParameters(InformationItem ... parameters) {
        AssertionsForInterfaceTypes.assertThat((List)this.function.getFormalParameter()).containsExactly((Object[])parameters);
    }

    @Test
    public void testCanvasCommandAllow() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecute() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndo() {
        this.setupCommand();
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.handler));
        ((Command)Mockito.verify((Object)this.canvasOperation)).execute();
    }
}

