/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.List;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationColumnCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class AddRelationColumnCommandTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiModelColumn;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private Command executeCanvasOperation;
    @Mock
    private Command undoCanvasOperation;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private GraphCommandExecutionContext gce;
    @Mock
    private RuleManager ruleManager;
    private Relation relation;
    private InformationItem informationItem;
    private GridData uiModel;
    private RelationUIModelMapper uiModelMapper;
    private AddRelationColumnCommand command;

    @Before
    public void setup() {
        this.relation = new Relation();
        this.informationItem = new InformationItem();
        this.uiModel = new BaseGridData();
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModelMapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation), this.listSelector);
        this.makeCommand(1);
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.ruleManager).when((Object)this.handler)).getRuleManager();
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiModelColumn)).getIndex();
    }

    private void makeCommand(int uiColumnIndex) {
        this.command = (AddRelationColumnCommand)Mockito.spy((Object)new AddRelationColumnCommand(this.relation, this.informationItem, this.uiModel, () -> this.uiModelColumn, uiColumnIndex, this.uiModelMapper, this.executeCanvasOperation, this.undoCanvasOperation));
    }

    @Test
    public void testGraphCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.gce));
    }

    @Test
    public void testGraphCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(0));
        Assert.assertEquals((Object)"column-1", (Object)this.informationItem.getName().getValue());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)1L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(0)).getExpression().get(0) instanceof LiteralExpression));
        Assert.assertEquals((Object)this.relation, (Object)this.informationItem.getParent());
        Assert.assertEquals(this.relation.getRow().get(0), (Object)((Expression)((List)this.relation.getRow().get(0)).getExpression().get(0)).getParent());
    }

    @Test
    public void testGraphCommandExecuteWithExistingColumn_InsertBefore() {
        InformationItem existingInformationItem = new InformationItem();
        this.relation.getColumn().add(existingInformationItem);
        List row = new List();
        this.relation.getRow().add(row);
        LiteralExpression existingLiteralExpression = new LiteralExpression();
        row.getExpression().add(0, existingLiteralExpression);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)2L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(0));
        Assert.assertEquals((Object)"column-1", (Object)this.informationItem.getName().getValue());
        Assert.assertEquals((Object)existingInformationItem, this.relation.getColumn().get(1));
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)2L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(0)).getExpression().get(0) instanceof LiteralExpression));
        Assert.assertEquals((Object)existingLiteralExpression, ((List)this.relation.getRow().get(0)).getExpression().get(1));
        Assert.assertEquals((Object)this.relation, (Object)this.informationItem.getParent());
        Assert.assertEquals(this.relation.getRow().get(0), (Object)((Expression)((List)this.relation.getRow().get(0)).getExpression().get(0)).getParent());
    }

    @Test
    public void testGraphCommandExecuteWithExistingColumn_InsertMiddle() {
        this.makeCommand(2);
        InformationItem existingInformationItemFirst = new InformationItem();
        this.relation.getColumn().add(existingInformationItemFirst);
        InformationItem existingInformationItemLast = new InformationItem();
        this.relation.getColumn().add(existingInformationItemLast);
        List row = new List();
        this.relation.getRow().add(row);
        LiteralExpression existingLiteralExpressionFirst = new LiteralExpression();
        LiteralExpression existingLiteralExpressionLast = new LiteralExpression();
        row.getExpression().add(existingLiteralExpressionFirst);
        row.getExpression().add(existingLiteralExpressionLast);
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)3L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)existingInformationItemFirst, this.relation.getColumn().get(0));
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(1));
        Assert.assertEquals((Object)"column-1", (Object)this.informationItem.getName().getValue());
        Assert.assertEquals((Object)existingInformationItemLast, this.relation.getColumn().get(2));
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)3L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
        Assert.assertEquals((Object)existingLiteralExpressionFirst, ((List)this.relation.getRow().get(0)).getExpression().get(0));
        Assert.assertTrue((boolean)(((List)this.relation.getRow().get(0)).getExpression().get(1) instanceof LiteralExpression));
        Assert.assertEquals((Object)existingLiteralExpressionLast, ((List)this.relation.getRow().get(0)).getExpression().get(2));
        Assert.assertEquals((Object)this.relation, (Object)this.informationItem.getParent());
        Assert.assertEquals(this.relation.getRow().get(0), (Object)((Expression)((List)this.relation.getRow().get(0)).getExpression().get(1)).getParent());
    }

    @Test
    public void testGraphCommandExecuteWithNoRows() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((long)1L, (long)this.relation.getColumn().size());
        Assert.assertEquals((Object)this.informationItem, this.relation.getColumn().get(0));
        Assert.assertEquals((Object)"column-1", (Object)this.informationItem.getName().getValue());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
        Assert.assertEquals((Object)this.relation, (Object)this.informationItem.getParent());
    }

    @Test
    public void testGraphCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)1L, (long)this.relation.getRow().size());
        Assert.assertEquals((long)0L, (long)((List)this.relation.getRow().get(0)).getExpression().size());
    }

    @Test
    public void testGraphCommandUndoWithNoRows() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newGraphCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.execute((Object)this.gce));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)c.undo((Object)this.gce));
        Assert.assertEquals((long)0L, (long)this.relation.getColumn().size());
        Assert.assertEquals((long)0L, (long)this.relation.getRow().size());
    }

    @Test
    public void testCanvasCommandAllow() {
        org.kie.workbench.common.stunner.core.command.Command c = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)c.allow((Object)this.handler));
    }

    @Test
    public void testCanvasCommandExecuteWithRows() {
        this.relation.getRow().add(new List());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)2L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        ((AddRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandExecuteWithRowsAddColumnMiddle() {
        this.makeCommand(2);
        InformationItem existingInformationItemFirst = new InformationItem();
        this.relation.getColumn().add(existingInformationItemFirst);
        InformationItem existingInformationItemLast = new InformationItem();
        this.relation.getColumn().add(existingInformationItemLast);
        this.uiModel.appendColumn((GridColumn)Mockito.mock(RelationColumn.class));
        this.uiModel.appendColumn((GridColumn)Mockito.mock(RelationColumn.class));
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)4L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(2));
    }

    @Test
    public void testCanvasCommandExecuteWithNoRows() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Assert.assertEquals((long)2L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((Object)this.uiModelColumn, this.uiModel.getColumns().get(1));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((AddRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.executeCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithRows() {
        this.relation.getRow().add(new List());
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModelMapper.fromDMNModel(0, 0);
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new AddRelationColumnCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)1L, (long)this.uiModel.getRowCount());
        Assert.assertEquals((long)1L, (long)((GridRow)this.uiModel.getRows().get(0)).getCells().size());
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        ((AddRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    @Test
    public void testCanvasCommandUndoWithNoRows() {
        this.command.newGraphCommand(this.handler).execute((Object)this.gce);
        org.kie.workbench.common.stunner.core.command.Command cc = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.execute((Object)this.handler));
        Mockito.reset((Object[])new AddRelationColumnCommand[]{this.command});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)cc.undo((Object)this.handler));
        Assert.assertEquals((long)1L, (long)this.uiModel.getColumnCount());
        Assert.assertEquals((Object)this.uiRowNumberColumn, this.uiModel.getColumns().get(0));
        Assert.assertEquals((long)0L, (long)this.uiModel.getRowCount());
        ((AddRelationColumnCommand)Mockito.verify((Object)this.command)).updateParentInformation();
        ((Command)Mockito.verify((Object)this.undoCanvasOperation)).execute();
    }

    @Test
    public void testComponentWidths() {
        org.kie.workbench.common.stunner.core.command.Command graphCommand = this.command.newGraphCommand(this.handler);
        org.kie.workbench.common.stunner.core.command.Command canvasCommand = this.command.newCanvasCommand(this.handler);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.execute((Object)this.gce));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.execute((Object)this.handler));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
        Assert.assertNull(this.relation.getComponentWidths().get(1));
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)graphCommand.undo((Object)this.gce));
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)canvasCommand.undo((Object)this.handler));
        Assert.assertEquals((long)this.relation.getRequiredComponentWidthCount(), (long)this.relation.getComponentWidths().size());
    }
}

