/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.factory.canvas;

import com.google.gwtmockito.GwtMockitoTestRunner;
import junit.framework.TestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.DMNSafeDeleteNodeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNSafeDeleteNodeCommandTest {
    @Test
    public void testShouldKeepChildren() {
        DecisionService decisionService = (DecisionService)Mockito.mock(DecisionService.class);
        Node candidate = (Node)Mockito.mock(Node.class);
        DMNSafeDeleteNodeCommand cmd = this.createMock(decisionService, candidate);
        boolean actual = cmd.shouldKeepChildren(candidate);
        TestCase.assertTrue((boolean)actual);
    }

    @Test
    public void testShouldKeepChildrenWhenIsNotDecisionService() {
        Object decisionService = Mockito.mock(Object.class);
        Node candidate = (Node)Mockito.mock(Node.class);
        DMNSafeDeleteNodeCommand cmd = this.createMock(decisionService, candidate);
        boolean actual = cmd.shouldKeepChildren(candidate);
        TestCase.assertFalse((boolean)actual);
    }

    private DMNSafeDeleteNodeCommand createMock(Object contentDefinition, Node<Definition<?>, Edge> candidate) {
        DMNSafeDeleteNodeCommand cmd = (DMNSafeDeleteNodeCommand)Mockito.mock(DMNSafeDeleteNodeCommand.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn(contentDefinition);
        Mockito.when((Object)candidate.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)cmd.shouldKeepChildren(candidate)).thenCallRealMethod();
        return cmd;
    }
}

