/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import com.google.gwt.user.client.ui.IsWidget;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.commands.general.BaseNavigateCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.AbstractSessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;
import org.uberfire.mocks.EventSourceMock;

public abstract class BaseNavigationCommandTest {
    @Mock
    protected ExpressionEditorView.Presenter editor;
    @Mock
    protected ExpressionEditorView expressionEditorView;
    @Mock
    protected ResizeFlowPanel editorContainerForErrai1090;
    @Mock
    protected AbstractSessionPresenter sessionPresenter;
    @Mock
    protected SessionPresenter.View sessionPresenterView;
    @Mock
    protected SessionViewer sessionView;
    @Mock
    protected IsWidget view;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    protected EditorSession session;
    @Mock
    protected HasName hasName;
    @Mock
    protected HasExpression hasExpression;
    @Mock
    protected GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    protected AbstractCanvasHandler canvasHandler;
    @Mock
    protected LienzoCanvas canvas;
    @Captor
    protected ArgumentCaptor<RefreshFormPropertiesEvent> refreshFormPropertiesEventCaptor;
    protected BaseNavigateCommand command;

    public void setup(boolean isOnlyVisualChangeAllowed) {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.sessionPresenter.getView()).thenReturn((Object)this.sessionPresenterView);
        Mockito.when((Object)this.sessionPresenter.getDisplayer()).thenReturn((Object)this.sessionView);
        Mockito.when((Object)this.sessionView.getView()).thenReturn((Object)this.view);
        Mockito.when((Object)this.editor.getView()).thenReturn((Object)this.expressionEditorView);
        this.command = (BaseNavigateCommand)Mockito.spy((Object)this.getCommand(isOnlyVisualChangeAllowed));
        ((BaseNavigateCommand)Mockito.doNothing().when((Object)this.command)).hidePaletteWidget(((Boolean)Mockito.any(Boolean.class)).booleanValue());
        ((BaseNavigateCommand)Mockito.doReturn((Object)this.editorContainerForErrai1090).when((Object)this.command)).wrapElementForErrai1090();
    }

    protected abstract BaseNavigateCommand getCommand(boolean var1);

    @Test
    public void verifyGraphCommandIsNoOperation() {
        this.setup(false);
        Assert.assertEquals((Object)BaseNavigateCommand.NOP_GRAPH_COMMAND, (Object)this.command.getGraphCommand(this.canvasHandler));
    }

    @Test
    public void allowCanvasCommand() {
        this.setup(false);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
    }

    public abstract void executeCanvasCommand();

    public abstract void undoCanvasCommand();
}

