/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorChildrenTraverse;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorChildrenTraverseTest {
    @Mock
    private ChildrenTraverseProcessor traverseProcessor;
    @Mock
    private DecisionNavigatorItemFactory itemFactory;
    @Mock
    private Node<View, Edge> node;
    @Mock
    private Node<View, Edge> parent;
    @Mock
    private List<Node<View, Edge>> nodes;
    private DecisionNavigatorChildrenTraverse traverse;

    @Before
    public void setup() {
        this.traverse = (DecisionNavigatorChildrenTraverse)Mockito.spy((Object)new DecisionNavigatorChildrenTraverse(this.traverseProcessor, this.itemFactory));
    }

    @Test
    public void testGetItems() {
        Graph graph = (Graph)Mockito.mock(Graph.class);
        DecisionNavigatorChildrenTraverse.TraverseCallback traverseCallback = (DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.mock(DecisionNavigatorChildrenTraverse.TraverseCallback.class);
        ArrayList expectedItems = new ArrayList();
        ((DecisionNavigatorChildrenTraverse)Mockito.doReturn((Object)traverseCallback).when((Object)this.traverse)).makeTraverseCallback();
        Mockito.when((Object)traverseCallback.getItems()).thenReturn(expectedItems);
        List actualItems = this.traverse.getItems(graph);
        ((ChildrenTraverseProcessor)Mockito.verify((Object)this.traverseProcessor)).traverse((Object)graph, (Object)traverseCallback);
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testTraverseCallbackStartNodeTraversalWithoutParents() {
        DecisionNavigatorChildrenTraverse.TraverseCallback traverseCallback = (DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.spy((Object)this.traverse.makeTraverseCallback());
        DecisionNavigatorItem item = this.makeItem("item");
        ArrayList items = new ArrayList();
        ((DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.doReturn(items).when((Object)traverseCallback)).getItems();
        Mockito.when((Object)this.itemFactory.makeRoot(this.node)).thenReturn((Object)item);
        traverseCallback.startNodeTraversal(this.node);
        Assert.assertEquals(items, Collections.singletonList(item));
    }

    @Test
    public void testTraverseCallbackStartNodeTraversalWithParents() {
        DecisionNavigatorChildrenTraverse.TraverseCallback traverseCallback = (DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.spy((Object)this.traverse.makeTraverseCallback());
        DecisionNavigatorItem item = this.makeItem("item");
        DecisionNavigatorItem parentItem = this.makeItem("parent");
        Mockito.when(this.nodes.get(0)).thenReturn(this.parent);
        Mockito.when((Object)this.itemFactory.makeItem(this.node)).thenReturn((Object)item);
        ((DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.doReturn(Optional.of(parentItem)).when((Object)traverseCallback)).findItem(this.parent);
        traverseCallback.startNodeTraversal(this.nodes, this.node);
        ((DecisionNavigatorItem)Mockito.verify((Object)parentItem)).addChild(item);
    }

    @Test
    public void testFindItem() {
        DecisionNavigatorChildrenTraverse.TraverseCallback traverseCallback = (DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.spy((Object)this.traverse.makeTraverseCallback());
        DecisionNavigatorItem item1 = this.makeItem("123");
        DecisionNavigatorItem item2 = this.makeItem("ABC");
        DecisionNavigatorItem item3 = this.makeItem("456");
        List<DecisionNavigatorItem> items = Arrays.asList(item1, item2, item3);
        Mockito.when((Object)this.node.getUUID()).thenReturn((Object)"ABC");
        ((DecisionNavigatorChildrenTraverse.TraverseCallback)Mockito.doReturn(items).when((Object)traverseCallback)).getItems();
        Optional actualItem = traverseCallback.findItem(this.node);
        Optional<DecisionNavigatorItem> expectedItem = Optional.ofNullable(item2);
        Assert.assertEquals(expectedItem, (Object)actualItem);
    }

    private DecisionNavigatorItem makeItem(String uuid) {
        return (DecisionNavigatorItem)Mockito.spy((Object)new DecisionNavigatorItem(uuid));
    }
}

