/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import java.util.Collections;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.mockito.Mockito;
import org.uberfire.mvp.Command;

public class DecisionNavigatorItemTest {
    @Test
    public void testEqualsWhenItemsAreEqual() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("123");
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("123");
        Assert.assertEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentUUIDs() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("123");
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("456");
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentParentUUIDs() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("123", null, null, null, "456");
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("123", null, null, null, "789");
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentTypes() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("123", null, DecisionNavigatorItem.Type.ITEM, null, null);
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("123", null, DecisionNavigatorItem.Type.CONTEXT, null, null);
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testEqualsWhenItemsHaveDifferentLabels() {
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("123", "Node1", null, null, null);
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("123", "Node0", null, null, null);
        Assert.assertNotEquals((Object)item1, (Object)item2);
    }

    @Test
    public void testOnClick() {
        Command command = (Command)Mockito.mock(Command.class);
        DecisionNavigatorItem item = new DecisionNavigatorItem("uuid", "label", DecisionNavigatorItem.Type.ITEM, command, null);
        item.onClick();
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testRemoveChild() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("item");
        DecisionNavigatorItem child = new DecisionNavigatorItem("child");
        item.getChildren().add(child);
        item.removeChild(child);
        Assert.assertEquals(Collections.emptySet(), (Object)item.getChildren());
    }

    @Test
    public void testAddChild() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("item");
        final DecisionNavigatorItem child = new DecisionNavigatorItem("child");
        TreeSet<DecisionNavigatorItem> expectedChildren = new TreeSet<DecisionNavigatorItem>(){
            {
                this.add(child);
            }
        };
        item.addChild(child);
        item.addChild(child);
        Assert.assertEquals((Object)expectedChildren, (Object)item.getChildren());
    }

    @Test
    public void testCompareToWhenObjectIsNotADecisionNavigatorItem() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("123");
        Object object = null;
        int result = item.compareTo(object);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToWhenItemAndObjectAreEqual() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("123");
        DecisionNavigatorItem object = new DecisionNavigatorItem("123");
        int result = item.compareTo((Object)object);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testCompareToWhenItemOrderingNameIsGreaterThanObjectOrderingName() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("123", "Hat", null, null, null);
        DecisionNavigatorItem object = new DecisionNavigatorItem("456", "Red", null, null, null);
        int result = item.compareTo((Object)object);
        Assert.assertTrue((result < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToWhenItemOrderingNameIsLessThanObjectOrderingName() {
        DecisionNavigatorItem item = new DecisionNavigatorItem("123", "Red", null, null, null);
        DecisionNavigatorItem object = new DecisionNavigatorItem("456", "Hat", null, null, null);
        int result = item.compareTo((Object)object);
        Assert.assertTrue((result > 0 ? 1 : 0) != 0);
    }
}

