/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorChildrenTraverse;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorObserver;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.docks.navigator.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.factories.DecisionNavigatorItemFactory;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorPresenterTest {
    @Mock
    private DecisionNavigatorPresenter.View view;
    @Mock
    private DecisionNavigatorTreePresenter treePresenter;
    @Mock
    private DecisionComponents decisionComponents;
    @Mock
    private DecisionNavigatorObserver decisionNavigatorObserver;
    @Mock
    private DecisionNavigatorChildrenTraverse navigatorChildrenTraverse;
    @Mock
    private DecisionNavigatorItemFactory itemFactory;
    @Mock
    private TranslationService translationService;
    private DecisionNavigatorPresenter presenter;

    @Before
    public void setup() {
        this.presenter = (DecisionNavigatorPresenter)Mockito.spy((Object)new DecisionNavigatorPresenter(this.view, this.treePresenter, this.decisionComponents, this.decisionNavigatorObserver, this.navigatorChildrenTraverse, this.itemFactory, this.translationService));
    }

    @Test
    public void testGetDiagram() {
        CanvasHandler handler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram expectedDiagram = (Diagram)Mockito.mock(Diagram.class);
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).refreshTreeView();
        ((CanvasHandler)Mockito.doReturn((Object)expectedDiagram).when((Object)handler)).getDiagram();
        this.presenter.setHandler(handler);
        Diagram actual = this.presenter.getDiagram();
        Assert.assertEquals((Object)expectedDiagram, (Object)actual);
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).initialize();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).setupView();
    }

    @Test
    public void testInitialize() {
        this.presenter.initialize();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
        ((DecisionNavigatorObserver)Mockito.verify((Object)this.decisionNavigatorObserver)).init(this.presenter);
    }

    @Test
    public void testSetupView() {
        DecisionNavigatorTreePresenter.View treeView = (DecisionNavigatorTreePresenter.View)Mockito.mock(DecisionNavigatorTreePresenter.View.class);
        DecisionComponents.View decisionComponentsView = (DecisionComponents.View)Mockito.mock(DecisionComponents.View.class);
        Mockito.when((Object)this.treePresenter.getView()).thenReturn((Object)treeView);
        Mockito.when((Object)this.decisionComponents.getView()).thenReturn((Object)decisionComponentsView);
        this.presenter.setupView();
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).setupMainTree(treeView);
        ((DecisionNavigatorPresenter.View)Mockito.verify((Object)this.view)).setupDecisionComponents(decisionComponentsView);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.presenter.getView());
    }

    @Test
    public void testGetTitle() {
        String expectedTitle = "Decision Navigator";
        Mockito.when((Object)this.translationService.format("DecisionNavigatorPresenter.DecisionNavigator", new Object[0])).thenReturn((Object)"Decision Navigator");
        String actualTitle = this.presenter.getTitle();
        Assert.assertEquals((Object)"Decision Navigator", (Object)actualTitle);
    }

    @Test
    public void testGetDefaultPosition() {
        CompassPosition expected = CompassPosition.WEST;
        Position actual = this.presenter.getDefaultPosition();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetTreePresenter() {
        Assert.assertEquals((Object)this.treePresenter, (Object)this.presenter.getTreePresenter());
    }

    @Test
    public void testGetHandler() {
        CanvasHandler expectedCanvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).refreshTreeView();
        this.presenter.setHandler(expectedCanvasHandler);
        CanvasHandler actualCanvasHandler = this.presenter.getHandler();
        Assert.assertEquals((Object)expectedCanvasHandler, (Object)actualCanvasHandler);
    }

    @Test
    public void testSetHandler() {
        CanvasHandler expectedCanvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).refreshTreeView();
        this.presenter.setHandler(expectedCanvasHandler);
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refreshTreeView();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refreshComponentsView();
        Assert.assertEquals((Object)expectedCanvasHandler, (Object)this.presenter.getHandler());
    }

    @Test
    public void testRefreshTreeView() {
        ArrayList items = new ArrayList();
        ((DecisionNavigatorPresenter)Mockito.doReturn(items).when((Object)this.presenter)).getItems();
        this.presenter.refreshTreeView();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).setupItems(items);
    }

    @Test
    public void testGetItems() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        List<Object> expectedItems = Collections.singletonList(Mockito.mock(DecisionNavigatorItem.class));
        ((DecisionNavigatorPresenter)Mockito.doNothing().when((Object)this.presenter)).refreshTreeView();
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)this.navigatorChildrenTraverse.getItems(graph)).thenReturn(expectedItems);
        this.presenter.setHandler(canvasHandler);
        List actualItems = this.presenter.getItems();
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testGetItemsWhenDiagramIsNull() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        List expectedItems = Collections.emptyList();
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn(null);
        this.presenter.setHandler(canvasHandler);
        List actualItems = this.presenter.getItems();
        Assert.assertEquals(expectedItems, (Object)actualItems);
    }

    @Test
    public void testGetGraphWhenDiagramIsNull() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn(null);
        this.presenter.setHandler(canvasHandler);
        Optional actualGraph = this.presenter.getGraph();
        Assert.assertFalse((boolean)actualGraph.isPresent());
    }

    @Test
    public void testGetGraphWhenHandlerIsNull() {
        this.presenter.setHandler(null);
        Optional actualGraph = this.presenter.getGraph();
        Assert.assertFalse((boolean)actualGraph.isPresent());
    }

    @Test
    public void testGetGraphWhenGraphExists() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph expectedGraph = (Graph)Mockito.mock(Graph.class);
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)expectedGraph);
        this.presenter.setHandler(canvasHandler);
        Optional actualGraph = this.presenter.getGraph();
        Assert.assertTrue((boolean)actualGraph.isPresent());
        Assert.assertEquals((Object)expectedGraph, actualGraph.get());
    }

    @Test
    public void testAddOrUpdateElement() {
        Element element = (Element)Mockito.mock(Node.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorPresenter)Mockito.doReturn((Object)item).when((Object)this.presenter)).makeItem(element);
        this.presenter.addOrUpdateElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).addOrUpdateItem(item);
    }

    @Test
    public void testAddOrUpdateElementWhenElementIsNotNode() {
        Element element = (Element)Mockito.mock(Edge.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        this.presenter.addOrUpdateElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter, (VerificationMode)Mockito.never())).addOrUpdateItem(item);
    }

    @Test
    public void testUpdateElement() {
        Element element = (Element)Mockito.mock(Node.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorPresenter)Mockito.doReturn((Object)item).when((Object)this.presenter)).makeItem(element);
        this.presenter.updateElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).updateItem(item);
    }

    @Test
    public void testUpdateElementWhenElementIsNotNode() {
        Element element = (Element)Mockito.mock(Edge.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        this.presenter.updateElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter, (VerificationMode)Mockito.never())).addOrUpdateItem(item);
    }

    @Test
    public void testRemoveElement() {
        Element element = (Element)Mockito.mock(Node.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorPresenter)Mockito.doReturn((Object)item).when((Object)this.presenter)).makeItem(element);
        this.presenter.removeElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).remove(item);
    }

    @Test
    public void testRemoveElementWhenElementIsNotNode() {
        Element element = (Element)Mockito.mock(Edge.class);
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        this.presenter.removeElement(element);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter, (VerificationMode)Mockito.never())).addOrUpdateItem(item);
    }

    @Test
    public void testMakeItem() {
        Element element = (Element)Mockito.mock(Element.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)element.asNode()).thenReturn((Object)node);
        this.presenter.makeItem(element);
        ((DecisionNavigatorItemFactory)Mockito.verify((Object)this.itemFactory)).makeItem(node);
    }

    @Test
    public void testRemoveAllElements() {
        this.presenter.removeAllElements();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).removeAllItems();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).removeAllItems();
    }

    @Test
    public void testClearSelections() {
        this.presenter.clearSelections();
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.treePresenter)).deselectItem();
    }

    @Test
    public void testOnRefreshDecisionComponents() {
        this.presenter.onRefreshDecisionComponents((RefreshDecisionComponents)Mockito.mock(RefreshDecisionComponents.class));
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.presenter)).refreshComponentsView();
    }

    @Test
    public void testRefreshComponentsView() {
        CanvasHandler canvasHandler = (CanvasHandler)Mockito.mock(CanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph expectedGraph = (Graph)Mockito.mock(Graph.class);
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)expectedGraph);
        ((DecisionNavigatorPresenter)Mockito.doReturn(Optional.of(canvasHandler)).when((Object)this.presenter)).getOptionalHandler();
        this.presenter.refreshComponentsView();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).refresh(diagram);
    }
}

