/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.included.components;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponent;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentFilter;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponents;
import org.kie.workbench.common.dmn.client.docks.navigator.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionComponentsTest {
    @Mock
    private DecisionComponents.View view;
    @Mock
    private DMNGraphUtils graphUtils;
    @Mock
    private DMNIncludeModelsClient client;
    @Mock
    private ManagedInstance<DecisionComponentsItem> itemManagedInstance;
    @Mock
    private DecisionComponentFilter filter;
    private DecisionComponents decisionComponents;

    @Before
    public void setup() {
        this.decisionComponents = (DecisionComponents)Mockito.spy((Object)new DecisionComponents(this.view, this.graphUtils, this.client, this.itemManagedInstance, this.filter));
    }

    @Test
    public void testInit() {
        this.decisionComponents.init();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).init((Object)this.decisionComponents);
    }

    @Test
    public void testGetView() {
        Assert.assertEquals((Object)this.view, (Object)this.decisionComponents.getView());
    }

    @Test
    public void testRefresh() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        ArrayList includedModels = new ArrayList();
        Consumer<List> listConsumer = list -> {};
        ((DecisionComponents)Mockito.doReturn(includedModels).when((Object)this.decisionComponents)).getDMNIncludedModels(diagram);
        ((DecisionComponents)Mockito.doReturn(listConsumer).when((Object)this.decisionComponents)).getNodesConsumer();
        this.decisionComponents.refresh(diagram);
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).clearDecisionComponents();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).startLoading();
        ((DMNIncludeModelsClient)Mockito.verify((Object)this.client)).loadNodesFromImports(includedModels, listConsumer);
    }

    @Test
    public void testGetDMNIncludedModelsOnlyIncludesDMN() {
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Definitions definitions = new Definitions();
        ImportDMN dmnImport = new ImportDMN();
        ImportPMML pmmlImport = new ImportPMML();
        dmnImport.getName().setValue("dmn");
        dmnImport.setImportType(DMNImportTypes.DMN.getDefaultNamespace());
        pmmlImport.setImportType(DMNImportTypes.PMML.getDefaultNamespace());
        definitions.getImport().addAll(Arrays.asList(dmnImport, pmmlImport));
        Mockito.when((Object)this.graphUtils.getDefinitions(diagram)).thenReturn((Object)definitions);
        List includedModels = this.decisionComponents.getDMNIncludedModels(diagram);
        Assertions.assertThat((List)includedModels).hasSize(1);
        Assertions.assertThat((String)((DMNIncludedModel)includedModels.get(0)).getModelName()).isEqualTo((Object)"dmn");
        Assertions.assertThat((String)((DMNIncludedModel)includedModels.get(0)).getImportType()).isEqualTo((Object)DMNImportTypes.DMN.getDefaultNamespace());
    }

    @Test
    public void testApplyTermFilter() {
        String value = "value";
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).applyFilter();
        this.decisionComponents.applyTermFilter("value");
        ((DecisionComponentFilter)Mockito.verify((Object)this.filter)).setTerm("value");
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).applyFilter();
    }

    @Test
    public void testApplyDrgElementFilterFilter() {
        String value = "value";
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).applyFilter();
        this.decisionComponents.applyDrgElementFilterFilter("value");
        ((DecisionComponentFilter)Mockito.verify((Object)this.filter)).setDrgElement("value");
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).applyFilter();
    }

    @Test
    public void testApplyFilter() {
        DecisionComponentsItem item1 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponentsItem item2 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponentsItem item3 = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        DecisionComponent component1 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent component2 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        DecisionComponent component3 = (DecisionComponent)Mockito.mock(DecisionComponent.class);
        List<DecisionComponentsItem> decisionComponentsItems = Arrays.asList(item1, item2, item3);
        ((DecisionComponents)Mockito.doReturn((Object)new DecisionComponentFilter()).when((Object)this.decisionComponents)).getFilter();
        ((DecisionComponents)Mockito.doReturn(decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        Mockito.when((Object)item1.getDecisionComponent()).thenReturn((Object)component1);
        Mockito.when((Object)item2.getDecisionComponent()).thenReturn((Object)component2);
        Mockito.when((Object)item3.getDecisionComponent()).thenReturn((Object)component3);
        Mockito.when((Object)component1.getName()).thenReturn((Object)"name3");
        Mockito.when((Object)component2.getName()).thenReturn((Object)"nome!!!");
        Mockito.when((Object)component3.getName()).thenReturn((Object)"name1");
        this.decisionComponents.getFilter().setTerm("name");
        this.decisionComponents.applyFilter();
        ((DecisionComponentsItem)Mockito.verify((Object)item1)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item2)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item3)).hide();
        ((DecisionComponentsItem)Mockito.verify((Object)item3)).show();
        ((DecisionComponentsItem)Mockito.verify((Object)item1)).show();
    }

    @Test
    public void testRemoveAllItems() {
        this.decisionComponents.removeAllItems();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).clearDecisionComponents();
    }

    @Test
    public void testGetNodesConsumerWhenNodeListIsEmpty() {
        List list = Collections.emptyList();
        this.decisionComponents.getNodesConsumer().accept(list);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).setComponentsCounter(Integer.valueOf(0));
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).hideLoading();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).showEmptyState();
    }

    @Test
    public void testGetNodesConsumerWhenNodeListIsNotEmpty() {
        DMNIncludedNode dmnIncludedNode1 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode dmnIncludedNode2 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        List<DMNIncludedNode> list = Arrays.asList(dmnIncludedNode1, dmnIncludedNode2);
        ((DecisionComponents)Mockito.doNothing().when((Object)this.decisionComponents)).addComponent((DMNIncludedNode)Matchers.any());
        this.decisionComponents.getNodesConsumer().accept(list);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).setComponentsCounter(Integer.valueOf(2));
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).hideLoading();
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).enableFilterInputs();
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).addComponent(dmnIncludedNode1);
        ((DecisionComponents)Mockito.verify((Object)this.decisionComponents)).addComponent(dmnIncludedNode2);
    }

    @Test
    public void testAddComponent() {
        DMNIncludedNode node = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DecisionComponentsItem item = (DecisionComponentsItem)Mockito.mock(DecisionComponentsItem.class);
        List decisionComponentsItems = (List)Mockito.spy(new ArrayList());
        DecisionComponentsItem.View decisionComponentsView = (DecisionComponentsItem.View)Mockito.mock(DecisionComponentsItem.View.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)decisionComponentsView.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.itemManagedInstance.get()).thenReturn((Object)item);
        Mockito.when((Object)item.getView()).thenReturn((Object)decisionComponentsView);
        ((DecisionComponents)Mockito.doReturn((Object)decisionComponentsItems).when((Object)this.decisionComponents)).getDecisionComponentsItems();
        this.decisionComponents.addComponent(node);
        ((DecisionComponentsItem)Mockito.verify((Object)item)).setDecisionComponent((DecisionComponent)Matchers.any(DecisionComponent.class));
        ((List)Mockito.verify((Object)decisionComponentsItems)).add(item);
        ((DecisionComponents.View)Mockito.verify((Object)this.view)).addListItem(htmlElement);
    }
}

