/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.docks.navigator.tree;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.docks.navigator.tree.DecisionNavigatorTreePresenter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DecisionNavigatorTreePresenterTest {
    @Mock
    private DecisionNavigatorTreePresenter.View view;
    @Mock
    private Map<String, DecisionNavigatorItem> indexedItems;
    private DecisionNavigatorTreePresenter presenter;

    @Before
    public void setup() {
        this.presenter = (DecisionNavigatorTreePresenter)Mockito.spy((Object)new DecisionNavigatorTreePresenter(this.view));
        ((DecisionNavigatorTreePresenter)Mockito.doReturn(this.indexedItems).when((Object)this.presenter)).getIndexedItems();
    }

    @Test
    public void testSetup() {
        this.presenter.setup();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).init((Object)this.presenter);
    }

    @Test
    public void testSetupItems() {
        ArrayList items = new ArrayList();
        ((DecisionNavigatorTreePresenter)Mockito.doNothing().when((Object)this.presenter)).index(items);
        this.presenter.setupItems(items);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(items);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).clean();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).setup(items);
    }

    @Test
    public void testAddOrUpdateItemWhenItemIsNotChanged() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasParent(item);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).isChanged(item);
        this.presenter.addOrUpdateItem(item);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hasItem((DecisionNavigatorItem)Matchers.any());
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).updateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addItem(item);
    }

    @Test
    public void testAddOrUpdateItemWhenItemDoesNotHaveParent() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)false).when((Object)this.presenter)).hasParent(item);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isChanged(item);
        this.presenter.addOrUpdateItem(item);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hasItem((DecisionNavigatorItem)Matchers.any());
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).updateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addItem(item);
    }

    @Test
    public void testAddOrUpdateItemWhenViewHasTheItem() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Mockito.when((Object)this.view.hasItem(item)).thenReturn((Object)true);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasParent(item);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isChanged(item);
        ((DecisionNavigatorTreePresenter)Mockito.doNothing().when((Object)this.presenter)).updateItem((DecisionNavigatorItem)Matchers.any());
        this.presenter.addOrUpdateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).updateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addItem((DecisionNavigatorItem)Matchers.any());
    }

    @Test
    public void testAddOrUpdateItemWhenViewDoesNotHaveTheItem() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        Mockito.when((Object)this.view.hasItem(item)).thenReturn((Object)false);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).hasParent(item);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)true).when((Object)this.presenter)).isChanged(item);
        ((DecisionNavigatorTreePresenter)Mockito.doNothing().when((Object)this.presenter)).addItem((DecisionNavigatorItem)Matchers.any());
        this.presenter.addOrUpdateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).addItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).updateItem((DecisionNavigatorItem)Matchers.any());
    }

    @Test
    public void testHasParentWhenItemHasParent() {
        String parentUUID = "parentUUID";
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        final DecisionNavigatorItem parent = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HashMap<String, DecisionNavigatorItem> indexedItems = new HashMap<String, DecisionNavigatorItem>(){
            {
                this.put("parentUUID", parent);
            }
        };
        Mockito.when((Object)item.getParentUUID()).thenReturn((Object)"parentUUID");
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)indexedItems).when((Object)this.presenter)).getIndexedItems();
        boolean hasParent = this.presenter.hasParent(item);
        Assert.assertTrue((boolean)hasParent);
    }

    @Test
    public void testHasParentWhenItemDoesNotHaveParent() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        HashMap indexedItems = new HashMap();
        ((DecisionNavigatorTreePresenter)Mockito.doReturn(indexedItems).when((Object)this.presenter)).getIndexedItems();
        boolean hasParent = this.presenter.hasParent(item);
        Assert.assertFalse((boolean)hasParent);
    }

    @Test
    public void testIsChangedWhenItemIsUpdated() {
        String uuid = "uuid";
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("uuid", "Node0", null, null, null);
        final DecisionNavigatorItem item2 = new DecisionNavigatorItem("uuid", "NodeJS", null, null, null);
        HashMap<String, DecisionNavigatorItem> indexedItems = new HashMap<String, DecisionNavigatorItem>(){
            {
                this.put("uuid", item2);
            }
        };
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)indexedItems).when((Object)this.presenter)).getIndexedItems();
        boolean isChanged = this.presenter.isChanged(item1);
        Assert.assertTrue((boolean)isChanged);
    }

    @Test
    public void testIsChangedWhenItemIsNotUpdated() {
        String uuid = "uuid";
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("uuid", "Node0", null, null, null);
        final DecisionNavigatorItem item2 = new DecisionNavigatorItem("uuid", "Node0", null, null, null);
        HashMap<String, DecisionNavigatorItem> indexedItems = new HashMap<String, DecisionNavigatorItem>(){
            {
                this.put("uuid", item2);
            }
        };
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)indexedItems).when((Object)this.presenter)).getIndexedItems();
        boolean isChanged = this.presenter.isChanged(item1);
        Assert.assertFalse((boolean)isChanged);
    }

    @Test
    public void testAddItem() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem nextItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)nextItem).when((Object)this.presenter)).nextItem(item);
        this.presenter.addItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).addItem(item, nextItem);
    }

    @Test
    public void testUpdateItem() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem nextItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        ((DecisionNavigatorTreePresenter)Mockito.doReturn((Object)nextItem).when((Object)this.presenter)).nextItem(item);
        this.presenter.updateItem(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).update(item, nextItem);
    }

    @Test
    public void testRemove() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        this.presenter.remove(item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).unIndex(item);
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).remove(item);
    }

    @Test
    public void testRemoveAllItems() {
        this.presenter.removeAllItems();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).clean();
        ((Map)Mockito.verify(this.indexedItems)).clear();
    }

    @Test
    public void testGetActiveParent() {
        DecisionNavigatorItem expectedItem = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        String uuid = "uuid";
        Mockito.when((Object)this.indexedItems.get("uuid")).thenReturn((Object)expectedItem);
        this.presenter.setActiveParentUUID("uuid");
        DecisionNavigatorItem actualItem = this.presenter.getActiveParent();
        Assert.assertEquals((Object)expectedItem, (Object)actualItem);
    }

    @Test
    public void testSelectItem() {
        String uuid = "uuid";
        this.presenter.selectItem("uuid");
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).select("uuid");
    }

    @Test
    public void testDeselectItem() {
        this.presenter.deselectItem();
        ((DecisionNavigatorTreePresenter.View)Mockito.verify((Object)this.view)).deselect();
    }

    @Test
    public void testNextItem() {
        String parentUUID = "parentUUID";
        DecisionNavigatorItem item1 = new DecisionNavigatorItem("item1", "AAA", null, null, "parentUUID");
        DecisionNavigatorItem item2 = new DecisionNavigatorItem("item2", "BBB", null, null, "parentUUID");
        DecisionNavigatorItem item3 = new DecisionNavigatorItem("item3", "CCC", null, null, "parentUUID");
        DecisionNavigatorItem parent = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet children = (TreeSet)Mockito.spy(this.asTreeSet(item1, item2, item3));
        Mockito.when((Object)parent.getChildren()).thenReturn((Object)children);
        Mockito.when((Object)this.indexedItems.get("parentUUID")).thenReturn((Object)parent);
        ((DecisionNavigatorItem)Mockito.doReturn((Object)children).when((Object)parent)).getChildren();
        Assert.assertEquals((Object)item3, (Object)this.presenter.nextItem(item2));
    }

    @Test
    public void testListIndex() {
        DecisionNavigatorItem item1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem item2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        List<DecisionNavigatorItem> items = Arrays.asList(item1, item2);
        this.presenter.index(items);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item1);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(item2);
    }

    @Test
    public void testItemIndex() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem child1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem child2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem parent = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        TreeSet<DecisionNavigatorItem> children = this.asTreeSet(child1, child2);
        String uuid = "uuid";
        ((DecisionNavigatorTreePresenter)Mockito.doReturn(Optional.of(parent)).when((Object)this.presenter)).parent(item);
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)item.getChildren()).thenReturn(children);
        this.presenter.index(item);
        ((DecisionNavigatorItem)Mockito.verify((Object)parent)).addChild(item);
        ((Map)Mockito.verify(this.indexedItems)).put("uuid", item);
        ((DecisionNavigatorTreePresenter)Mockito.verify((Object)this.presenter)).index(children);
    }

    @Test
    public void testUnIndex() {
        DecisionNavigatorItem item = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem parent = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        String uuid = "uuid";
        ((DecisionNavigatorTreePresenter)Mockito.doReturn(Optional.of(parent)).when((Object)this.presenter)).parent(item);
        Mockito.when((Object)item.getUUID()).thenReturn((Object)"uuid");
        this.presenter.unIndex(item);
        ((DecisionNavigatorItem)Mockito.verify((Object)parent)).removeChild(item);
        ((Map)Mockito.verify(this.indexedItems)).remove("uuid");
    }

    @Test
    public void testFindRoot() {
        DecisionNavigatorItem expectedRoot = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem item1 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        DecisionNavigatorItem item2 = (DecisionNavigatorItem)Mockito.mock(DecisionNavigatorItem.class);
        List<DecisionNavigatorItem> values = Arrays.asList(expectedRoot, item1, item2);
        Mockito.when((Object)expectedRoot.getType()).thenReturn((Object)DecisionNavigatorItem.Type.ROOT);
        Mockito.when((Object)item1.getType()).thenReturn((Object)DecisionNavigatorItem.Type.ITEM);
        Mockito.when((Object)item2.getType()).thenReturn((Object)DecisionNavigatorItem.Type.DECISION_TABLE);
        Mockito.when(this.indexedItems.values()).thenReturn(values);
        DecisionNavigatorItem actualRoot = this.presenter.findRoot();
        Assert.assertEquals((Object)expectedRoot, (Object)actualRoot);
    }

    private TreeSet<DecisionNavigatorItem> asTreeSet(final DecisionNavigatorItem ... items) {
        return new TreeSet<DecisionNavigatorItem>(){
            {
                this.addAll(Arrays.asList(items));
            }
        };
    }
}

