/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.common.messages;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.NodeList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessages;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessagesView;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class FlashMessagesViewTest {
    @Mock
    private HTMLDivElement errorContainer;
    @Mock
    private HTMLDivElement warningContainer;
    @Mock
    private HTMLElement strongErrorMessage;
    @Mock
    private HTMLElement regularErrorMessage;
    @Mock
    private HTMLElement strongWarningMessage;
    @Mock
    private HTMLElement regularWarningMessage;
    @Mock
    private HTMLButtonElement okButton;
    @Mock
    private HTMLButtonElement cancelButton;
    @Mock
    private FlashMessages presenter;
    private FlashMessagesView view;

    @Before
    public void setup() {
        this.view = (FlashMessagesView)Mockito.spy((Object)new FlashMessagesView(this.errorContainer, this.warningContainer, this.strongErrorMessage, this.regularErrorMessage, this.strongWarningMessage, this.regularWarningMessage, this.okButton, this.cancelButton));
        this.view.init(this.presenter);
    }

    @Test
    public void testOnOkWarningButtonClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).disableWarningHighlight();
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.onOkWarningButtonClick(event);
        ((FlashMessages)Mockito.verify((Object)this.presenter)).executeSuccessWarningCallback();
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).remove(new String[]{"opened"});
        ((FlashMessagesView)Mockito.verify((Object)this.view)).disableWarningHighlight();
    }

    @Test
    public void testOnCancelWarningButtonClick() {
        ClickEvent event = (ClickEvent)Mockito.mock(ClickEvent.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).disableWarningHighlight();
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.onCancelWarningButtonClick(event);
        ((FlashMessages)Mockito.verify((Object)this.presenter)).executeErrorWarningCallback();
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).remove(new String[]{"opened"});
        ((FlashMessagesView)Mockito.verify((Object)this.view)).disableWarningHighlight();
    }

    @Test
    public void testShowErrorMessage() {
        String expectedStrongMessage = "*message*";
        String expectedRegularMessage = "message";
        this.errorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showErrorMessage("*message*", "message");
        String actualStrongMessage = this.strongErrorMessage.textContent;
        String actualRegularMessage = this.regularErrorMessage.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.errorContainer.classList)).add(new String[]{"opened"});
        Assert.assertEquals((Object)"*message*", (Object)actualStrongMessage);
        Assert.assertEquals((Object)"message", (Object)actualRegularMessage);
    }

    @Test
    public void testShowWarningMessage() {
        String expectedStrongMessage = "*message*";
        String expectedRegularMessage = "message";
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showWarningMessage("*message*", "message");
        String actualStrongMessage = this.strongWarningMessage.textContent;
        String actualRegularMessage = this.regularWarningMessage.textContent;
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).add(new String[]{"opened"});
        Assert.assertEquals((Object)"*message*", (Object)actualStrongMessage);
        Assert.assertEquals((Object)"message", (Object)actualRegularMessage);
    }

    @Test
    public void testShowErrorHighlight() {
        String errorElementSelector = "#error-element-selector";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element errorElement = (Element)Mockito.mock(Element.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).enableErrorHighlight((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).setupDisableErrorHighlightCallbacks((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        element.parentNode = parentElement;
        Mockito.when((Object)parentElement.querySelector("#error-element-selector")).thenReturn((Object)errorElement);
        this.view.showErrorHighlight("#error-element-selector");
        ((FlashMessagesView)Mockito.verify((Object)this.view)).enableErrorHighlight(errorElement);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).setupDisableErrorHighlightCallbacks(errorElement);
        ((Element)Mockito.verify((Object)errorElement)).focus();
    }

    @Test
    public void testShowErrorHighlightWhenElementDoesNotExist() {
        String errorElementSelector = "#error-element-selector";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).enableErrorHighlight((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).setupDisableErrorHighlightCallbacks((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        element.parentNode = parentElement;
        Mockito.when((Object)parentElement.querySelector("#error-element-selector")).thenReturn(null);
        this.view.showErrorHighlight("#error-element-selector");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableErrorHighlight((Element)Matchers.any());
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setupDisableErrorHighlightCallbacks((Element)Matchers.any());
    }

    @Test
    public void testShowWarningHighlight() {
        String warningElementSelector = "#warning-element-selector";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element warningElement = (Element)Mockito.mock(Element.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).disableWarningHighlight();
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).enableWarningHighlight((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        element.parentNode = parentElement;
        Mockito.when((Object)parentElement.querySelector("#warning-element-selector")).thenReturn((Object)warningElement);
        this.view.showWarningHighlight("#warning-element-selector");
        ((FlashMessagesView)Mockito.verify((Object)this.view)).enableWarningHighlight(warningElement);
    }

    @Test
    public void testShowWarningHighlightWhenElementDoesNotExist() {
        String warningElementSelector = "#warning-element-selector";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).disableWarningHighlight();
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).enableWarningHighlight((Element)Matchers.any());
        ((FlashMessagesView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        element.parentNode = parentElement;
        Mockito.when((Object)parentElement.querySelector("#warning-element-selector")).thenReturn(null);
        this.view.showWarningHighlight("#warning-element-selector");
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableWarningHighlight((Element)Matchers.any());
    }

    @Test
    public void testEnableErrorHighlight() {
        Element errorElement = (Element)Mockito.mock(Element.class);
        errorElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.enableErrorHighlight(errorElement);
        ((DOMTokenList)Mockito.verify((Object)errorElement.classList)).add(new String[]{"kie-flash-message-error-element"});
    }

    @Test
    public void testEnableWarningHighlight() {
        Element warningElement = (Element)Mockito.mock(Element.class);
        warningElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.enableWarningHighlight(warningElement);
        ((DOMTokenList)Mockito.verify((Object)warningElement.classList)).add(new String[]{"kie-flash-message-warning-element"});
    }

    @Test
    public void testDisableErrorHighlightWhenErrorIsNotEnabled() {
        Element errorElement = (Element)Mockito.mock(Element.class);
        ArgumentCaptor timeoutLambdaCaptor = ArgumentCaptor.forClass(DomGlobal.SetTimeoutCallbackFn.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)Matchers.any(), Matchers.anyDouble());
        errorElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.errorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.disableErrorHighlight(errorElement);
        ((FlashMessagesView)Mockito.verify((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)timeoutLambdaCaptor.capture(), Matchers.eq((double)500.0));
        ((DOMTokenList)Mockito.verify((Object)errorElement.classList)).remove(new String[]{"kie-flash-message-error-element"});
        ((DomGlobal.SetTimeoutCallbackFn)timeoutLambdaCaptor.getValue()).onInvoke(new Object[0]);
        ((DOMTokenList)Mockito.verify((Object)this.errorContainer.classList)).remove(new String[]{"opened"});
        ((FlashMessagesView)Mockito.verify((Object)this.view)).teardownDisableErrorHighlightCallbacks(errorElement);
    }

    @Test
    public void testDisableWarningHighlight() {
        String warningElementSelector = ".kie-flash-message-warning-element";
        HTMLElement element = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement parentElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList warningElements = (NodeList)Mockito.spy((Object)new NodeList());
        Element warningElement1 = (Element)Mockito.mock(Element.class);
        Element warningElement2 = (Element)Mockito.mock(Element.class);
        ((NodeList)Mockito.doReturn((Object)warningElement1).when((Object)warningElements)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)warningElement2).when((Object)warningElements)).getAt(1);
        ((FlashMessagesView)Mockito.doReturn((Object)element).when((Object)this.view)).getElement();
        Mockito.when((Object)parentElement.querySelectorAll(".kie-flash-message-warning-element")).thenReturn((Object)warningElements);
        element.parentNode = parentElement;
        warningElements.length = 2.0;
        warningElement1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        warningElement2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.disableWarningHighlight();
        ((DOMTokenList)Mockito.verify((Object)warningElement1.classList)).remove(new String[]{"kie-flash-message-warning-element"});
        ((DOMTokenList)Mockito.verify((Object)warningElement2.classList)).remove(new String[]{"kie-flash-message-warning-element"});
    }

    @Test
    public void testTeardownDisableErrorHighlightCallbacks() {
        Element element = (Element)Mockito.mock(Element.class);
        Event event = (Event)Mockito.mock(Event.class);
        element.onkeypress = e -> false;
        element.onblur = e -> false;
        this.view.teardownDisableErrorHighlightCallbacks(element);
        Assert.assertTrue((boolean)Boolean.valueOf(element.onkeypress.onInvoke(event).toString()));
        Assert.assertTrue((boolean)Boolean.valueOf(element.onblur.onInvoke(event).toString()));
    }

    @Test
    public void testSetupDisableErrorHighlightCallbacks() {
        Event event = (Event)Mockito.mock(Event.class);
        Element errorElement = (Element)Mockito.mock(Element.class);
        ((FlashMessagesView)Mockito.doNothing().when((Object)this.view)).disableErrorHighlight((Element)Matchers.any());
        this.view.setupDisableErrorHighlightCallbacks(errorElement);
        errorElement.onkeypress.onInvoke(event);
        errorElement.onblur.onInvoke(event);
        ((FlashMessagesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).disableErrorHighlight(errorElement);
    }

    @Test
    public void testHideWarningContainer() {
        this.warningContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideWarningContainer();
        ((DOMTokenList)Mockito.verify((Object)this.warningContainer.classList)).remove(new String[]{"opened"});
    }

    @Test
    public void testHideErrorContainer() {
        this.errorContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideErrorContainer();
        ((DOMTokenList)Mockito.verify((Object)this.errorContainer.classList)).remove(new String[]{"opened"});
    }
}

