/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.docks.navigator.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.toolbar.ToolbarStateHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCacheImpl;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorTest {
    private static final String NODE_UUID = "uuid";
    private static final String DRG_NAME = "drg-name";
    @Mock
    private ExpressionEditorView view;
    @Mock
    private SessionPresenter sessionPresenter;
    @Mock
    private DecisionNavigatorPresenter decisionNavigator;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private DMNSession dmnSession;
    @Mock
    private ToolbarStateHandler toolbarStateHandler;
    @Mock
    private Command command;
    @Mock
    private ManagedSession session;
    @Mock
    private CanvasHandler canvasHandler;
    @Mock
    private Node node;
    @Mock
    private Definition definition;
    @Captor
    private ArgumentCaptor<Optional<HasName>> optionalHasNameCaptor;
    private Decision decision;
    private ExpressionEditor testedEditor;
    private ExpressionGridCache expressionGridCache;
    private Definitions definitions;

    @Before
    public void setUp() throws Exception {
        this.decision = new Decision();
        this.expressionGridCache = new ExpressionGridCacheImpl();
        this.definitions = new Definitions();
        this.definitions.setName(new Name(DRG_NAME));
        this.testedEditor = (ExpressionEditor)Mockito.spy((Object)new ExpressionEditor(this.view, this.decisionNavigator, this.dmnGraphUtils));
        this.testedEditor.bind(this.dmnSession);
        Mockito.when((Object)this.session.getCanvasControl((Class)Matchers.eq(ExpressionGridCache.class))).thenReturn((Object)this.expressionGridCache);
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions()).thenReturn((Object)this.definitions);
    }

    @Test
    public void testBind() {
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).bind((ClientSession)Matchers.eq((Object)this.dmnSession));
    }

    @Test
    public void testSetExpression() {
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, false);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setExpression((String)Matchers.eq((Object)NODE_UUID), (HasExpression)Matchers.eq((Object)this.decision), (Optional)Matchers.eq(Optional.of(this.decision)), Matchers.eq((boolean)false));
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setReturnToLinkText((String)Matchers.eq((Object)DRG_NAME));
        ((ToolbarStateHandler)Mockito.verify((Object)this.toolbarStateHandler)).enterGridView();
    }

    @Test
    public void testSetExpressionWhenOnlyVisualChangeAllowed() {
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, true);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setExpression((String)Matchers.eq((Object)NODE_UUID), (HasExpression)Matchers.eq((Object)this.decision), (Optional)Matchers.eq(Optional.of(this.decision)), Matchers.eq((boolean)true));
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setReturnToLinkText((String)Matchers.eq((Object)DRG_NAME));
        ((ToolbarStateHandler)Mockito.verify((Object)this.toolbarStateHandler)).enterGridView();
    }

    @Test
    public void testExitWithCommand() {
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, false);
        this.testedEditor.setExitCommand(this.command);
        this.testedEditor.exit();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.decisionNavigator)).clearSelections();
        ((ToolbarStateHandler)Mockito.verify((Object)this.toolbarStateHandler)).enterGraphView();
        ((Command)Mockito.verify((Object)this.command)).execute();
        Assert.assertEquals(Optional.empty(), (Object)this.testedEditor.getExitCommand());
    }

    @Test
    public void testSetExpressionWithoutToolbar() {
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, null, false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.toolbarStateHandler});
    }

    @Test
    public void testExitWithCommandWithoutToolbar() {
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, null, false);
        this.testedEditor.setExitCommand(this.command);
        this.testedEditor.exit();
        ((DecisionNavigatorPresenter)Mockito.verify((Object)this.decisionNavigator)).clearSelections();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.toolbarStateHandler});
        ((Command)Mockito.verify((Object)this.command)).execute();
        Assert.assertEquals(Optional.empty(), (Object)this.testedEditor.getExitCommand());
    }

    private void setupExpression(HasExpression hasExpression, HasName hasName, ToolbarStateHandler toolbarStateHandler, boolean isOnlyVisualChangeAllowed) {
        this.testedEditor.setToolbarStateHandler(toolbarStateHandler);
        this.testedEditor.setExpression(NODE_UUID, hasExpression, Optional.of(hasName), isOnlyVisualChangeAllowed);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setExpression((String)Matchers.eq((Object)NODE_UUID), (HasExpression)Matchers.eq((Object)hasExpression), (Optional)Matchers.eq(Optional.of(hasName)), Matchers.eq((boolean)isOnlyVisualChangeAllowed));
    }

    @Test
    public void testOnCanvasElementUpdated() {
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent(this.canvasHandler, (Element)this.node);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)this.decision);
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, false);
        this.testedEditor.handleCanvasElementUpdated(event);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setExpressionNameText((Optional)this.optionalHasNameCaptor.capture());
        Optional optionalHasName = (Optional)this.optionalHasNameCaptor.getValue();
        Assert.assertTrue((boolean)optionalHasName.isPresent());
        Assert.assertEquals((Object)this.decision, optionalHasName.get());
    }

    @Test
    public void testOnCanvasElementUpdatedDefinitions() {
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent(this.canvasHandler, (Element)this.node);
        String NEW_DRG_NAME = "new-drg-name";
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)this.definitions);
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, false);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setReturnToLinkText((String)Matchers.eq((Object)DRG_NAME));
        this.definitions.getName().setValue("new-drg-name");
        this.testedEditor.handleCanvasElementUpdated(event);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setReturnToLinkText((String)Matchers.eq((Object)"new-drg-name"));
    }

    @Test
    public void testOnCanvasElementUpdatedBusinessKnowledgeModel() {
        BusinessKnowledgeModel bkm = new BusinessKnowledgeModel();
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent(this.canvasHandler, (Element)this.node);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)bkm);
        this.setupExpression(bkm.asHasExpression(), (HasName)bkm, this.toolbarStateHandler, false);
        this.testedEditor.handleCanvasElementUpdated(event);
        ((ExpressionEditorView)Mockito.verify((Object)this.view)).setExpressionNameText((Optional)this.optionalHasNameCaptor.capture());
        Optional optionalHasName = (Optional)this.optionalHasNameCaptor.getValue();
        Assert.assertTrue((boolean)optionalHasName.isPresent());
        Assert.assertEquals((Object)bkm, optionalHasName.get());
    }

    @Test
    public void testOnCanvasElementUpdatedDifferentNode() {
        CanvasElementUpdatedEvent event = new CanvasElementUpdatedEvent(this.canvasHandler, (Element)this.node);
        Decision differentNodeDefinition = (Decision)Mockito.mock(Decision.class);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)differentNodeDefinition);
        this.setupExpression((HasExpression)this.decision, (HasName)this.decision, this.toolbarStateHandler, false);
        this.testedEditor.handleCanvasElementUpdated(event);
        ((ExpressionEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setExpressionNameText((Optional)Matchers.any(Optional.class));
    }

    @Test
    public void testIsActiveWhenExpressionEditorIsNotActive() {
        this.testedEditor.setExitCommand(null);
        Assert.assertFalse((boolean)this.testedEditor.isActive());
    }

    @Test
    public void testIsActiveWhenExpressionEditorIsActive() {
        this.testedEditor.setExitCommand((Command)Mockito.mock(Command.class));
        Assert.assertTrue((boolean)this.testedEditor.isActive());
    }
}

