/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types;

import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseColumnHeaderMetaDataContextMenuTest<M extends HasCellEditorControls & HasListSelectorControl> {
    protected static final String EDITOR_TITLE = "title";
    @Mock
    protected HasName hasName;
    @Mock
    protected HasTypeRef hasTypeRef;
    @Mock
    protected Consumer<HasName> clearDisplayNameConsumer;
    @Mock
    protected BiConsumer<HasName, Name> setDisplayNameConsumer;
    @Mock
    protected BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected NameAndDataTypePopoverView.Presenter editor;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    @Mock
    protected BiFunction<Integer, Integer, List<HasListSelectorControl.ListSelectorItem>> listSelectorItemsSupplier;
    @Mock
    protected Consumer<HasListSelectorControl.ListSelectorItem> listSelectorItemConsumer;
    @Mock
    protected HasListSelectorControl.ListSelectorItem item;
    protected M headerMetaData;

    @Before
    public void setup() {
        this.headerMetaData = this.getHeaderMetaData();
    }

    protected abstract M getHeaderMetaData();

    @Test
    public void testGetEditor() {
        Assertions.assertThat((Optional)this.headerMetaData.getEditor()).isEqualTo(Optional.of(this.listSelector));
    }

    @Test
    public void testGetItems() {
        ((HasListSelectorControl)this.headerMetaData).getItems(0, 1);
        ((BiFunction)Mockito.verify(this.listSelectorItemsSupplier)).apply(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testOnItemSelected() {
        ((HasListSelectorControl)this.headerMetaData).onItemSelected(this.item);
        ((Consumer)Mockito.verify(this.listSelectorItemConsumer)).accept(Matchers.eq((Object)this.item));
    }
}

