/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.OutputClause;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableEditorDefinitionEnricher;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.EventSourceMock;

public abstract class BaseDecisionTableEditorDefinitionTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private HitPolicyPopoverView.Presenter hitPolicyEditor;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Mock
    private NameAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    protected ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    protected GridCellTuple parent;
    protected Decision decision = new Decision();
    protected Optional<HasName> hasName = Optional.of(HasName.NOP);
    protected Graph<?, Node> graph = new GraphImpl(UUID.uuid(), (GraphNodeStore)new GraphNodeStoreImpl());
    protected DecisionTableEditorDefinition definition;

    @Before
    public void setup() {
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        this.definition = new DecisionTableEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.hitPolicyEditor, this.headerEditor, new DecisionTableEditorDefinitionEnricher(this.sessionManager, new DMNGraphUtils(this.sessionManager, new DMNDiagramUtils()), this.itemDefinitionUtils));
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn(this.graph);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    protected void assertBasicEnrichment(DecisionTable model) {
        Assertions.assertThat((Comparable)model.getHitPolicy()).isEqualTo((Object)HitPolicy.UNIQUE);
        Assertions.assertThat((Comparable)model.getPreferredOrientation()).isEqualTo((Object)DecisionTableOrientation.RULE_AS_ROW);
    }

    protected void assertStandardInputClauseEnrichment(DecisionTable model) {
        List input = model.getInput();
        Assertions.assertThat((int)input.size()).isEqualTo(1);
        Assertions.assertThat((Object)((InputClause)input.get(0)).getInputExpression()).isInstanceOf(InputClauseLiteralExpression.class);
        Assertions.assertThat((String)((InputClause)input.get(0)).getInputExpression().getText().getValue()).isEqualTo((Object)"input-1");
    }

    protected void assertStandardOutputClauseEnrichment(DecisionTable model) {
        List output = model.getOutput();
        Assertions.assertThat((int)output.size()).isEqualTo(1);
        Assertions.assertThat((String)((OutputClause)output.get(0)).getName()).isEqualTo((Object)"output-1");
    }

    protected void assertStandardDecisionRuleEnrichment(DecisionTable model, int inputClauseCount, int outputClauseCount) {
        List rules = model.getRule();
        Assertions.assertThat((int)rules.size()).isEqualTo(1);
        DecisionRule rule = (DecisionRule)rules.get(0);
        Assertions.assertThat((int)rule.getInputEntry().size()).isEqualTo(inputClauseCount);
        rule.getInputEntry().forEach(inputEntry -> {
            Assertions.assertThat((Object)inputEntry).isInstanceOf(UnaryTests.class);
            Assertions.assertThat((String)inputEntry.getText().getValue()).isEqualTo((Object)"");
        });
        Assertions.assertThat((int)rule.getOutputEntry().size()).isEqualTo(outputClauseCount);
        rule.getOutputEntry().forEach(outputEntry -> {
            Assertions.assertThat((Object)outputEntry).isInstanceOf(LiteralExpression.class);
            Assertions.assertThat((String)outputEntry.getText().getValue()).isEqualTo((Object)"");
        });
        Assertions.assertThat((Object)rule.getDescription()).isNotNull();
        Assertions.assertThat((String)rule.getDescription().getValue()).isEqualTo((Object)"");
    }

    protected void assertParentHierarchyEnrichment(DecisionTable model, int inputClauseCount, int outputClauseCount) {
        List rules = model.getRule();
        DecisionRule rule = (DecisionRule)rules.get(0);
        List inputClauses = model.getInput();
        Assertions.assertThat((int)inputClauses.size()).isEqualTo(inputClauseCount);
        inputClauses.forEach(inputClause -> {
            Assertions.assertThat((Object)inputClause.getParent()).isEqualTo((Object)model);
            Assertions.assertThat((Object)inputClause.getInputExpression().getParent()).isEqualTo(inputClause);
        });
        List outputClauses = model.getOutput();
        Assertions.assertThat((int)outputClauses.size()).isEqualTo(outputClauseCount);
        outputClauses.forEach(outputClause -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)outputClause.getParent()).isEqualTo((Object)model);
        });
        Assertions.assertThat((Object)rule.getParent()).isEqualTo((Object)model);
        List inputEntries = rule.getInputEntry();
        Assertions.assertThat((int)inputEntries.size()).isEqualTo(inputClauseCount);
        inputEntries.forEach(inputEntry -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)inputEntry.getParent()).isEqualTo((Object)rule);
        });
        List outputEntries = rule.getOutputEntry();
        Assertions.assertThat((int)outputEntries.size()).isEqualTo(outputClauseCount);
        outputEntries.forEach(outputEntry -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)Assertions.assertThat((Object)outputEntry.getParent()).isEqualTo((Object)rule);
        });
    }
}

