/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.RowNumberColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.mockito.Mock;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RowNumberColumnHeaderMetaDataTest {
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private HitPolicyPopoverView.Presenter hitPolicyEditor;
    @Mock
    private DecisionTableGrid gridWidget;
    @Mock
    private Transform transform;
    @Mock
    private GridRenderer renderer;
    private HitPolicy hitPolicy = HitPolicy.ANY;
    private BuiltinAggregator builtinAggregator = null;
    private RowNumberColumnHeaderMetaData header;

    @Before
    public void setup() {
        this.header = new RowNumberColumnHeaderMetaData(this.hitPolicySupplier(), this.builtinAggregatorSupplier(), this.cellEditorControls, this.hitPolicyEditor, Optional.of("DecisionTableEditor.EditHitPolicy"), this.gridWidget);
    }

    private Supplier<HitPolicy> hitPolicySupplier() {
        return () -> this.hitPolicy;
    }

    private Supplier<BuiltinAggregator> builtinAggregatorSupplier() {
        return () -> this.builtinAggregator;
    }

    @Test
    public void testTitle_Without_Aggregator() {
        this.testTitle(HitPolicy.ANY, null, "A");
        this.testTitle(HitPolicy.COLLECT, null, "C");
        this.testTitle(HitPolicy.FIRST, null, "F");
        this.testTitle(HitPolicy.OUTPUT_ORDER, null, "O");
        this.testTitle(HitPolicy.PRIORITY, null, "P");
        this.testTitle(HitPolicy.RULE_ORDER, null, "R");
        this.testTitle(HitPolicy.UNIQUE, null, "U");
    }

    @Test
    public void testTitle_Count() {
        this.testTitle(HitPolicy.ANY, BuiltinAggregator.COUNT, "A");
        this.testTitle(HitPolicy.COLLECT, BuiltinAggregator.COUNT, "C#");
        this.testTitle(HitPolicy.FIRST, BuiltinAggregator.COUNT, "F");
        this.testTitle(HitPolicy.OUTPUT_ORDER, BuiltinAggregator.COUNT, "O");
        this.testTitle(HitPolicy.PRIORITY, BuiltinAggregator.COUNT, "P");
        this.testTitle(HitPolicy.RULE_ORDER, BuiltinAggregator.COUNT, "R");
        this.testTitle(HitPolicy.UNIQUE, BuiltinAggregator.COUNT, "U");
    }

    @Test
    public void testTitle_Max() {
        this.testTitle(HitPolicy.ANY, BuiltinAggregator.MAX, "A");
        this.testTitle(HitPolicy.COLLECT, BuiltinAggregator.MAX, "C>");
        this.testTitle(HitPolicy.FIRST, BuiltinAggregator.MAX, "F");
        this.testTitle(HitPolicy.OUTPUT_ORDER, BuiltinAggregator.MAX, "O");
        this.testTitle(HitPolicy.PRIORITY, BuiltinAggregator.MAX, "P");
        this.testTitle(HitPolicy.RULE_ORDER, BuiltinAggregator.MAX, "R");
        this.testTitle(HitPolicy.UNIQUE, BuiltinAggregator.MAX, "U");
    }

    @Test
    public void testTitle_Min() {
        this.testTitle(HitPolicy.ANY, BuiltinAggregator.MIN, "A");
        this.testTitle(HitPolicy.COLLECT, BuiltinAggregator.MIN, "C<");
        this.testTitle(HitPolicy.FIRST, BuiltinAggregator.MIN, "F");
        this.testTitle(HitPolicy.OUTPUT_ORDER, BuiltinAggregator.MIN, "O");
        this.testTitle(HitPolicy.PRIORITY, BuiltinAggregator.MIN, "P");
        this.testTitle(HitPolicy.RULE_ORDER, BuiltinAggregator.MIN, "R");
        this.testTitle(HitPolicy.UNIQUE, BuiltinAggregator.MIN, "U");
    }

    @Test
    public void testTitle_Sum() {
        this.testTitle(HitPolicy.ANY, BuiltinAggregator.SUM, "A");
        this.testTitle(HitPolicy.COLLECT, BuiltinAggregator.SUM, "C+");
        this.testTitle(HitPolicy.FIRST, BuiltinAggregator.SUM, "F");
        this.testTitle(HitPolicy.OUTPUT_ORDER, BuiltinAggregator.SUM, "O");
        this.testTitle(HitPolicy.PRIORITY, BuiltinAggregator.SUM, "P");
        this.testTitle(HitPolicy.RULE_ORDER, BuiltinAggregator.SUM, "R");
        this.testTitle(HitPolicy.UNIQUE, BuiltinAggregator.SUM, "U");
    }

    private void testTitle(HitPolicy hitPolicy, BuiltinAggregator builtinAggregator, String expected) {
        this.hitPolicy = hitPolicy;
        this.builtinAggregator = builtinAggregator;
        Assert.assertEquals((Object)expected, (Object)this.header.getTitle());
    }
}

