/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class ParametersPopoverImplTest {
    private static final int ROW_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private static final String PARAMETER_NAME = "name";
    private static final QName PARAMETER_TYPE_REF = new QName("", BuiltInType.DATE.getName());
    @Mock
    private ParametersPopoverView view;
    @Mock
    private InformationItem parameter;
    @Captor
    private ArgumentCaptor<Command> commandCaptor;
    @Captor
    private ArgumentCaptor<String> parameterNameCaptor;
    @Captor
    private ArgumentCaptor<QName> parameterTYpeRefCaptor;
    private ParametersPopoverView.Presenter presenter;
    private final List<InformationItem> parameters = new ArrayList<InformationItem>();
    private HasParametersControl control = (HasParametersControl)Mockito.spy((Object)new MockHasParametersControl());

    @Before
    public void setup() {
        this.presenter = new ParametersPopoverImpl(this.view);
    }

    @Test
    public void testGetElement() {
        this.presenter.getElement();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).getElement();
    }

    @Test
    public void testBindNullControl() {
        this.presenter.bind(null, 0, 1);
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setParameters(Matchers.anyList());
    }

    @Test
    public void testBindNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)Matchers.eq(this.parameters));
    }

    @Test
    public void testShowNullControl() {
        this.presenter.show(Optional.empty());
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).show((Optional)Matchers.any(Optional.class));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Matchers.anyInt());
    }

    @Test
    public void testShowNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.show(Optional.empty());
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).show((Optional)Matchers.eq(Optional.empty()));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Matchers.anyInt());
    }

    @Test
    public void testShowNonNullControlWithParameters() {
        this.parameters.add(new InformationItem());
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.show(Optional.empty());
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).show((Optional)Matchers.eq(Optional.empty()));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testHideNullControl() {
        this.presenter.hide();
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide();
    }

    @Test
    public void testHideNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.hide();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testAddParameterNullControl() {
        this.presenter.addParameter();
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).addParameter((Command)Matchers.any(Command.class));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Matchers.anyInt());
    }

    @Test
    public void testAddParameterNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.addParameter();
        ((HasParametersControl)Mockito.verify((Object)this.control)).addParameter((Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)Matchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testRemoveParameterNullControl() {
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).removeParameter((InformationItem)Matchers.any(InformationItem.class), (Command)Matchers.any(Command.class));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Matchers.anyInt());
    }

    @Test
    public void testRemoveLastParameterNonNullControl() {
        this.parameters.add(this.parameter);
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control)).removeParameter((InformationItem)Matchers.eq((Object)this.parameter), (Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)Matchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).focusParameter(Matchers.anyInt());
    }

    @Test
    public void testRemoveParameterNonNullControl() {
        this.parameters.add(new InformationItem());
        this.parameters.add(this.parameter);
        this.presenter.bind((Object)this.control, 0, 1);
        Mockito.reset((Object[])new ParametersPopoverView[]{this.view});
        this.presenter.removeParameter(this.parameter);
        ((HasParametersControl)Mockito.verify((Object)this.control)).removeParameter((InformationItem)Matchers.eq((Object)this.parameter), (Command)this.commandCaptor.capture());
        ((Command)this.commandCaptor.getValue()).execute();
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).setParameters((List)Matchers.eq(this.parameters));
        ((ParametersPopoverView)Mockito.verify((Object)this.view)).focusParameter(0);
    }

    @Test
    public void testUpdateParameterNameNullControl() {
        this.presenter.updateParameterName(this.parameter, PARAMETER_NAME);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).updateParameterName((InformationItem)Matchers.any(InformationItem.class), (String)Matchers.any(String.class));
    }

    @Test
    public void testUpdateParameterNameNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterName(this.parameter, PARAMETER_NAME);
        ((HasParametersControl)Mockito.verify((Object)this.control)).updateParameterName((InformationItem)Matchers.eq((Object)this.parameter), (String)this.parameterNameCaptor.capture());
        Assertions.assertThat((String)((String)this.parameterNameCaptor.getValue())).isEqualTo((Object)PARAMETER_NAME);
    }

    @Test
    public void testUpdateParameterTypeRefNullControl() {
        this.presenter.updateParameterTypeRef(this.parameter, PARAMETER_TYPE_REF);
        ((HasParametersControl)Mockito.verify((Object)this.control, (VerificationMode)Mockito.never())).updateParameterTypeRef((InformationItem)Matchers.any(InformationItem.class), (QName)Matchers.any(QName.class));
    }

    @Test
    public void testUpdateParameterTypeRefNonNullControl() {
        this.presenter.bind((Object)this.control, 0, 1);
        this.presenter.updateParameterTypeRef(this.parameter, PARAMETER_TYPE_REF);
        ((HasParametersControl)Mockito.verify((Object)this.control)).updateParameterTypeRef((InformationItem)Matchers.eq((Object)this.parameter), (QName)this.parameterTYpeRefCaptor.capture());
        Assertions.assertThat((Object)this.parameterTYpeRefCaptor.getValue()).isEqualTo((Object)PARAMETER_TYPE_REF);
    }

    protected class MockHasParametersControl
    implements HasParametersControl {
        protected MockHasParametersControl() {
        }

        public List<InformationItem> getParameters() {
            return ParametersPopoverImplTest.this.parameters;
        }

        public void addParameter(Command onSuccess) {
            ParametersPopoverImplTest.this.parameters.add(new InformationItem());
        }

        public void removeParameter(InformationItem parameter, Command onSuccess) {
            ParametersPopoverImplTest.this.parameters.remove(parameter);
        }

        public void updateParameterName(InformationItem parameter, String name) {
        }

        public void updateParameterTypeRef(InformationItem parameter, QName typeRef) {
        }
    }
}

