/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.LiteralExpressionPMMLColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.LiteralExpressionPMMLGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.PMMLDocumentMetadataProvider;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.BaseLiteralExpressionGridTest;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseDelegatingExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.handlers.DelegatingGridWidgetCellSelectorMouseEventHandler;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@RunWith(value=LienzoMockitoTestRunner.class)
public abstract class BaseLiteralExpressionPMMLGridTest
extends BaseLiteralExpressionGridTest<LiteralExpressionPMMLGrid> {
    @Mock
    protected PMMLDocumentMetadataProvider pmmlDocumentMetadataProvider;
    @Mock
    protected FunctionSupplementaryGrid parentGridWidget;
    @Mock
    protected LiteralExpressionPMMLGrid pmmlValueEditor;
    @Captor
    protected ArgumentCaptor<GridCellValueTuple<GridCellValue<String>>> pmmlValueEditorCellHasValueCommandParameterCaptor;

    @Override
    protected void setupGrid(int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (BaseDelegatingExpressionGrid)Mockito.spy((Object)((LiteralExpressionPMMLGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of("uuid") : Optional.empty(), (HasExpression)this.hasExpression, this.hasName, false, nesting).get()));
    }

    @Test
    public void testMouseClickEventHandlers() {
        this.setupGrid(0);
        List handlers = ((LiteralExpressionPMMLGrid)this.grid).getNodeMouseClickEventHandlers(this.selectionManager);
        Assertions.assertThat((List)handlers).hasSize(1);
        Assertions.assertThat(handlers.get(0)).isInstanceOf(DelegatingGridWidgetCellSelectorMouseEventHandler.class);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = ((LiteralExpressionPMMLGrid)this.grid).getModel();
        Assertions.assertThat((Object)uiModel).isInstanceOf(DMNGridData.class);
        Assertions.assertThat((int)uiModel.getColumnCount()).isEqualTo(1);
        Assertions.assertThat(uiModel.getColumns().get(0)).isInstanceOf(LiteralExpressionPMMLColumn.class);
        Assertions.assertThat((int)uiModel.getRowCount()).isEqualTo(1);
        Assertions.assertThat((Object)uiModel.getCell(0, 0).getValue().getValue()).isEqualTo((Object)"expression");
    }

    @Test
    public void testBodyFactory() {
        this.setupGrid(1);
        TextAreaSingletonDOMElementFactory factory = ((LiteralExpressionPMMLGrid)this.grid).getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(CompositeCommand.class);
    }
}

