/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationDefaultValueUtilities;

public class InvocationDefaultValueUtilitiesTest {
    private Invocation invocation;

    @Before
    public void setup() {
        this.invocation = new Invocation();
    }

    @Test
    public void testGetNewParameterName() {
        Binding binding1 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding1);
        binding1.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding1.getParameter().getName().getValue()).isEqualTo((Object)"p-1");
        Binding binding2 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding2);
        binding2.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding2.getParameter().getName().getValue()).isEqualTo((Object)"p-2");
    }

    @Test
    public void testGetNewParameterNameWithExistingParameters() {
        Binding binding1 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding1);
        binding1.getParameter().getName().setValue("binding");
        Binding binding2 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding2);
        binding2.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding2.getParameter().getName().getValue()).isEqualTo((Object)"p-1");
    }

    @Test
    public void testGetNewParameterNameWithDeletion() {
        Binding binding1 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding1);
        binding1.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding1.getParameter().getName().getValue()).isEqualTo((Object)"p-1");
        Binding binding2 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding2);
        binding2.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding2.getParameter().getName().getValue()).isEqualTo((Object)"p-2");
        this.invocation.getBinding().remove(binding1);
        Binding binding3 = new Binding(){
            {
                this.setParameter(new InformationItem());
            }
        };
        this.invocation.getBinding().add(binding3);
        binding3.getParameter().getName().setValue(InvocationDefaultValueUtilities.getNewParameterName((Invocation)this.invocation));
        Assertions.assertThat((String)binding3.getParameter().getName().getValue()).isEqualTo((Object)"p-3");
    }
}

