/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import com.ait.lienzo.client.core.shape.ContainerNode;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.ui.AbsolutePanel;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.model.Binding;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.Invocation;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.AddParameterBindingCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.DeleteParameterBindingCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.DeleteHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHasNameCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetHeaderValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetTypeRefCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.GridFactoryCommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnExpressionHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationParameterColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.types.HasNameAndTypeRef;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseBounds;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class InvocationGridTest {
    private static final int HEADER = 0;
    private static final int INSERT_PARAMETER = 1;
    private static final int INSERT_PARAMETER_ABOVE = 1;
    private static final int INSERT_PARAMETER_BELOW = 2;
    private static final int DELETE_PARAMETER = 3;
    private static final int DIVIDER = 4;
    private static final int CLEAR_EXPRESSION_TYPE = 5;
    private static final String NODE_UUID = "uuid";
    private static final String NAME = "name";
    private static final String NAME_NEW = "name-new";
    private static final String EXPRESSION_TEXT_NEW = "invocation-expression-new";
    private GridCellTuple tupleWithoutValue;
    private GridCellValueTuple tupleWithValue;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private AbsolutePanel gridLayerDomElementContainer;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Diagram diagram;
    @Mock
    private Graph graph;
    @Mock
    private Node node;
    @Mock
    private Index index;
    @Mock
    private Element element;
    @Mock
    private GraphCommandExecutionContext graphContext;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private ListSelectorView.Presenter listSelector;
    @Mock
    private TranslationService translationService;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private NameAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    private GridWidget parentGridWidget;
    @Mock
    private GridData parentGridData;
    @Mock
    private GridColumn parentGridColumn;
    @Mock
    private GridCellTuple parent;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private UndefinedExpressionEditorDefinition undefinedExpressionEditorDefinition;
    @Mock
    private UndefinedExpressionGrid undefinedExpressionEditor;
    @Mock
    private GridWidgetDnDHandlersState dndHandlersState;
    @Mock
    private EventSourceMock<ExpressionEditorChanged> editorSelectedEvent;
    @Mock
    private EventSourceMock<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    @Mock
    private EventSourceMock<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    @Captor
    private ArgumentCaptor<AddParameterBindingCommand> addParameterBindingCommandCaptor;
    @Captor
    private ArgumentCaptor<DeleteParameterBindingCommand> deleteParameterBindingCommandCaptor;
    @Captor
    private ArgumentCaptor<ClearExpressionTypeCommand> clearExpressionTypeCommandCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCommandCaptor;
    @Captor
    private ArgumentCaptor<CompositeCommand> compositeCommandCaptor;
    @Captor
    private ArgumentCaptor<DomainObjectSelectionEvent> domainObjectSelectionEventCaptor;
    private Decision hasExpression = new Decision();
    private LiteralExpression literalExpression = new LiteralExpression();
    private Optional<Invocation> expression = Optional.empty();
    private Optional<HasName> hasName = Optional.empty();
    private InvocationEditorDefinition definition;
    private InvocationGrid grid;

    @Before
    public void setup() {
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.parentGridWidget);
        Mockito.when((Object)this.parentGridWidget.getModel()).thenReturn((Object)this.parentGridData);
        Mockito.when((Object)this.parentGridData.getColumns()).thenReturn(Collections.singletonList(this.parentGridColumn));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getGridPanel()).thenReturn((Object)this.gridPanel);
        Mockito.when((Object)this.session.getGridLayer()).thenReturn((Object)this.gridLayer);
        Mockito.when((Object)this.session.getCellEditorControls()).thenReturn((Object)this.cellEditorControls);
        this.tupleWithoutValue = new GridCellTuple(0, 1, this.gridWidget);
        this.tupleWithValue = new GridCellValueTuple(0, 1, this.gridWidget, (GridCellValue)new BaseGridCellValue((Object)"value"));
        this.definition = new InvocationEditorDefinition(this.definitionUtils, this.sessionManager, this.sessionCommandManager, this.canvasCommandFactory, this.editorSelectedEvent, this.refreshFormPropertiesEvent, this.domainObjectSelectionEvent, this.listSelector, this.translationService, this.expressionEditorDefinitionsSupplier, this.headerEditor);
        this.expression = this.definition.getModelClass();
        this.definition.enrich(Optional.empty(), (HasExpression)this.hasExpression, this.expression);
        this.expression.ifPresent(invocation -> ((LiteralExpression)invocation.getExpression()).getText().setValue("invocation-expression"));
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.undefinedExpressionEditorDefinition);
        Mockito.when((Object)this.expressionEditorDefinitionsSupplier.get()).thenReturn((Object)expressionEditorDefinitions);
        Mockito.when((Object)this.literalExpressionEditorDefinition.getModelClass()).thenReturn(Optional.of(this.literalExpression));
        Mockito.when((Object)this.literalExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.literalExpressionEditor));
        Mockito.when((Object)this.undefinedExpressionEditor.getParentInformation()).thenReturn((Object)this.parent);
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getModelClass()).thenReturn(Optional.empty());
        Mockito.when((Object)this.undefinedExpressionEditorDefinition.getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (Optional)Matchers.any(Optional.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean(), Matchers.anyInt())).thenReturn(Optional.of(this.undefinedExpressionEditor));
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphContext);
        Decision decision = new Decision();
        decision.setName(new Name(NAME));
        this.hasName = Optional.of(decision);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData(false));
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)this.gridLayerDomElementContainer);
        Mockito.when((Object)this.gridLayerDomElementContainer.iterator()).thenReturn(Mockito.mock(Iterator.class));
        Mockito.when((Object)this.gridLayer.getVisibleBounds()).thenReturn((Object)new BaseBounds(0.0, 0.0, 100.0, 200.0));
        Mockito.when((Object)this.gridLayer.getViewport()).thenReturn((Object)this.viewport);
        Mockito.when((Object)this.viewport.getTransform()).thenReturn((Object)this.transform);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph);
        Mockito.when((Object)this.graph.nodes()).thenReturn(Collections.singletonList(this.node));
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)this.index.get(Matchers.anyString())).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.getContent()).thenReturn(Mockito.mock(Definition.class));
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(Matchers.any())).thenReturn((Object)NAME);
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)Matchers.any(Element.class), Matchers.anyString(), Matchers.any())).thenReturn(Mockito.mock(UpdateElementPropertyCommand.class));
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0].toString()).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    private void setupGrid(int nesting) {
        this.hasExpression.setExpression((Expression)this.expression.get());
        this.grid = (InvocationGrid)Mockito.spy((Object)((InvocationGrid)this.definition.getEditor(this.parent, nesting == 0 ? Optional.of(NODE_UUID) : Optional.empty(), (HasExpression)this.hasExpression, this.hasName, false, nesting).get()));
        Mockito.when((Object)this.parent.getGridWidget()).thenReturn((Object)this.gridWidget);
        Mockito.when((Object)this.parent.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.parent.getColumnIndex()).thenReturn((Object)2);
    }

    @Test
    public void testInitialSetupFromDefinition() {
        this.setupGrid(0);
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof InvocationGridData));
        Assert.assertEquals((long)3L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof InvocationParameterColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(2) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"p-1", (Object)((InformationItemCell.HasNameAndDataTypeCell)uiModel.getCell(0, 1).getValue().getValue()).getName().getValue());
        Assert.assertTrue((boolean)(uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv0 = (ExpressionCellValue)uiModel.getCell(0, 2).getValue();
        Assert.assertEquals((Object)this.undefinedExpressionEditor, ((Optional)dcv0.getValue()).get());
    }

    @Test
    public void testInitialColumnWidthsFromDefinition() {
        this.setupGrid(0);
        this.assertComponentWidths(50.0, 100.0, 150.0);
    }

    @Test
    public void testInitialColumnWidthsFromExpression() {
        List componentWidths = this.expression.get().getComponentWidths();
        componentWidths.set(0, 100.0);
        componentWidths.set(1, 200.0);
        componentWidths.set(2, 300.0);
        this.setupGrid(0);
        this.assertComponentWidths(100.0, 200.0, 300.0);
    }

    private void assertComponentWidths(double ... widths) {
        GridData uiModel = this.grid.getModel();
        IntStream.range(0, widths.length).forEach(i -> Assert.assertEquals((double)widths[i], (double)((GridColumn)uiModel.getColumns().get(i)).getWidth(), (double)0.0));
    }

    @Test
    public void testCacheable() {
        this.setupGrid(0);
        Assert.assertTrue((boolean)this.grid.isCacheable());
    }

    @Test
    public void testNameColumnMetaData() {
        this.setupGrid(0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof InvocationColumnHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof InvocationColumnExpressionHeaderMetaData));
        InvocationColumnHeaderMetaData md1 = (InvocationColumnHeaderMetaData)header.get(0);
        InvocationColumnExpressionHeaderMetaData md2 = (InvocationColumnExpressionHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)NAME, (Object)md1.getTitle());
        Assert.assertEquals((Object)"invocation-expression", (Object)md2.getTitle());
    }

    @Test
    public void testNameColumnMetaDataWhenNested() {
        this.setupGrid(1);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof InvocationColumnExpressionHeaderMetaData));
        InvocationColumnExpressionHeaderMetaData md1 = (InvocationColumnExpressionHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)"invocation-expression", (Object)md1.getTitle());
    }

    @Test
    public void testExpressionColumnMetaData() {
        this.setupGrid(0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof InvocationColumnHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof InvocationColumnExpressionHeaderMetaData));
        InvocationColumnHeaderMetaData md1 = (InvocationColumnHeaderMetaData)header.get(0);
        InvocationColumnExpressionHeaderMetaData md2 = (InvocationColumnExpressionHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)NAME, (Object)md1.getTitle());
        Assert.assertEquals((Object)"invocation-expression", (Object)md2.getTitle());
    }

    @Test
    public void testExpressionColumnMetaDataWhenNested() {
        this.setupGrid(1);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)1L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof InvocationColumnExpressionHeaderMetaData));
        InvocationColumnExpressionHeaderMetaData md1 = (InvocationColumnExpressionHeaderMetaData)header.get(0);
        Assert.assertEquals((Object)"invocation-expression", (Object)md1.getTitle());
    }

    @Test
    public void testExpressionColumnMetaDataSetExpressionText() {
        this.setupGrid(0);
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        InvocationColumnExpressionHeaderMetaData md2 = (InvocationColumnExpressionHeaderMetaData)header.get(1);
        md2.setTitle(EXPRESSION_TEXT_NEW);
        Assert.assertEquals((Object)EXPRESSION_TEXT_NEW, (Object)((LiteralExpression)this.expression.get().getExpression()).getText().getValue());
    }

    @Test
    public void testGetItemsRowNumberColumn() {
        this.setupGrid(0);
        this.assertDefaultListItems(this.grid.getItems(0, 0), true);
    }

    @Test
    public void testOnItemSelectedNameColumn() {
        this.setupGrid(0);
        this.assertDefaultListItems(this.grid.getItems(0, 1), true);
    }

    @Test
    public void testOnItemSelectedExpressionColumnUndefinedExpressionType() {
        this.setupGrid(0);
        this.assertDefaultListItems(this.grid.getItems(0, 2), true);
    }

    @Test
    public void testOnItemSelectedExpressionColumnDefinedExpressionType() {
        this.setupGrid(0);
        BaseExpressionGrid editor = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        this.grid.getModel().setCellValue(0, 2, (GridCellValue)new ExpressionCellValue(Optional.of(editor)));
        List items = this.grid.getItems(0, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(6);
        this.assertDefaultListItems(items.subList(0, 4), true);
        Assertions.assertThat(items.get(4)).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(5), "ExpressionEditor.Clear", true);
        ((HasListSelectorControl.ListSelectorTextItem)items.get(5)).getCommand().execute();
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(ClearExpressionTypeCommand.class));
    }

    @Test
    public void testGetItemsWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid(0);
        this.addParameterBinding(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        this.assertDefaultListItems(this.grid.getItems(0, 0), false);
    }

    @Test
    public void testOnItemSelectedExpressionColumnDefinedExpressionTypeWithCellSelectionsCoveringMultipleRows() {
        this.setupGrid(0);
        this.addParameterBinding(0);
        this.grid.getModel().selectCell(0, 0);
        this.grid.getModel().selectCell(1, 0);
        BaseExpressionGrid editor = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        this.grid.getModel().setCellValue(0, 2, (GridCellValue)new ExpressionCellValue(Optional.of(editor)));
        List items = this.grid.getItems(0, 2);
        Assertions.assertThat((int)items.size()).isEqualTo(6);
        this.assertDefaultListItems(items.subList(0, 4), false);
        Assertions.assertThat(items.get(4)).isInstanceOf(HasListSelectorControl.ListSelectorDividerItem.class);
        this.assertListSelectorTextItem((HasListSelectorControl.ListSelectorItem)items.get(5), "ExpressionEditor.Clear", false);
    }

    @Test
    public void testGetHeaderItemsRowNumberColumn() {
        this.setupGrid(0);
        this.assertDefaultHeaderListItems(this.grid.getHeaderItems(0, 0));
    }

    @Test
    public void testGetHeaderItemsNameColumn() {
        this.setupGrid(0);
        this.assertDefaultHeaderListItems(this.grid.getHeaderItems(0, 1));
    }

    @Test
    public void testGetHeaderItemsExpressionColumn() {
        this.setupGrid(0);
        this.assertDefaultHeaderListItems(this.grid.getHeaderItems(0, 2));
    }

    private void assertDefaultListItems(List<HasListSelectorControl.ListSelectorItem> items, boolean enabled) {
        Assertions.assertThat((int)items.size()).isEqualTo(4);
        this.assertListSelectorHeaderItem(items.get(0), "InvocationEditor.Header");
        this.assertListSelectorTextItem(items.get(1), "InvocationEditor.InsertParameterAbove", enabled);
        this.assertListSelectorTextItem(items.get(2), "InvocationEditor.InsertParameterBelow", enabled);
        this.assertListSelectorTextItem(items.get(3), "InvocationEditor.DeleteParameter", enabled && this.grid.getModel().getRowCount() > 1);
    }

    private void assertListSelectorHeaderItem(HasListSelectorControl.ListSelectorItem item, String text) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorHeaderItem.class);
        HasListSelectorControl.ListSelectorHeaderItem hi = (HasListSelectorControl.ListSelectorHeaderItem)item;
        Assertions.assertThat((String)hi.getText()).isEqualTo((Object)text);
    }

    private void assertListSelectorTextItem(HasListSelectorControl.ListSelectorItem item, String text, boolean enabled) {
        Assertions.assertThat((Object)item).isInstanceOf(HasListSelectorControl.ListSelectorTextItem.class);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)item;
        Assertions.assertThat((String)ti.getText()).isEqualTo((Object)text);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    private void assertDefaultHeaderListItems(List<HasListSelectorControl.ListSelectorItem> items) {
        Assertions.assertThat((int)items.size()).isEqualTo(2);
        this.assertListSelectorHeaderItem(items.get(0), "InvocationEditor.Header");
        this.assertListSelectorTextItem(items.get(1), "InvocationEditor.InsertParameter", true);
    }

    @Test
    public void testOnItemSelected() {
        this.setupGrid(0);
        Command command = (Command)Mockito.mock(Command.class);
        HasListSelectorControl.ListSelectorTextItem listSelectorItem = (HasListSelectorControl.ListSelectorTextItem)Mockito.mock(HasListSelectorControl.ListSelectorTextItem.class);
        Mockito.when((Object)listSelectorItem.getCommand()).thenReturn((Object)command);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)listSelectorItem);
        ((Command)Mockito.verify((Object)command)).execute();
    }

    @Test
    public void testOnItemSelectedInsertParameterAbove() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((InvocationGrid)Mockito.verify((Object)this.grid)).addParameterBinding(Matchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedInsertParameterBelow() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(2);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((InvocationGrid)Mockito.verify((Object)this.grid)).addParameterBinding(Matchers.eq((int)1));
    }

    @Test
    public void testOnItemSelectedDeleteParameter() {
        this.setupGrid(0);
        List items = this.grid.getItems(0, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((InvocationGrid)Mockito.verify((Object)this.grid)).deleteParameterBinding(Matchers.eq((int)0));
    }

    @Test
    public void testOnItemSelectedDeleteParameterEnabled() {
        this.setupGrid(0);
        this.assertDeleteParameterEnabled(0, false);
        this.grid.getModel().appendRow((GridRow)new BaseGridRow());
        this.assertDeleteParameterEnabled(0, true);
        this.assertDeleteParameterEnabled(1, true);
    }

    @Test
    public void testOnHeaderItemSelectedInsertParameter() {
        this.setupGrid(0);
        List items = this.grid.getHeaderItems(0, 1);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(1);
        this.grid.onItemSelected((HasListSelectorControl.ListSelectorItem)ti);
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).hide();
        ((InvocationGrid)Mockito.verify((Object)this.grid)).addParameterBinding(Matchers.eq((int)1));
    }

    private void assertDeleteParameterEnabled(int uiRowIndex, boolean enabled) {
        List items = this.grid.getItems(uiRowIndex, 0);
        HasListSelectorControl.ListSelectorTextItem ti = (HasListSelectorControl.ListSelectorTextItem)items.get(3);
        Assertions.assertThat((boolean)ti.isEnabled()).isEqualTo(enabled);
    }

    @Test
    public void testAddParameterBinding() {
        this.setupGrid(0);
        this.addParameterBinding(0);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).proposeContainingColumnWidth(Matchers.eq((double)(this.grid.getWidth() + this.grid.getPadding() * 2.0)), (Function)Matchers.eq((Object)BaseExpressionGrid.RESIZE_EXISTING));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.headerEditor)).bind(Matchers.any(HasNameAndTypeRef.class), Matchers.eq((int)0), Matchers.eq((int)1));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.headerEditor), (Optional)Matchers.eq(Optional.of("InvocationEditor.EditParameter")), Matchers.anyInt(), Matchers.anyInt());
    }

    private void addParameterBinding(int index) {
        this.grid.addParameterBinding(index);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.addParameterBindingCommandCaptor.capture());
        AddParameterBindingCommand addParameterBindingCommand = (AddParameterBindingCommand)this.addParameterBindingCommandCaptor.getValue();
        addParameterBindingCommand.execute(this.canvasHandler);
    }

    @Test
    public void testDeleteParameterBinding() {
        this.setupGrid(0);
        this.grid.deleteParameterBinding(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.deleteParameterBindingCommandCaptor.capture());
        DeleteParameterBindingCommand deleteParameterBindingCommand = (DeleteParameterBindingCommand)this.deleteParameterBindingCommandCaptor.getValue();
        deleteParameterBindingCommand.execute(this.canvasHandler);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        GridLayerRedrawManager.PrioritizedCommand redrawCommand = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue();
        redrawCommand.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testClearExpressionType() {
        this.setupGrid(0);
        this.grid.clearExpressionType(0);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.clearExpressionTypeCommandCaptor.capture());
        ClearExpressionTypeCommand clearExpressionTypeCommand = (ClearExpressionTypeCommand)this.clearExpressionTypeCommandCaptor.getValue();
        clearExpressionTypeCommand.execute(this.canvasHandler);
        ((InvocationGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.undefinedExpressionEditor);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionEditor)).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getValue()).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        Mockito.reset((Object[])new ContainerNode[]{this.grid, this.gridLayer});
        clearExpressionTypeCommand.undo(this.canvasHandler);
        Assertions.assertThat((double)((GridColumn)this.grid.getModel().getColumns().get(2)).getWidth()).isEqualTo(150.0);
        ((InvocationGrid)Mockito.verify((Object)this.grid)).resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
        ((InvocationGrid)Mockito.verify((Object)this.grid)).selectExpressionEditorFirstCell(Matchers.eq((int)0), Matchers.eq((int)2));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)this.undefinedExpressionEditor);
        ((UndefinedExpressionGrid)Mockito.verify((Object)this.undefinedExpressionEditor, (VerificationMode)Mockito.times((int)2))).selectFirstCell();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.capture());
        Assertions.assertThat((List)this.redrawCommandCaptor.getAllValues()).hasSize(2);
        ((GridLayerRedrawManager.PrioritizedCommand)this.redrawCommandCaptor.getAllValues().get(1)).execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
    }

    @Test
    public void testHeaderFactoryWhenNested() {
        this.setupGrid(1);
        TextBoxSingletonDOMElementFactory factory = this.grid.getHeaderTextBoxFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteHeaderValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetHeaderValueCommand.class);
    }

    @Test
    public void testHeaderFactoryWhenNotNested() {
        this.setupGrid(0);
        TextBoxSingletonDOMElementFactory factory = this.grid.getHeaderTextBoxFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteHeaderValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetHeaderValueCommand.class);
    }

    @Test
    public void testBodyFactoryWhenNested() {
        this.setupGrid(1);
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testBodyFactoryWhenNotNested() {
        this.setupGrid(0);
        TextAreaSingletonDOMElementFactory factory = this.grid.getBodyTextAreaFactory();
        Assertions.assertThat(factory.getHasNoValueCommand().apply(this.tupleWithoutValue)).isInstanceOf(DeleteCellValueCommand.class);
        Assertions.assertThat(factory.getHasValueCommand().apply(this.tupleWithValue)).isInstanceOf(SetCellValueCommand.class);
    }

    @Test
    public void testGetDisplayName() {
        this.setupGrid(0);
        Assertions.assertThat((String)this.extractHeaderMetaData().getName().getValue()).isEqualTo((Object)NAME);
    }

    private InvocationColumnHeaderMetaData extractHeaderMetaData() {
        InvocationParameterColumn column = (InvocationParameterColumn)this.grid.getModel().getColumns().get(1);
        return (InvocationColumnHeaderMetaData)column.getHeaderMetaData().get(0);
    }

    @Test
    public void testSetDisplayNameWithNoChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name(NAME));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(org.kie.workbench.common.stunner.core.command.Command.class));
    }

    @Test
    public void testSetDisplayNameWithEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNullValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(null);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), DeleteHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testSetDisplayNameWithNonEmptyValue() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setName(new Name(NAME_NEW));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.capture());
        GridFactoryCommandUtils.assertCommands((org.kie.workbench.common.stunner.core.command.Command)this.compositeCommandCaptor.getValue(), SetHasNameCommand.class, UpdateElementPropertyCommand.class);
    }

    @Test
    public void testGetTypeRef() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().getTypeRef()).isNotNull();
    }

    @Test
    public void testSetTypeRef() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName("", BuiltInType.DATE.getName()));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setupGrid(0);
        this.extractHeaderMetaData().setTypeRef(new QName());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(SetTypeRefCommand.class));
    }

    @Test
    public void testSelectRow() {
        this.setupGrid(0);
        this.grid.selectCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectParameterBinding() {
        this.setupGrid(0);
        this.grid.selectCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)((Binding)this.expression.get().getBinding().get(0)).getVariable());
    }

    @Test
    public void testSelectMultipleParameterBindings() {
        this.setupGrid(0);
        this.addParameterBinding(0);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)((Binding)this.expression.get().getBinding().get(0)).getVariable());
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(1, 1, false, true);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectSingleParameterBindingWithHeaderSelected() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)this.hasExpression);
        Mockito.reset((Object[])new EventSourceMock[]{this.domainObjectSelectionEvent});
        this.grid.selectCell(0, 1, false, true);
        this.assertDomainObjectSelection((DomainObject)((Binding)this.expression.get().getBinding().get(0)).getVariable());
    }

    @Test
    public void testSelectHeaderRowColumn() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 0, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderNameColumnNameRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertDomainObjectSelection((DomainObject)this.hasExpression);
    }

    @Test
    public void testSelectHeaderExpressionColumnNameRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(0, 2, false, false);
        this.assertDomainObjectSelection((DomainObject)this.hasExpression);
    }

    @Test
    public void testSelectHeaderNameColumnParametersRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(1, 1, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderExpressionColumnParametersRow() {
        this.setupGrid(0);
        this.grid.selectHeaderCell(1, 2, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderNameColumnParametersRowWhenNested() {
        this.setupGrid(1);
        this.grid.selectHeaderCell(0, 1, false, false);
        this.assertNOPDomainObjectSelection();
    }

    @Test
    public void testSelectHeaderExpressionColumnParametersRowWhenNested() {
        this.setupGrid(1);
        this.grid.selectHeaderCell(0, 2, false, false);
        this.assertNOPDomainObjectSelection();
    }

    private void assertDomainObjectSelection(DomainObject domainObject) {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isEqualTo((Object)domainObject);
    }

    private void assertNOPDomainObjectSelection() {
        ((EventSourceMock)Mockito.verify(this.domainObjectSelectionEvent)).fire(this.domainObjectSelectionEventCaptor.capture());
        DomainObjectSelectionEvent domainObjectSelectionEvent = (DomainObjectSelectionEvent)this.domainObjectSelectionEventCaptor.getValue();
        Assertions.assertThat((Object)domainObjectSelectionEvent.getDomainObject()).isInstanceOf(NOPDomainObject.class);
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        this.setupGrid(0);
        Assertions.assertThat((Object)this.extractHeaderMetaData().asDMNModelInstrumentedBase()).isInstanceOf(this.hasExpression.getVariable().getClass());
    }
}

