/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.literal;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionCell;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=MockitoJUnitRunner.class)
public class LiteralExpressionUIModelMapperTest {
    @Mock
    protected LiteralExpressionColumn uiLiteralExpressionColumn;
    @Mock
    protected ListSelectorView.Presenter listSelector;
    protected BaseGridData uiModel;
    protected LiteralExpression literalExpression;
    protected LiteralExpressionUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new BaseGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiLiteralExpressionColumn);
        ((LiteralExpressionColumn)Mockito.doReturn((Object)0).when((Object)this.uiLiteralExpressionColumn)).getIndex();
        this.literalExpression = new LiteralExpression();
        this.mapper = this.getMapper();
    }

    protected LiteralExpressionUIModelMapper getMapper() {
        return new LiteralExpressionUIModelMapper(() -> this.uiModel, () -> Optional.of(this.literalExpression), this.listSelector);
    }

    @Test
    public void testFromDmn_Empty() {
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)"", (Object)((BaseGridCellValue)this.uiModel.getCell(0, 0).getValue()).getValue());
    }

    @Test
    public void testFromDmn_MultiByte() {
        this.literalExpression.getText().setValue("\u5b66\u6821");
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)"\u5b66\u6821", (Object)((BaseGridCellValue)this.uiModel.getCell(0, 0).getValue()).getValue());
    }

    @Test
    public void testFromDmn_CellType() {
        this.mapper.fromDMNModel(0, 0);
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 0) instanceof LiteralExpressionCell));
    }

    @Test
    public void testToDmn_Null() {
        this.mapper.toDMNModel(0, 0, () -> Optional.of(new BaseGridCellValue(null)));
        Assert.assertNull((Object)this.literalExpression.getText().getValue());
    }

    @Test
    public void testToDmn_Empty() {
        this.mapper.toDMNModel(0, 0, () -> Optional.of(new BaseGridCellValue((Object)"")));
        Assert.assertEquals((Object)"", (Object)this.literalExpression.getText().getValue());
    }

    @Test
    public void testToDmn_MultiByte() {
        this.mapper.toDMNModel(0, 0, () -> Optional.of(new BaseGridCellValue((Object)"\u5b66\u6821")));
        Assert.assertEquals((Object)"\u5b66\u6821", (Object)this.literalExpression.getText().getValue());
    }
}

