/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.api.definition.model.IsInformationItem;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DMNIncludedModelHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNIncludedModelHandlerTest {
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private DefaultCanvasCommandFactory canvasCommandFactory;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private CanvasCommand<AbstractCanvasHandler> canvasCommand;
    @Mock
    private CompositeCommand<AbstractCanvasHandler, CanvasViolation> compositeCommand;
    private DMNIncludedModelHandler handler;

    @Before
    public void setup() {
        this.handler = (DMNIncludedModelHandler)Mockito.spy((Object)new DMNIncludedModelHandler(this.dmnGraphUtils, this.canvasCommandFactory, this.sessionCommandManager, this.definitionUtils));
    }

    @Test
    public void testUpdate() {
        Decision drgElement1 = this.makeDecision("model1.tUUID", "string", true);
        Decision drgElement2 = this.makeDecision("model1.imported person", "model1.tPerson", true);
        InputData drgElement3 = this.makeInputData("local person", "model1.tPerson", false);
        InputData drgElement4 = this.makeInputData("regular DRG Element", "boolean", false);
        this.setId((DMNElement)drgElement2, "model1.uuid");
        List<DRGElement> drgElements = Arrays.asList(drgElement1, drgElement2, drgElement3, drgElement4);
        ((DMNIncludedModelHandler)Mockito.doNothing().when((Object)this.handler)).updateDRGElementName((DRGElement)Matchers.any(), Matchers.anyString());
        Mockito.when((Object)this.dmnGraphUtils.getDRGElements()).thenReturn(drgElements);
        this.handler.update("model1", "model2");
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.handler)).updateDRGElementName((DRGElement)drgElement1, "model2.tUUID");
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.handler)).updateDRGElementName((DRGElement)drgElement2, "model2.imported person");
        Assert.assertEquals((Object)"string", (Object)drgElement1.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"model2.uuid", (Object)drgElement2.getId().getValue());
        Assert.assertEquals((Object)"model2.tPerson", (Object)drgElement2.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"model2.tPerson", (Object)drgElement3.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"boolean", (Object)drgElement4.getVariable().getTypeRef().getLocalPart());
    }

    @Test
    public void testDestroy() {
        Decision drgElement1 = this.makeDecision("model1.tUUID", "string", true);
        Decision drgElement2 = this.makeDecision("model1.imported person", "model1.tPerson", true);
        InputData drgElement3 = this.makeInputData("local person", "model1.tPerson", false);
        InputData drgElement4 = this.makeInputData("regular DRG Element", "boolean", false);
        List<DRGElement> drgElements = Arrays.asList(drgElement1, drgElement2, drgElement3, drgElement4);
        ((DMNIncludedModelHandler)Mockito.doNothing().when((Object)this.handler)).deleteDRGElement((DRGElement)Matchers.any());
        Mockito.when((Object)this.dmnGraphUtils.getDRGElements()).thenReturn(drgElements);
        this.handler.destroy("model1");
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.handler)).deleteDRGElement((DRGElement)drgElement1);
        ((DMNIncludedModelHandler)Mockito.verify((Object)this.handler)).deleteDRGElement((DRGElement)drgElement2);
    }

    @Test
    public void testUpdateDRGElementName() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        String newName = "new name";
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        ((DMNIncludedModelHandler)Mockito.doReturn(this.compositeCommand).when((Object)this.handler)).buildUpdateCommand(drgElement, "new name");
        this.handler.updateDRGElementName(drgElement, "new name");
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)canvasHandler, this.compositeCommand);
    }

    @Test
    public void testDeleteDRGElement() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        ((DMNIncludedModelHandler)Mockito.doReturn(this.compositeCommand).when((Object)this.handler)).buildDeleteCommand(drgElement);
        this.handler.deleteDRGElement(drgElement);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute((Object)canvasHandler, this.compositeCommand);
    }

    @Test
    public void testBuildUpdateCommand() {
        Decision drgElement = this.makeDecision("model1.tUUID", "string", true);
        String newName = "model2.tUUID";
        String nameId = "nameId";
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Node node = (Node)Mockito.mock(Node.class);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Object definitionObject = Mockito.mock(Object.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Mockito.when((Object)definition.getDefinition()).thenReturn(definitionObject);
        Mockito.when((Object)this.definitionUtils.getNameIdentifier(definitionObject)).thenReturn((Object)"nameId");
        Mockito.when((Object)this.canvasCommandFactory.updatePropertyValue((Element)node, "nameId", (Object)"model2.tUUID")).thenReturn(this.canvasCommand);
        ((DMNIncludedModelHandler)Mockito.doReturn((Object)node).when((Object)this.handler)).getNode((Object)drgElement);
        Command command = (Command)this.handler.buildUpdateCommand((DRGElement)drgElement, "model2.tUUID").getCommands().get(0);
        command.execute((Object)context);
        Assert.assertEquals(this.canvasCommand, (Object)command);
    }

    @Test
    public void testBuildDeleteCommand() {
        Decision drgElement = this.makeDecision("model1.tUUID", "string", true);
        AbstractCanvasHandler context = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.canvasCommandFactory.deleteNode(node)).thenReturn(this.canvasCommand);
        ((DMNIncludedModelHandler)Mockito.doReturn((Object)node).when((Object)this.handler)).getNode((Object)drgElement);
        Command command = (Command)this.handler.buildDeleteCommand((DRGElement)drgElement).getCommands().get(0);
        command.execute((Object)context);
        Assert.assertEquals(this.canvasCommand, (Object)command);
    }

    @Test
    public void testGetNode() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)Mockito.mock(AbstractCanvasHandler.class);
        Diagram diagram = (Diagram)Mockito.mock(Diagram.class);
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node node1 = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        Definition definition1 = (Definition)Mockito.mock(Definition.class);
        Definition definition2 = (Definition)Mockito.mock(Definition.class);
        Definition definition3 = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)definition1.getDefinition()).thenReturn(new Object());
        Mockito.when((Object)definition2.getDefinition()).thenReturn((Object)drgElement);
        Mockito.when((Object)definition3.getDefinition()).thenReturn(new Object());
        Mockito.when((Object)node1.getContent()).thenReturn((Object)definition1);
        Mockito.when((Object)node2.getContent()).thenReturn((Object)definition2);
        Mockito.when((Object)node3.getContent()).thenReturn((Object)definition3);
        Mockito.when((Object)canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)diagram.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)graph.nodes()).thenReturn(Arrays.asList(node1, node2, node3));
        Mockito.when((Object)this.dmnGraphUtils.getCanvasHandler()).thenReturn((Object)canvasHandler);
        Node actualNode = this.handler.getNode((Object)drgElement);
        Assert.assertEquals((Object)node2, (Object)actualNode);
    }

    private Decision makeDecision(String name, String type, boolean allowOnlyVisualChange) {
        Decision decision = new Decision();
        this.setName((NamedElement)decision, name);
        this.setType((HasVariable<InformationItemPrimary>)decision, type);
        decision.setAllowOnlyVisualChange(allowOnlyVisualChange);
        return decision;
    }

    private InputData makeInputData(String name, String type, boolean allowOnlyVisualChange) {
        InputData inputData = new InputData();
        this.setName((NamedElement)inputData, name);
        this.setType((HasVariable<InformationItemPrimary>)inputData, type);
        inputData.setAllowOnlyVisualChange(allowOnlyVisualChange);
        return inputData;
    }

    private void setId(DMNElement dmnElement, String name) {
        dmnElement.setId(new Id(name));
    }

    private void setName(NamedElement namedElement, String name) {
        namedElement.setName(new Name(name));
    }

    private void setType(HasVariable<InformationItemPrimary> hasVariable, String type) {
        InformationItemPrimary variable = new InformationItemPrimary();
        hasVariable.setVariable((IsInformationItem)variable);
        variable.setTypeRef(type == null ? null : new QName("", type, ""));
    }
}

