/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.client.editors.included.BaseIncludedModelActiveRecord;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DefinitionsHandler;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DefinitionsHandlerTest {
    @Mock
    private IncludedModelsPageStateProviderImpl stateProvider;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private Diagram diagram;
    @Mock
    private Definitions definitions;
    private DefinitionsHandler handler;
    private String model;
    private String namespace;
    private Map<String, String> nsContext;

    @Before
    public void setup() {
        this.handler = new DefinitionsHandler(this.stateProvider, this.dmnGraphUtils);
        this.model = "model";
        this.namespace = "://namespace";
        this.nsContext = new Maps.Builder().put((Object)this.model, (Object)this.namespace).build();
        Mockito.when((Object)this.stateProvider.getDiagram()).thenReturn(Optional.of(this.diagram));
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions(this.diagram)).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.definitions.getNsContext()).thenReturn(this.nsContext);
    }

    @Test
    public void testDestroy() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        Mockito.when((Object)includedModel.getNamespace()).thenReturn((Object)this.namespace);
        this.handler.destroy(includedModel);
        Assert.assertEquals((long)0L, (long)this.nsContext.size());
    }

    @Test
    public void testCreate() {
        BaseIncludedModelActiveRecord includedModel = (BaseIncludedModelActiveRecord)Mockito.mock(BaseIncludedModelActiveRecord.class);
        String newNamespace = "://namespace2";
        Mockito.when((Object)includedModel.getNamespace()).thenReturn((Object)"://namespace2");
        this.handler.create(includedModel);
        Assert.assertEquals((long)2L, (long)this.nsContext.size());
        Assert.assertTrue((boolean)this.nsContext.values().contains(this.namespace));
        Assert.assertTrue((boolean)this.nsContext.values().contains("://namespace2"));
    }
}

