/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.search;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.InformationItemCell;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridHelper;
import org.kie.workbench.common.dmn.client.editors.search.DMNGridSubIndex;
import org.kie.workbench.common.dmn.client.editors.search.DMNSearchableElement;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridSubIndexTest {
    @Mock
    private DMNGridHelper dmnGridHelper;
    @Mock
    private GridWidget gridWidget1;
    @Mock
    private GridWidget gridWidget2;
    @Mock
    private GridWidget gridWidget3;
    @Mock
    private GridData gridData1;
    @Mock
    private GridData gridData2;
    @Mock
    private GridData gridData3;
    @Mock
    private GridCell<String> cell1;
    @Mock
    private GridCell<String> cell2;
    @Mock
    private GridCell<String> cell3;
    @Mock
    private GridCell<String> cell4;
    @Mock
    private GridCell<String> cell5;
    @Mock
    private GridCell<String> cell6;
    @Mock
    private GridCell<String> cell7;
    @Mock
    private GridCell<InformationItemCell.HasNameAndDataTypeCell> cell8;
    @Mock
    private GridCellValue<String> cellValue1;
    @Mock
    private GridCellValue<String> cellValue2;
    @Mock
    private GridCellValue<String> cellValue3;
    @Mock
    private GridCellValue<String> cellValue4;
    @Mock
    private GridCellValue<String> cellValue5;
    @Mock
    private GridCellValue<String> cellValue6;
    @Mock
    private GridCellValue<String> cellValue7;
    @Mock
    private GridCellValue<InformationItemCell.HasNameAndDataTypeCell> cellValue8;
    @Mock
    private InformationItemCell.HasNameAndDataTypeCell cellNameAndDataTypeValue8;
    private String cellStringValue1 = "Cell value 1";
    private String cellStringValue2 = "Cell value 2";
    private String cellStringValue3 = "Cell value 3";
    private String cellStringValue4 = "Cell value 4";
    private String cellStringValue5 = "Cell value 5";
    private String cellStringValue6 = "Cell value 6";
    private String cellStringValue7 = "Cell value 7";
    private String cellStringValue8 = "Cell value 8";
    private DMNGridSubIndex index;

    @Before
    public void setup() {
        this.index = (DMNGridSubIndex)Mockito.spy((Object)new DMNGridSubIndex(this.dmnGridHelper));
        Mockito.when((Object)this.dmnGridHelper.getGridWidgets()).thenReturn(this.asSet(this.gridWidget1, this.gridWidget2, this.gridWidget3));
        Mockito.when((Object)this.gridWidget1.getModel()).thenReturn((Object)this.gridData1);
        Mockito.when((Object)this.gridWidget2.getModel()).thenReturn((Object)this.gridData2);
        Mockito.when((Object)this.gridWidget3.getModel()).thenReturn((Object)this.gridData3);
        Mockito.when((Object)this.gridData1.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.gridData1.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)this.gridData2.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.gridData2.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.gridData3.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.gridData3.getColumnCount()).thenReturn((Object)2);
        ((GridData)Mockito.doReturn(this.cell1).when((Object)this.gridData1)).getCell(0, 0);
        ((GridData)Mockito.doReturn(this.cell2).when((Object)this.gridData1)).getCell(0, 1);
        ((GridData)Mockito.doReturn(this.cell3).when((Object)this.gridData2)).getCell(0, 0);
        ((GridData)Mockito.doReturn(this.cell4).when((Object)this.gridData2)).getCell(1, 0);
        ((GridData)Mockito.doReturn(this.cell5).when((Object)this.gridData3)).getCell(0, 0);
        ((GridData)Mockito.doReturn(this.cell6).when((Object)this.gridData3)).getCell(0, 1);
        ((GridData)Mockito.doReturn(this.cell7).when((Object)this.gridData3)).getCell(1, 0);
        ((GridData)Mockito.doReturn(null).when((Object)this.gridData3)).getCell(1, 1);
        Mockito.when((Object)this.cell1.getValue()).thenReturn(this.cellValue1);
        Mockito.when((Object)this.cell2.getValue()).thenReturn(this.cellValue2);
        Mockito.when((Object)this.cell3.getValue()).thenReturn(this.cellValue3);
        Mockito.when((Object)this.cell4.getValue()).thenReturn(this.cellValue4);
        Mockito.when((Object)this.cell5.getValue()).thenReturn(this.cellValue5);
        Mockito.when((Object)this.cell6.getValue()).thenReturn(this.cellValue6);
        Mockito.when((Object)this.cell7.getValue()).thenReturn(this.cellValue7);
        Mockito.when((Object)this.cell8.getValue()).thenReturn(this.cellValue8);
        Mockito.when((Object)this.cellValue1.getValue()).thenReturn((Object)this.cellStringValue1);
        Mockito.when((Object)this.cellValue2.getValue()).thenReturn((Object)this.cellStringValue2);
        Mockito.when((Object)this.cellValue3.getValue()).thenReturn((Object)this.cellStringValue3);
        Mockito.when((Object)this.cellValue4.getValue()).thenReturn((Object)this.cellStringValue4);
        Mockito.when((Object)this.cellValue5.getValue()).thenReturn((Object)this.cellStringValue5);
        Mockito.when((Object)this.cellValue6.getValue()).thenReturn((Object)this.cellStringValue6);
        Mockito.when((Object)this.cellValue7.getValue()).thenReturn((Object)this.cellStringValue7);
        Mockito.when((Object)this.cellValue8.getValue()).thenReturn((Object)this.cellNameAndDataTypeValue8);
        Mockito.when((Object)this.cellNameAndDataTypeValue8.getName()).thenReturn((Object)new Name(this.cellStringValue8));
        Mockito.when((Object)this.cellNameAndDataTypeValue8.hasData()).thenReturn((Object)true);
    }

    @Test
    public void testGetSearchableElements() {
        List elements = this.index.getSearchableElements().stream().sorted(Comparator.comparing(DMNSearchableElement::getText)).collect(Collectors.toList());
        Assert.assertEquals((long)7L, (long)elements.size());
        Assert.assertEquals((Object)this.cellStringValue1, (Object)((DMNSearchableElement)elements.get(0)).getText());
        Assert.assertEquals((Object)this.cellStringValue2, (Object)((DMNSearchableElement)elements.get(1)).getText());
        Assert.assertEquals((Object)this.cellStringValue3, (Object)((DMNSearchableElement)elements.get(2)).getText());
        Assert.assertEquals((Object)this.cellStringValue4, (Object)((DMNSearchableElement)elements.get(3)).getText());
        Assert.assertEquals((Object)this.cellStringValue5, (Object)((DMNSearchableElement)elements.get(4)).getText());
        Assert.assertEquals((Object)this.cellStringValue6, (Object)((DMNSearchableElement)elements.get(5)).getText());
        Assert.assertEquals((Object)this.cellStringValue7, (Object)((DMNSearchableElement)elements.get(6)).getText());
        ((DMNSearchableElement)elements.get(0)).onFound().execute();
        ((DMNSearchableElement)elements.get(1)).onFound().execute();
        ((DMNSearchableElement)elements.get(2)).onFound().execute();
        ((DMNSearchableElement)elements.get(3)).onFound().execute();
        ((DMNSearchableElement)elements.get(4)).onFound().execute();
        ((DMNSearchableElement)elements.get(5)).onFound().execute();
        ((DMNSearchableElement)elements.get(6)).onFound().execute();
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(0, 0, this.gridWidget1);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(0, 1, this.gridWidget1);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(0, 0, this.gridWidget2);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(1, 0, this.gridWidget2);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(0, 0, this.gridWidget3);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(0, 1, this.gridWidget3);
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).highlightCell(1, 0, this.gridWidget3);
    }

    @Test
    public void testGetValue() {
        String expected = this.cellStringValue1;
        String actual = this.index.getValue(this.cell1);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetValueWithCellThatHasNameAndDataType() {
        String expected = this.cellStringValue8;
        String actual = this.index.getValue(this.cell8);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOnNoResultsFound() {
        this.index.onNoResultsFound();
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).clearSelections();
    }

    @Test
    public void testOnSearchClosed() {
        this.index.onSearchClosed();
        ((DMNGridHelper)Mockito.verify((Object)this.dmnGridHelper)).focusGridPanel();
    }

    private Set<GridWidget> asSet(GridWidget ... a) {
        return new HashSet<GridWidget>(Arrays.asList(a));
    }
}

