/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.thirdparty.guava.common.collect.Ordering;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.gwtbootstrap3.extras.select.client.ui.OptGroup;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.CSSStyleDeclaration;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.QNameConverter;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypePickerWidgetTest {
    private static final QName VALUE = new QName();
    private static final String WIDGET_VALUE = "[][<Undefined>][]";
    @Mock
    private Anchor typeButton;
    @Mock
    private Div manageContainer;
    @Mock
    private CSSStyleDeclaration manageContainerStyle;
    @Mock
    private Span manageLabel;
    @Mock
    private TranslationService translationService;
    @Mock
    private DMNGraphUtils dmnGraphUtils;
    @Mock
    private EventSourceMock<DataTypePageTabActiveEvent> dataTypePageActiveEvent;
    @GwtMock
    private Select typeSelector;
    @Mock
    private Element typeSelectorElement;
    @GwtMock
    private Option option;
    @GwtMock
    private OptGroup group;
    @Mock
    private Element optionElement;
    @Mock
    private DMNModelInstrumentedBase dmnModel;
    private ItemDefinitionUtils itemDefinitionUtils;
    @Captor
    private ArgumentCaptor<BuiltInType> builtInTypeCaptor;
    @Captor
    private ArgumentCaptor<ItemDefinition> itemDefinitionCaptor;
    private Definitions definitions;
    private DataTypePickerWidget picker;
    private QNameConverter qNameConverter;

    @Before
    public void setup() {
        this.definitions = new Definitions();
        this.definitions.getItemDefinition().add(new ItemDefinition());
        this.definitions.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        this.qNameConverter = (QNameConverter)Mockito.spy((Object)new QNameConverter());
        this.itemDefinitionUtils = (ItemDefinitionUtils)Mockito.spy((Object)new ItemDefinitionUtils(this.dmnGraphUtils));
        Mockito.when((Object)this.typeSelector.getElement()).thenReturn((Object)this.typeSelectorElement);
        Mockito.when((Object)this.option.getElement()).thenReturn((Object)this.optionElement);
        Mockito.when((Object)this.dmnGraphUtils.getDefinitions()).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.dmnModel.getPrefixForNamespaceURI(Matchers.anyString())).thenReturn(Optional.empty());
        Mockito.when((Object)this.manageContainer.getStyle()).thenReturn((Object)this.manageContainerStyle);
        Mockito.when((Object)this.translationService.getTranslation(Matchers.anyString())).thenAnswer(i -> i.getArguments()[0]);
        this.picker = (DataTypePickerWidget)Mockito.spy((Object)new DataTypePickerWidget(this.typeButton, this.manageContainer, this.manageLabel, this.translationService, this.qNameConverter, this.dmnGraphUtils, this.dataTypePageActiveEvent, this.itemDefinitionUtils));
    }

    @Test
    public void testInitialisation() {
        ((Select)Mockito.verify((Object)this.typeSelector)).setShowTick(Matchers.eq((boolean)true));
        ((Select)Mockito.verify((Object)this.typeSelector)).setLiveSearch(Matchers.eq((boolean)true));
        ((Element)Mockito.verify((Object)this.typeSelectorElement)).setAttribute((String)Matchers.eq((Object)"data-container"), (String)Matchers.eq((Object)"body"));
        ((Select)Mockito.verify((Object)this.typeSelector)).refresh();
        ((Select)Mockito.verify((Object)this.typeSelector)).setLiveSearchPlaceholder((String)Matchers.eq((Object)"TypePickerWidget.Choose"));
        ((Span)Mockito.verify((Object)this.manageLabel)).setTextContent((String)Matchers.eq((Object)"TypePickerWidget.Manage"));
    }

    @Test
    public void testSetDMNModel_BasicInitialisation() {
        Mockito.reset((Object[])new Select[]{this.typeSelector});
        this.picker.setDMNModel(this.dmnModel);
        ((QNameConverter)Mockito.verify((Object)this.qNameConverter)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.dmnModel));
        ((Select)Mockito.verify((Object)this.typeSelector)).clear();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker)).addBuiltInTypes();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker)).addItemDefinitions();
        ((Select)Mockito.verify((Object)this.typeSelector)).refresh();
    }

    @Test
    public void testSetDMNModel_BuiltInTypes() {
        this.picker.addBuiltInTypes();
        BuiltInType[] bits = BuiltInType.values();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker, (VerificationMode)Mockito.times((int)bits.length))).makeTypeSelector((BuiltInType)this.builtInTypeCaptor.capture());
        ((OptGroup)Mockito.verify((Object)this.group)).setLabel("DataTypeSelectView.DefaultTitle");
        ((OptGroup)Mockito.verify((Object)this.group, (VerificationMode)Mockito.times((int)bits.length))).add((Widget)Matchers.eq((Object)this.option));
        ((Select)Mockito.verify((Object)this.typeSelector)).add((Widget)this.group);
        List<BuiltInType> builtInTypes = Arrays.asList(bits);
        Assert.assertFalse((boolean)builtInTypes.isEmpty());
        List builtInTypesAddedToWidget = this.builtInTypeCaptor.getAllValues();
        Assertions.assertThat(builtInTypes).hasSameElementsAs((Iterable)builtInTypesAddedToWidget);
        Assert.assertTrue((boolean)Ordering.from((Comparator)DataTypePickerWidget.BUILT_IN_TYPE_COMPARATOR).isOrdered((Iterable)builtInTypesAddedToWidget));
        Assert.assertEquals((Object)((BuiltInType)builtInTypesAddedToWidget.get(0)).getName(), (Object)BuiltInType.UNDEFINED.getName());
    }

    @Test
    public void testSetDMNModel_ItemDefinitions() {
        this.definitions.getItemDefinition().add(new ItemDefinition(){
            {
                this.setName(new Name("user_defined_data_type"));
            }
        });
        this.picker.addItemDefinitions();
        List itemDefinitions = this.definitions.getItemDefinition();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker, (VerificationMode)Mockito.times((int)itemDefinitions.size()))).makeTypeSelector((ItemDefinition)this.itemDefinitionCaptor.capture());
        ((OptGroup)Mockito.verify((Object)this.group)).setLabel("DataTypeSelectView.CustomTitle");
        ((OptGroup)Mockito.verify((Object)this.group, (VerificationMode)Mockito.times((int)itemDefinitions.size()))).add((Widget)Matchers.eq((Object)this.option));
        ((Select)Mockito.verify((Object)this.typeSelector)).add((Widget)this.group);
        Assert.assertFalse((boolean)itemDefinitions.isEmpty());
        List itemDefinitionsAddedToWidget = this.itemDefinitionCaptor.getAllValues();
        itemDefinitions.removeAll(itemDefinitionsAddedToWidget);
        Assert.assertTrue((boolean)itemDefinitions.isEmpty());
        Assert.assertTrue((boolean)Ordering.from((Comparator)DataTypePickerWidget.ITEM_DEFINITION_COMPARATOR).isOrdered((Iterable)itemDefinitionsAddedToWidget));
    }

    @Test
    public void testSetDMNModel_NoItemDefinitions() {
        this.definitions.getItemDefinition().clear();
        this.picker.setDMNModel(this.dmnModel);
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker, (VerificationMode)Mockito.never())).makeTypeSelector((ItemDefinition)Matchers.any(ItemDefinition.class));
    }

    @Test
    public void testMakeTypeSelectorForBuiltInType() {
        BuiltInType bit = BuiltInType.ANY;
        ArgumentCaptor optionTextCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor optionValueCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor qNameCaptor = ArgumentCaptor.forClass(QName.class);
        Optional oo = this.picker.makeTypeSelector(bit);
        ((Option)Mockito.verify((Object)this.option)).setText((String)optionTextCaptor.capture());
        ((Option)Mockito.verify((Object)this.option)).setValue((String)optionValueCaptor.capture());
        ((QNameConverter)Mockito.verify((Object)this.qNameConverter)).toWidgetValue((QName)qNameCaptor.capture());
        QName normalisedQName = (QName)qNameCaptor.getValue();
        Assert.assertEquals((Object)"", (Object)normalisedQName.getNamespaceURI());
        Assert.assertEquals((Object)"", (Object)normalisedQName.getPrefix());
        Assert.assertEquals((Object)bit.getName(), (Object)normalisedQName.getLocalPart());
        Assert.assertTrue((boolean)oo.isPresent());
        Assert.assertEquals((Object)bit.getName(), (Object)optionTextCaptor.getValue());
        Assert.assertEquals((Object)"[][Any][]", (Object)optionValueCaptor.getValue());
    }

    @Test
    public void testMakeTypeSelectorForItemDefinition() {
        String itemDefinitionNameValue = "person";
        ItemDefinition itemDefinition = (ItemDefinition)this.definitions.getItemDefinition().get(0);
        itemDefinition.setName(new Name("person"));
        ArgumentCaptor optionTextCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor optionValueCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor qNameCaptor = ArgumentCaptor.forClass(QName.class);
        ((QNameConverter)Mockito.doReturn((Object)itemDefinition.getName().getValue()).when((Object)this.qNameConverter)).toWidgetValue((QName)Matchers.any(QName.class));
        Optional oo = this.picker.makeTypeSelector(itemDefinition);
        ((Option)Mockito.verify((Object)this.option)).setText((String)optionTextCaptor.capture());
        ((Option)Mockito.verify((Object)this.option)).setValue((String)optionValueCaptor.capture());
        ((QNameConverter)Mockito.verify((Object)this.qNameConverter)).toWidgetValue((QName)qNameCaptor.capture());
        Assert.assertTrue((boolean)oo.isPresent());
        Assert.assertEquals((Object)"person", (Object)optionTextCaptor.getValue());
        Assert.assertEquals((Object)"person", (Object)optionValueCaptor.getValue());
        Assert.assertEquals((Object)"person", (Object)((QName)qNameCaptor.getValue()).getLocalPart());
    }

    @Test
    public void testMakeTypeSelectorForNullItemDefinition() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ((ItemDefinition)Mockito.doReturn(null).when((Object)itemDefinition)).getName();
        Assert.assertFalse((boolean)this.picker.makeTypeSelector(itemDefinition).isPresent());
        ((Option)Mockito.verify((Object)this.option, (VerificationMode)Mockito.never())).setText(Matchers.anyString());
        ((Option)Mockito.verify((Object)this.option, (VerificationMode)Mockito.never())).setValue(Matchers.anyString());
        ((QNameConverter)Mockito.verify((Object)this.qNameConverter, (VerificationMode)Mockito.never())).toWidgetValue((QName)Matchers.any(QName.class));
    }

    @Test
    public void testSetValue() {
        this.picker.setValue(VALUE);
        ((Select)Mockito.verify((Object)this.typeSelector)).setValue(Matchers.eq((Object)WIDGET_VALUE), Matchers.eq((boolean)false));
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker, (VerificationMode)Mockito.never())).fireValueChangeEvent((QName)Matchers.any());
    }

    @Test
    public void testSetValueFireEvent() {
        this.picker.setValue(VALUE, true);
        ((Select)Mockito.verify((Object)this.typeSelector)).setValue(Matchers.eq((Object)WIDGET_VALUE), Matchers.eq((boolean)false));
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker)).fireValueChangeEvent((QName)Matchers.eq(null));
    }

    @Test
    public void testSetValueDoNotFireEvent() {
        this.picker.setValue(VALUE, false);
        ((Select)Mockito.verify((Object)this.typeSelector)).setValue(Matchers.eq((Object)WIDGET_VALUE), Matchers.eq((boolean)false));
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker, (VerificationMode)Mockito.never())).fireValueChangeEvent((QName)Matchers.any());
    }

    @Test
    public void testGetValue() {
        this.picker.setValue(VALUE);
        Assert.assertEquals((Object)VALUE, (Object)this.picker.getValue());
    }

    @Test
    public void testDisable() {
        this.picker.setEnabled(false);
        ((Select)Mockito.verify((Object)this.typeSelector)).setEnabled(Matchers.eq((boolean)false));
        Assert.assertFalse((boolean)this.picker.isEnabled());
    }

    @Test
    public void testEnable() {
        this.picker.setEnabled(true);
        ((Select)Mockito.verify((Object)this.typeSelector)).setEnabled(Matchers.eq((boolean)true));
        Assert.assertTrue((boolean)this.picker.isEnabled());
    }

    @Test
    public void testOnClickTypeButton() {
        ClickEvent clickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        this.picker.onClickTypeButton(clickEvent);
        ((EventSourceMock)Mockito.verify(this.dataTypePageActiveEvent)).fire(Matchers.any(DataTypePageTabActiveEvent.class));
    }

    @Test
    public void testShowManageLabel() {
        this.picker.showManageLabel();
        ((CSSStyleDeclaration)Mockito.verify((Object)this.manageContainerStyle)).removeProperty((String)Matchers.eq((Object)"display"));
    }

    @Test
    public void testHideManageLabel() {
        this.picker.hideManageLabel();
        ((CSSStyleDeclaration)Mockito.verify((Object)this.manageContainerStyle)).setProperty((String)Matchers.eq((Object)"display"), (String)Matchers.eq((Object)"none"));
    }

    @Test
    public void testNormaliseBuiltInTypeTypeRef() {
        QName typeRef = (QName)Mockito.mock(QName.class);
        QName expectedTypeRef = (QName)Mockito.mock(QName.class);
        ((ItemDefinitionUtils)Mockito.doReturn((Object)expectedTypeRef).when((Object)this.itemDefinitionUtils)).normaliseTypeRef(typeRef);
        QName actualTypeRef = this.picker.normaliseBuiltInTypeTypeRef(typeRef);
        Assert.assertEquals((Object)expectedTypeRef, (Object)actualTypeRef);
    }

    @Test
    public void testPopulateTypeSelector() {
        this.picker.populateTypeSelector();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.typeSelector});
        ((Select)inOrder.verify((Object)this.typeSelector)).clear();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker)).addBuiltInTypes();
        ((DataTypePickerWidget)Mockito.verify((Object)this.picker)).addItemDefinitions();
        ((Select)inOrder.verify((Object)this.typeSelector)).refresh();
    }
}

