/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.KeyboardEvent;
import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.EventListener;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverViewImpl;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;

@RunWith(value=GwtMockitoTestRunner.class)
public class NameAndDataTypePopoverViewImplTest {
    private static final String NAME = "name";
    @Mock
    private Input nameEditor;
    @Mock
    private DataTypePickerWidget dataTypeEditor;
    @Mock
    private Div popoverElement;
    @Mock
    private Div popoverContentElement;
    @Mock
    private Span nameLabel;
    @Mock
    private Span dataTypeLabel;
    @Mock
    private JQueryProducer.JQuery<Popover> jQueryProducer;
    @Mock
    private NameAndDataTypePopoverView.Presenter presenter;
    @Mock
    private HTMLElement element;
    @Mock
    private Decision decision;
    @Mock
    private QName typeRef;
    @Mock
    private ValueChangeEvent<QName> valueChangeEvent;
    @Mock
    private BlurEvent blurEvent;
    @Mock
    private Popover popover;
    @Mock
    private TranslationService translationService;
    @Mock
    private Button manageButton;
    @Mock
    private Button typeSelectorButton;
    @Captor
    private ArgumentCaptor<ValueChangeHandler<QName>> valueChangeHandlerCaptor;
    private NameAndDataTypePopoverViewImpl view;

    @Before
    public void setUp() {
        this.view = (NameAndDataTypePopoverViewImpl)Mockito.spy((Object)new NameAndDataTypePopoverViewImpl(this.nameEditor, this.dataTypeEditor, this.popoverElement, this.popoverContentElement, this.nameLabel, this.dataTypeLabel, this.jQueryProducer, this.translationService){

            public HTMLElement getElement() {
                return NameAndDataTypePopoverViewImplTest.this.element;
            }
        });
        Mockito.when((Object)this.element.querySelector("#typeButton")).thenReturn((Object)this.manageButton);
        Mockito.when((Object)this.element.querySelector("button.dropdown-toggle.btn-default")).thenReturn((Object)this.typeSelectorButton);
        this.view.init(this.presenter);
        Mockito.when((Object)this.valueChangeEvent.getValue()).thenReturn((Object)this.typeRef);
        Mockito.when((Object)this.jQueryProducer.wrap((org.jboss.errai.common.client.dom.Element)this.element)).thenReturn((Object)this.popover);
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[0]).when((Object)this.translationService)).getTranslation(Matchers.anyString());
    }

    @Test
    public void testInit() {
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).addValueChangeHandler((ValueChangeHandler)this.valueChangeHandlerCaptor.capture());
        ((ValueChangeHandler)this.valueChangeHandlerCaptor.getValue()).onValueChange(this.valueChangeEvent);
        Assert.assertEquals((Object)this.view.getCurrentTypeRef(), (Object)this.typeRef);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).setKeyDownListeners();
    }

    @Test
    public void testSetKeyDownListeners() {
        EventListener keyDownCallback = (EventListener)Mockito.mock(EventListener.class);
        EventListener managerCallback = (EventListener)Mockito.mock(EventListener.class);
        EventListener eventListenerCallback = (EventListener)Mockito.mock(EventListener.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)keyDownCallback).when((Object)this.view)).getKeyDownEventListener();
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)managerCallback).when((Object)this.view)).getManageButtonKeyDownEventListener();
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)eventListenerCallback).when((Object)this.view)).getTypeSelectorKeyDownEventListener();
        this.view.setKeyDownListeners();
        ((Div)Mockito.verify((Object)this.popoverElement)).addEventListener("keydown", keyDownCallback, false);
        ((Button)Mockito.verify((Object)this.manageButton)).addEventListener("keydown", managerCallback, false);
        ((Button)Mockito.verify((Object)this.typeSelectorButton)).addEventListener("keydown", eventListenerCallback, false);
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerEnterKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(true);
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerEscKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerWhenIsNotAHandledKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(Matchers.anyBoolean());
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent, (VerificationMode)Mockito.never())).preventDefault();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((Button)Mockito.verify((Object)this.manageButton, (VerificationMode)Mockito.never())).focus();
        ((Input)Mockito.verify((Object)this.nameEditor, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerWhenIsNotAKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.typeSelectorKeyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(Matchers.anyBoolean());
        ((Event)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).preventDefault();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((Button)Mockito.verify((Object)this.manageButton, (VerificationMode)Mockito.never())).focus();
        ((Input)Mockito.verify((Object)this.nameEditor, (VerificationMode)Mockito.never())).focus();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerTabKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((Input)Mockito.verify((Object)this.nameEditor)).focus();
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
    }

    @Test
    public void testTypeSelectorKeyDownEventListenerShiftTabKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.shiftKey = true;
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTabKeyPressed(keyboardEvent);
        this.view.typeSelectorKeyDownEventListener((Object)keyboardEvent);
        ((Button)Mockito.verify((Object)this.manageButton)).focus();
        ((KeyboardEvent)Mockito.verify((Object)keyboardEvent)).preventDefault();
    }

    @Test
    public void testManagerButtonKeyDownEventListenerEsc() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testManagerButtonKeyDownEventWhenIsNotEscapeKey() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testManagerButtonKeyDownEventWhenIsNotKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.manageButtonKeyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testKeyDownEventListenerEsc() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(false);
        this.view.manageButtonKeyDownEventListener((Object)keyboardEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testIsTabKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Tab";
        boolean actual = this.view.isTabKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isTabKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsEscapeKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Esc";
        boolean actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
        keyboardEvent.key = "Escape";
        actual = this.view.isEscapeKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEnterKeyPressed() {
        KeyboardEvent keyboardEvent = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        keyboardEvent.key = "Enter";
        boolean actual = this.view.isEnterKeyPressed(keyboardEvent);
        Assert.assertTrue((boolean)actual);
        keyboardEvent.key = "A";
        actual = this.view.isEnterKeyPressed(keyboardEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testOnNameEditorKeyDownEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnter(keyDownEvent);
        this.view.onNameEditorKeyDown(keyDownEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(true);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testOnNameEditorKeyDownEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnter(keyDownEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEsc(keyDownEvent);
        NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.onNameEditorKeyDown(keyDownEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testOnNameEditorKeyDownShiftTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnter(keyDownEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEsc(keyDownEvent);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isTab(keyDownEvent);
        Mockito.when((Object)keyDownEvent.isShiftKeyDown()).thenReturn((Object)true);
        this.view.onNameEditorKeyDown(keyDownEvent);
        ((Button)Mockito.verify((Object)this.typeSelectorButton)).focus();
        ((KeyDownEvent)Mockito.verify((Object)keyDownEvent)).preventDefault();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
    }

    @Test
    public void testIsTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)9);
        boolean actual = this.view.isTab(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)27);
        boolean actual = this.view.isEsc(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)13);
        boolean actual = this.view.isEnter(keyDownEvent);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsNotTab() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isTab(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsNotEsc() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isEsc(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testIsNotEnter() {
        KeyDownEvent keyDownEvent = (KeyDownEvent)Mockito.mock(KeyDownEvent.class);
        Mockito.when((Object)keyDownEvent.getNativeKeyCode()).thenReturn((Object)65);
        boolean actual = this.view.isEnter(keyDownEvent);
        Assert.assertFalse((boolean)actual);
    }

    @Test
    public void testSetDMNModel() {
        this.view.setDMNModel((DMNModelInstrumentedBase)this.decision);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.decision));
    }

    @Test
    public void testInitName() {
        this.view.initName(NAME);
        ((Input)Mockito.verify((Object)this.nameEditor)).setValue((String)Matchers.eq((Object)NAME));
    }

    @Test
    public void testInitSelectedTypeRef() {
        this.view.initSelectedTypeRef(this.typeRef);
        ((DataTypePickerWidget)Mockito.verify((Object)this.dataTypeEditor)).setValue((QName)Matchers.eq((Object)this.typeRef), Matchers.eq((boolean)false));
    }

    @Test
    public void testShow() {
        this.view.show(Optional.empty());
        ((Popover)Mockito.verify((Object)this.popover)).show();
    }

    @Test
    public void testHideBeforeShown() {
        NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).hide();
        ((Popover)Mockito.verify((Object)this.popover, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    public void testHideAfterShown() {
        NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor monitor = (NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.mock(NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)monitor).when((Object)this.view)).getMonitor();
        Element menuElement = (Element)Mockito.mock(Element.class);
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.doReturn((Object)menuElement).when((Object)monitor)).getMenuElement();
        this.view.show(Optional.empty());
        this.view.hide();
        ((Input)Mockito.verify((Object)this.nameEditor)).blur();
        ((NameAndDataTypePopoverViewImpl.BootstrapSelectDropDownMonitor)Mockito.verify((Object)monitor)).hide();
    }

    @Test
    public void testOnNameChange() {
        Mockito.when((Object)this.nameEditor.getValue()).thenReturn((Object)NAME);
        this.view.onNameChange(this.blurEvent);
        ((NameAndDataTypePopoverView.Presenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).setName((String)Matchers.eq((Object)NAME));
        Assert.assertEquals((Object)NAME, (Object)this.view.getCurrentName());
    }

    @Test
    public void testOnDataTypePageNavTabActiveEvent() {
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        this.view.onDataTypePageNavTabActiveEvent((DataTypePageTabActiveEvent)Mockito.mock(DataTypePageTabActiveEvent.class));
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide();
    }

    @Test
    public void testOnClosedByKeyboard() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Optional<Consumer> opt = Optional.of(consumer);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn(opt).when((Object)this.view)).getClosedByKeyboardCallback();
        this.view.onClosedByKeyboard();
        ((Consumer)Mockito.verify((Object)consumer)).accept(this.view);
    }

    @Test
    public void testSetOnClosedByKeyboardCallback() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        this.view.setOnClosedByKeyboardCallback(consumer);
        Optional actual = this.view.getClosedByKeyboardCallback();
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)consumer, actual.get());
    }

    @Test
    public void testSetOnClosedByKeyboardCallbackNullCallback() {
        this.view.setOnClosedByKeyboardCallback(null);
        Optional actual = this.view.getClosedByKeyboardCallback();
        Assert.assertFalse((boolean)actual.isPresent());
        Assert.assertEquals(Optional.empty(), (Object)actual);
    }

    @Test
    public void testKeyDownEventListenerEnterKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(true);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEnterKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(true);
        ((KeyboardEvent)Mockito.verify((Object)event)).stopPropagation();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).isEscapeKeyPressed(event);
    }

    @Test
    public void testKeyDownEventListenerEscKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.doNothing().when((Object)this.view)).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(event);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)true).when((Object)this.view)).isEscapeKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).hide(false);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).reset();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view)).onClosedByKeyboard();
    }

    @Test
    public void testKeyDownEventListenerWhenIsNotAHandledKey() {
        KeyboardEvent event = (KeyboardEvent)Mockito.mock(KeyboardEvent.class);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEnterKeyPressed(event);
        ((NameAndDataTypePopoverViewImpl)Mockito.doReturn((Object)false).when((Object)this.view)).isEscapeKeyPressed(event);
        this.view.keyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(Matchers.anyBoolean());
        ((KeyboardEvent)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).stopPropagation();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
    }

    @Test
    public void testKeyDownEventListenerWhenIsNotKeyboardEvent() {
        Event event = (Event)Mockito.mock(Event.class);
        this.view.keyDownEventListener((Object)event);
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hide(Matchers.anyBoolean());
        ((Event)Mockito.verify((Object)event, (VerificationMode)Mockito.never())).stopPropagation();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).onClosedByKeyboard();
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).isEscapeKeyPressed((KeyboardEvent)Matchers.any());
        ((NameAndDataTypePopoverViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).reset();
    }
}

