/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.QNameConverter;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class QNameConverterTest {
    private static final String ENCODED_FEEL_DATE = "[][date][]";
    private static final String ENCODED_DMN_UNKNOWN = "[http://www.omg.org/spec/DMN/20151101/dmn.xsd][unknown][" + DMNModelInstrumentedBase.Namespace.DMN.getPrefix() + "]";
    private QNameConverter converter;

    @Before
    public void setup() {
        this.converter = new QNameConverter(){

            protected List<String> getRegexGroups(String componentValue) {
                ArrayList<String> regExGroups = new ArrayList<String>();
                Pattern p = Pattern.compile("^\\[(.*?)\\]\\[(.*?)\\]\\[(.*?)\\]$");
                Matcher m = p.matcher(componentValue);
                if (m.find()) {
                    for (int i = 0; i <= m.groupCount(); ++i) {
                        regExGroups.add(m.group(i));
                    }
                }
                return regExGroups;
            }
        };
    }

    @Test
    public void testToWidgetValueWhenDMNElementDefinesNameSpaces() {
        Decision decision = new Decision();
        decision.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        this.converter.setDMNModel((DMNModelInstrumentedBase)decision);
        String encoding = this.converter.toWidgetValue(BuiltInType.DATE.asQName());
        Assert.assertEquals((Object)ENCODED_FEEL_DATE, (Object)encoding);
    }

    @Test
    public void testToWidgetValueWhenDMNDiagramDefinesNameSpaces() {
        Definitions definitions = new Definitions();
        definitions.getNsContext().put(DMNModelInstrumentedBase.Namespace.FEEL.getPrefix(), DMNModelInstrumentedBase.Namespace.FEEL.getUri());
        Decision decision = new Decision();
        decision.setParent((DMNModelInstrumentedBase)definitions);
        this.converter.setDMNModel((DMNModelInstrumentedBase)decision);
        String encoding = this.converter.toWidgetValue(BuiltInType.DATE.asQName());
        Assert.assertEquals((Object)ENCODED_FEEL_DATE, (Object)encoding);
    }

    @Test
    public void testToWidgetValueWhenDMNDiagramDoesNotDefinesNameSpaces() {
        this.converter.setDMNModel((DMNModelInstrumentedBase)new Decision());
        String encoding = this.converter.toWidgetValue(new QName("http://www.omg.org/spec/DMN/20151101/dmn.xsd", "unknown", DMNModelInstrumentedBase.Namespace.DMN.getPrefix()));
        Assert.assertEquals((Object)ENCODED_DMN_UNKNOWN, (Object)encoding);
    }

    @Test
    public void testToModelValueWithCorrectlyEncodedValue() {
        QName typeRef = this.converter.toModelValue(ENCODED_FEEL_DATE);
        Assert.assertEquals((Object)"", (Object)typeRef.getPrefix());
        Assert.assertEquals((Object)"", (Object)typeRef.getNamespaceURI());
        Assert.assertEquals((Object)BuiltInType.DATE.getName(), (Object)typeRef.getLocalPart());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue() {
        this.converter.toModelValue("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_NotEnoughBrackets() {
        this.converter.toModelValue("[][]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_UnclosedBrackets() {
        this.converter.toModelValue("[][[]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_UnopenBrackets() {
        this.converter.toModelValue("[]][]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_TextOutside() {
        this.converter.toModelValue("a[]b[]c[]d");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_TextAtStart() {
        this.converter.toModelValue("a[][][]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testToModelValueWithIncorrectlyEncodedValue_TextAtEnd() {
        this.converter.toModelValue("[][][]d");
    }
}

