/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManagerStackStore;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsBlankErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsDefaultTypeMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsNotUniqueErrorMessage;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionRecordEngine;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.validation.DataTypeNameValidator;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DataTypeManagerTest {
    @Mock
    private TranslationService translationService;
    @Mock
    private ItemDefinitionRecordEngine recordEngine;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private ItemDefinitionUtils itemDefinitionUtils;
    @Mock
    private ManagedInstance<DataTypeManager> dataTypeManagers;
    @Mock
    private DataTypeManagerStackStore typeStack;
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private DataTypeNameIsBlankErrorMessage blankErrorMessage;
    @Mock
    private DataTypeNameIsNotUniqueErrorMessage notUniqueErrorMessage;
    @Mock
    private DataTypeNameIsDefaultTypeMessage nameIsDefaultTypeMessage;
    private static final String NONE = "Insert a name";
    private static final String STRUCTURE = "Structure";
    private DataTypeNameValidator dataTypeNameValidator;
    private DataTypeManager manager;

    @Before
    public void setup() {
        Mockito.when((Object)this.translationService.format("DataTypeManager.None", new Object[0])).thenReturn((Object)NONE);
        Mockito.when((Object)this.translationService.format("DataTypeManager.Structure", new Object[0])).thenReturn((Object)STRUCTURE);
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn(Mockito.mock(ItemDefinition.class));
        Mockito.when((Object)this.itemDefinitionUtils.findByName(Matchers.anyString())).thenReturn(Optional.empty());
        this.dataTypeNameValidator = (DataTypeNameValidator)Mockito.spy((Object)new DataTypeNameValidator(this.flashMessageEvent, this.blankErrorMessage, this.notUniqueErrorMessage, this.nameIsDefaultTypeMessage, this.dataTypeStore));
        this.manager = (DataTypeManager)Mockito.spy((Object)((Object)new DataTypeManagerFake()));
    }

    @Test
    public void testWithConstraintType() {
        ConstraintType expectedConstraintType = ConstraintType.ENUMERATION;
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withConstraintType(expectedConstraintType.value()).get();
        ConstraintType actualConstraintType = dataType.getConstraintType();
        Assert.assertEquals((Object)expectedConstraintType, (Object)actualConstraintType);
    }

    @Test
    public void testWithParentUUID() {
        String expectedParentUUID = "expectedParentUUID";
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withParentUUID("expectedParentUUID").get();
        String actualParentUUID = dataType.getParentUUID();
        Assert.assertEquals((Object)"expectedParentUUID", (Object)actualParentUUID);
    }

    @Test
    public void testWithName() {
        String expectedName = "expectedName";
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withName("expectedName").get();
        String actualName = dataType.getName();
        Assert.assertEquals((Object)"expectedName", (Object)actualName);
    }

    @Test
    public void testWithNoName() {
        String expectedName = NONE;
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withNoName().get();
        String actualName = dataType.getName();
        Assert.assertEquals((Object)NONE, (Object)actualName);
    }

    @Test
    public void testGetTypeNameWhenTypeIsNotStructure() {
        String expectedTypeName = "tPerson";
        String actualTypeName = this.manager.from(this.makeDataType("uuid", "person", "tPerson")).getTypeName();
        Assert.assertEquals((Object)"tPerson", (Object)actualTypeName);
    }

    @Test
    public void testGetTypeNameWhenTypeIsStructure() {
        String expectedTypeName = "tPerson";
        String actualTypeName = this.manager.from(this.makeDataType("uuid", "tPerson", STRUCTURE)).getTypeName();
        Assert.assertEquals((Object)"tPerson", (Object)actualTypeName);
    }

    @Test
    public void testWithType() {
        String expectedType = "expectedType";
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withType("expectedType").get();
        String actualType = dataType.getType();
        Assert.assertEquals((Object)"expectedType", (Object)actualType);
    }

    @Test
    public void testWithRefreshedSubDataTypes() {
        String newType = "newType";
        List<DataType> expectedDataTypes = Arrays.asList((DataType)Mockito.mock(DataType.class), (DataType)Mockito.mock(DataType.class));
        ((DataTypeManager)Mockito.doReturn(expectedDataTypes).when((Object)this.manager)).makeExternalDataTypes("newType");
        DataType dataType = this.manager.from(this.makeDataType("uuid")).withRefreshedSubDataTypes("newType").get();
        List actualDataTypes = dataType.getSubDataTypes();
        Assert.assertEquals(expectedDataTypes, (Object)actualDataTypes);
    }

    @Test
    public void testWithSubDataTypes() {
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType subLevelDataType = (DataType)Mockito.mock(DataType.class);
        String subLevelDataTypeUuid = "subUuid";
        Mockito.when((Object)subLevelDataType.getUUID()).thenReturn((Object)"subUuid");
        List<Object> newSubDataTypes = Collections.singletonList(Mockito.mock(DataType.class));
        Mockito.when((Object)topLevelDataType.getSubDataTypes()).thenReturn(Collections.singletonList(subLevelDataType));
        Mockito.when((Object)this.itemDefinitionUtils.findByName(Matchers.anyString())).thenReturn(Optional.empty());
        this.manager.withDataType(topLevelDataType);
        this.manager.withSubDataTypes(newSubDataTypes);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).unIndex("subUuid");
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).unIndex("subUuid");
        ((DataType)Mockito.verify((Object)topLevelDataType)).setSubDataTypes(newSubDataTypes);
    }

    @Test
    public void testWithSubDataTypesWhenDataTypeIsReadOnly() {
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType subLevelDataType = (DataType)Mockito.mock(DataType.class);
        String subLevelDataTypeUuid = "subUuid";
        Mockito.when((Object)subLevelDataType.getUUID()).thenReturn((Object)"subUuid");
        List<Object> newSubDataTypes = Collections.singletonList(Mockito.mock(DataType.class));
        Mockito.when((Object)topLevelDataType.isReadOnly()).thenReturn((Object)true);
        Mockito.when((Object)topLevelDataType.getSubDataTypes()).thenReturn(Collections.singletonList(subLevelDataType));
        this.manager.withDataType(topLevelDataType);
        this.manager.withSubDataTypes(newSubDataTypes);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore, (VerificationMode)Mockito.never())).unIndex(Matchers.anyString());
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore, (VerificationMode)Mockito.never())).unIndex(Matchers.anyString());
        ((DataType)Mockito.verify((Object)topLevelDataType, (VerificationMode)Mockito.never())).setSubDataTypes(Matchers.anyListOf(DataType.class));
    }

    @Test
    public void testWithSubDataTypesWhenDataTypeTypeIsReadOnly() {
        DataType topLevelDataType = (DataType)Mockito.mock(DataType.class);
        DataType subLevelDataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String subLevelDataTypeUuid = "subUuid";
        String type = "model1.ExternalDataType";
        Mockito.when((Object)subLevelDataType.getUUID()).thenReturn((Object)"subUuid");
        List<Object> newSubDataTypes = Collections.singletonList(Mockito.mock(DataType.class));
        Mockito.when((Object)topLevelDataType.getType()).thenReturn((Object)"model1.ExternalDataType");
        Mockito.when((Object)topLevelDataType.getSubDataTypes()).thenReturn(Collections.singletonList(subLevelDataType));
        Mockito.when((Object)this.itemDefinitionUtils.findByName("model1.ExternalDataType")).thenReturn(Optional.of(itemDefinition));
        Mockito.when((Object)itemDefinition.isAllowOnlyVisualChange()).thenReturn((Object)true);
        this.manager.withDataType(topLevelDataType);
        this.manager.withSubDataTypes(newSubDataTypes);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore, (VerificationMode)Mockito.never())).unIndex(Matchers.anyString());
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore, (VerificationMode)Mockito.never())).unIndex(Matchers.anyString());
        ((DataType)Mockito.verify((Object)topLevelDataType, (VerificationMode)Mockito.never())).setSubDataTypes(Matchers.anyListOf(DataType.class));
    }

    @Test
    public void testMakeDataTypeFromItemDefinition() {
        ItemDefinition simpleItemDefinitionFromMainItemDefinition = this.makeItem("name", "Text", true, new ItemDefinition[0]);
        ItemDefinition simpleItemDefinitionFromStructureItemDefinition = this.makeItem("company", "Text", "\"Red\", \"Hat\"", new ItemDefinition[0]);
        ItemDefinition structureItemDefinition = this.makeItem("employee", null, simpleItemDefinitionFromStructureItemDefinition);
        ItemDefinition existingItemDefinition = this.makeItem("address", "tAddress", new ItemDefinition[0]);
        ItemDefinition simpleItemDefinitionFromExistingItemDefinition = this.makeItem("street", "Text", new ItemDefinition[0]);
        ItemDefinition existingItemDefinitionWithFields = this.makeItem("address", "tAddress", simpleItemDefinitionFromExistingItemDefinition);
        ItemDefinition mainItemDefinition = this.makeItem("tPerson", null, simpleItemDefinitionFromMainItemDefinition, existingItemDefinition, structureItemDefinition);
        Mockito.when((Object)this.itemDefinitionUtils.getConstraintText((ItemDefinition)Matchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.itemDefinitionUtils.findByName((String)Matchers.any())).thenReturn(Optional.empty());
        Mockito.when((Object)this.itemDefinitionUtils.findByName((String)Matchers.eq((Object)"tAddress"))).thenReturn(Optional.of(existingItemDefinitionWithFields));
        DataType tPerson = this.manager.from(mainItemDefinition).get();
        Assert.assertFalse((boolean)tPerson.getUUID().isEmpty());
        Assert.assertEquals((Object)"tPerson", (Object)tPerson.getName());
        Assert.assertEquals((Object)STRUCTURE, (Object)tPerson.getType());
        Assert.assertEquals((long)3L, (long)tPerson.getSubDataTypes().size());
        Assert.assertTrue((boolean)tPerson.hasSubDataTypes());
        DataType name = (DataType)tPerson.getSubDataTypes().get(0);
        DataType address = (DataType)tPerson.getSubDataTypes().get(1);
        DataType street = (DataType)address.getSubDataTypes().get(0);
        DataType employee = (DataType)tPerson.getSubDataTypes().get(2);
        DataType company = (DataType)employee.getSubDataTypes().get(0);
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).index(tPerson.getUUID(), mainItemDefinition);
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).index(address.getUUID(), existingItemDefinition);
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).index(street.getUUID(), simpleItemDefinitionFromExistingItemDefinition);
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).index(employee.getUUID(), structureItemDefinition);
        ((ItemDefinitionStore)Mockito.verify((Object)this.itemDefinitionStore)).index(company.getUUID(), simpleItemDefinitionFromStructureItemDefinition);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).index(tPerson.getUUID(), tPerson);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).index(address.getUUID(), address);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).index(street.getUUID(), street);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).index(employee.getUUID(), employee);
        ((DataTypeStore)Mockito.verify((Object)this.dataTypeStore)).index(company.getUUID(), company);
        Assert.assertFalse((boolean)name.getUUID().isEmpty());
        Assert.assertEquals((Object)"name", (Object)name.getName());
        Assert.assertEquals((Object)"Text", (Object)name.getType());
        Assert.assertEquals((Object)"", (Object)name.getConstraint());
        Assert.assertSame((Object)tPerson.getUUID(), (Object)name.getParentUUID());
        Assert.assertEquals((long)0L, (long)name.getSubDataTypes().size());
        Assert.assertFalse((boolean)name.hasSubDataTypes());
        Assert.assertTrue((boolean)name.isList());
        Assert.assertFalse((boolean)name.isReadOnly());
        Assert.assertFalse((boolean)address.getUUID().isEmpty());
        Assert.assertEquals((Object)"address", (Object)address.getName());
        Assert.assertEquals((Object)"tAddress", (Object)address.getType());
        Assert.assertEquals((Object)"", (Object)address.getConstraint());
        Assert.assertSame((Object)tPerson.getUUID(), (Object)address.getParentUUID());
        Assert.assertEquals((long)1L, (long)address.getSubDataTypes().size());
        Assert.assertTrue((boolean)address.hasSubDataTypes());
        Assert.assertFalse((boolean)address.isList());
        Assert.assertFalse((boolean)address.isReadOnly());
        Assert.assertFalse((boolean)street.getUUID().isEmpty());
        Assert.assertEquals((Object)"street", (Object)street.getName());
        Assert.assertEquals((Object)"Text", (Object)street.getType());
        Assert.assertEquals((Object)"", (Object)street.getConstraint());
        Assert.assertSame((Object)address.getUUID(), (Object)street.getParentUUID());
        Assert.assertEquals((long)0L, (long)street.getSubDataTypes().size());
        Assert.assertFalse((boolean)street.hasSubDataTypes());
        Assert.assertFalse((boolean)street.isList());
        Assert.assertFalse((boolean)street.isReadOnly());
        Assert.assertFalse((boolean)employee.getUUID().isEmpty());
        Assert.assertEquals((Object)"employee", (Object)employee.getName());
        Assert.assertEquals((Object)STRUCTURE, (Object)employee.getType());
        Assert.assertEquals((Object)"", (Object)employee.getConstraint());
        Assert.assertSame((Object)tPerson.getUUID(), (Object)address.getParentUUID());
        Assert.assertEquals((long)1L, (long)employee.getSubDataTypes().size());
        Assert.assertTrue((boolean)employee.hasSubDataTypes());
        Assert.assertFalse((boolean)employee.isList());
        Assert.assertFalse((boolean)employee.isReadOnly());
        Assert.assertFalse((boolean)company.getUUID().isEmpty());
        Assert.assertEquals((Object)"company", (Object)company.getName());
        Assert.assertEquals((Object)"Text", (Object)company.getType());
        Assert.assertEquals((Object)"\"Red\", \"Hat\"", (Object)company.getConstraint());
        Assert.assertSame((Object)employee.getUUID(), (Object)company.getParentUUID());
        Assert.assertEquals((long)0L, (long)company.getSubDataTypes().size());
        Assert.assertFalse((boolean)company.hasSubDataTypes());
        Assert.assertFalse((boolean)company.isList());
        Assert.assertFalse((boolean)company.isReadOnly());
    }

    @Test
    public void testMakeDataTypeFromItemDefinitionWithAnImportedItemDefinition() {
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        QName typeRefMock = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)name.getValue()).thenReturn((Object)"id");
        Mockito.when((Object)typeRefMock.getLocalPart()).thenReturn((Object)"string");
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        Mockito.when((Object)itemDefinition.getItemComponent()).thenReturn(new ArrayList());
        Mockito.when((Object)itemDefinition.getTypeRef()).thenReturn((Object)typeRefMock);
        Mockito.when((Object)itemDefinition.isAllowOnlyVisualChange()).thenReturn((Object)true);
        Mockito.when((Object)this.itemDefinitionUtils.getConstraintText((ItemDefinition)Matchers.any())).thenCallRealMethod();
        Mockito.when((Object)this.itemDefinitionUtils.findByName((String)Matchers.any())).thenReturn(Optional.empty());
        DataType dataType = this.manager.from(itemDefinition).get();
        Assert.assertTrue((boolean)dataType.isReadOnly());
    }

    @Test
    public void testMakeDataTypeFromBuiltInType() {
        BuiltInType builtInType = BuiltInType.values()[0];
        DataType dataType = this.manager.from(builtInType).get();
        Assert.assertFalse((boolean)dataType.getUUID().isEmpty());
        Assert.assertEquals((Object)NONE, (Object)dataType.getName());
        Assert.assertEquals((Object)"number", (Object)dataType.getType());
        Assert.assertEquals(Collections.emptyList(), (Object)dataType.getSubDataTypes());
        Assert.assertFalse((boolean)dataType.hasSubDataTypes());
    }

    @Test
    public void testMakeDataTypeFromNewType() {
        DataType dataType = this.manager.fromNew().get();
        Assert.assertFalse((boolean)dataType.getUUID().isEmpty());
        Assert.assertEquals((Object)NONE, (Object)dataType.getName());
        Assert.assertEquals((Object)"Any", (Object)dataType.getType());
        Assert.assertEquals((Object)"", (Object)dataType.getConstraint());
        Assert.assertEquals(Collections.emptyList(), (Object)dataType.getSubDataTypes());
        Assert.assertFalse((boolean)dataType.hasSubDataTypes());
    }

    @Test
    public void testFromDataType() {
        String uuid = "uuid";
        String name = "name";
        String type = "type";
        List subDataTypes = Collections.emptyList();
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType0.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType0.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dataType0.getType()).thenReturn((Object)"type");
        Mockito.when((Object)dataType0.getSubDataTypes()).thenReturn(subDataTypes);
        DataType dataType = this.manager.from(dataType0).get();
        Assert.assertEquals((Object)"uuid", (Object)dataType.getUUID());
        Assert.assertEquals((Object)"name", (Object)dataType.getName());
        Assert.assertEquals((Object)"type", (Object)dataType.getType());
        Assert.assertEquals(Collections.emptyList(), (Object)dataType.getSubDataTypes());
        Assert.assertFalse((boolean)dataType.hasSubDataTypes());
    }

    @Test
    public void testMakeExternalDataTypesWhenTypeExists() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition0 = this.makeItem("itemDefinition0", "itemDefinition0", new ItemDefinition[0]);
        ItemDefinition itemDefinition1 = this.makeItem("itemDefinition1", "itemDefinition1", new ItemDefinition[0]);
        ItemDefinition itemDefinition2 = this.makeItem("itemDefinition2", "itemDefinition2", new ItemDefinition[0]);
        ItemDefinition itemDefinition3 = this.makeItem("itemDefinition3", "itemDefinition3", new ItemDefinition[0]);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataType dataType3 = (DataType)Mockito.mock(DataType.class);
        String type = "type";
        String parentUUID = "parentUUID";
        List<ItemDefinition> itemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3);
        Mockito.when((Object)parent.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)itemDefinition0.getItemComponent()).thenReturn(itemDefinitions);
        Mockito.when((Object)this.itemDefinitionUtils.findByName("type")).thenReturn(Optional.of(itemDefinition0));
        ((DataTypeManager)Mockito.doReturn((Object)itemDefinition0).when((Object)this.manager)).getItemDefinitionWithItemComponent(itemDefinition0);
        ((DataTypeManager)Mockito.doReturn((Object)dataType1).when((Object)this.manager)).createSubDataType(itemDefinition1);
        ((DataTypeManager)Mockito.doReturn((Object)dataType2).when((Object)this.manager)).createSubDataType(itemDefinition2);
        ((DataTypeManager)Mockito.doReturn((Object)dataType3).when((Object)this.manager)).createSubDataType(itemDefinition3);
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        List dataTypes = this.manager.makeExternalDataTypes("type");
        Assertions.assertThat((List)dataTypes).containsExactly((Object[])new DataType[]{dataType1, dataType2, dataType3});
    }

    @Test
    public void testMakeExternalDataTypesWhenTypeDoesNotExist() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String type = "type";
        String parentUUID = "parentUUID";
        Mockito.when((Object)parent.getUUID()).thenReturn((Object)"parentUUID");
        Mockito.when((Object)this.itemDefinitionUtils.findByName("type")).thenReturn(Optional.empty());
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        List dataTypes = this.manager.makeExternalDataTypes("type");
        Assert.assertTrue((boolean)dataTypes.isEmpty());
    }

    @Test
    public void testCreateSubDataType() {
        DataType expectedDataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<String> subDataTypeStack = Collections.singletonList("type");
        String expectedParentUUID = "expectedParentUUID";
        ((DataTypeManager)Mockito.doReturn((Object)expectedDataType).when((Object)this.manager)).getDataType();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).anotherManager();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).newDataType(Matchers.anyBoolean());
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withUUID();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withParentUUID(Matchers.anyString());
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinition((ItemDefinition)Matchers.any());
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinition((ItemDefinition)Matchers.any());
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinitionName();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinitionType();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinitionConstraint();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinitionCollection();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withTypeStack((List)Matchers.any());
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withItemDefinitionSubDataTypes();
        ((DataTypeManager)Mockito.doReturn((Object)this.manager).when((Object)this.manager)).withIndexedItemDefinition();
        ((DataTypeManager)Mockito.doReturn(subDataTypeStack).when((Object)this.manager)).getSubDataTypeStack();
        ((DataTypeManager)Mockito.doReturn((Object)expectedDataType).when((Object)this.manager)).get();
        Mockito.when((Object)expectedDataType.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)expectedDataType.getUUID()).thenReturn((Object)"expectedParentUUID");
        DataType actualDataType = this.manager.createSubDataType(itemDefinition);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.manager});
        ((DataTypeManager)inOrder.verify((Object)this.manager)).newDataType(false);
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withUUID();
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withParentUUID("expectedParentUUID");
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withItemDefinition(itemDefinition);
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withItemDefinitionName();
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withItemDefinitionType();
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withTypeStack(subDataTypeStack);
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withItemDefinitionSubDataTypes();
        ((DataTypeManager)inOrder.verify((Object)this.manager)).withIndexedItemDefinition();
        Assert.assertEquals((Object)expectedDataType, (Object)actualDataType);
    }

    @Test
    public void testGetStackTypeWhenDataTypeIsTopLevel() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String type = "tCity";
        Mockito.when((Object)parent.isTopLevel()).thenReturn((Object)true);
        Mockito.when((Object)parent.getName()).thenReturn((Object)"tCity");
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        Optional stackType = this.manager.getStackType();
        Assert.assertEquals((Object)"tCity", stackType.get());
    }

    @Test
    public void testGetStackTypeWhenDataTypeIsNotTopLevelAndStructureType() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String type = STRUCTURE;
        Mockito.when((Object)parent.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)parent.getType()).thenReturn((Object)STRUCTURE);
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        Optional stackType = this.manager.getStackType();
        Assert.assertFalse((boolean)stackType.isPresent());
    }

    @Test
    public void testGetStackTypeWhenDataTypeIsNotTopLevelAndDefaultType() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String type = BuiltInType.STRING.getName();
        Mockito.when((Object)parent.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)parent.getType()).thenReturn((Object)type);
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        Optional stackType = this.manager.getStackType();
        Assert.assertFalse((boolean)stackType.isPresent());
    }

    @Test
    public void testGetStackTypeWhenDataTypeIsNotTopLevelAndCustomType() {
        DataType parent = (DataType)Mockito.mock(DataType.class);
        String type = "tCity";
        Mockito.when((Object)parent.isTopLevel()).thenReturn((Object)false);
        Mockito.when((Object)parent.getType()).thenReturn((Object)"tCity");
        ((DataTypeManager)Mockito.doReturn((Object)parent).when((Object)this.manager)).getDataType();
        Optional stackType = this.manager.getStackType();
        Assert.assertEquals((Object)"tCity", stackType.get());
    }

    @Test
    public void testIsTypeAlreadyRepresentedWhenIsReturnsTrue() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        String type = "tCity";
        Mockito.when((Object)this.typeStack.get("uuid")).thenReturn(Collections.singletonList("tCity"));
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        ((DataTypeManager)Mockito.doReturn((Object)dataType).when((Object)this.manager)).getDataType();
        Assert.assertTrue((boolean)this.manager.isTypeAlreadyRepresented("tCity"));
    }

    @Test
    public void testIsTypeAlreadyRepresentedWhenIsReturnsFalse() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        Mockito.when((Object)this.typeStack.get("uuid")).thenReturn(Collections.singletonList("tPerson"));
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        ((DataTypeManager)Mockito.doReturn((Object)dataType).when((Object)this.manager)).getDataType();
        Assert.assertFalse((boolean)this.manager.isTypeAlreadyRepresented("tCity"));
    }

    @Test
    public void testGetSubDataTypeStack() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String uuid = "uuid";
        Mockito.when((Object)this.typeStack.get("uuid")).thenReturn(Arrays.asList("tPerson", "tCompany"));
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"tCity");
        ((DataTypeManager)Mockito.doReturn((Object)dataType).when((Object)this.manager)).getDataType();
        List actualTypeStack = this.manager.getSubDataTypeStack();
        List<String> expectedTypeStack = Arrays.asList("tPerson", "tCompany", "tCity");
        Assert.assertEquals(expectedTypeStack, (Object)actualTypeStack);
    }

    @Test
    public void testGetItemDefinitionWithItemComponent() {
        ItemDefinition expectedItemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition tPerson = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        QName tPersonQName = (QName)Mockito.mock(QName.class);
        String tPersonValue = "tPersonRaw";
        Mockito.when((Object)tPerson.getTypeRef()).thenReturn((Object)tPersonQName);
        Mockito.when((Object)tPersonQName.getLocalPart()).thenReturn((Object)"tPersonRaw");
        Mockito.when((Object)this.itemDefinitionUtils.findByName("tPersonRaw")).thenReturn(Optional.of(expectedItemDefinition));
        ItemDefinition actualItemDefinition = this.manager.getItemDefinitionWithItemComponent(tPerson);
        Assert.assertEquals((Object)expectedItemDefinition, (Object)actualItemDefinition);
    }

    @Test
    public void testWithUniqueNameWhenNameIsUnique() {
        DataType dataType = this.makeDataType("uuid1");
        ((DataTypeManager)Mockito.doReturn((Object)dataType).when((Object)this.manager)).get();
        ((DataTypeNameValidator)Mockito.doReturn(Arrays.asList(this.makeDataType("uuid2", "tPerson"), this.makeDataType("uuid3", "tCity"))).when((Object)this.dataTypeNameValidator)).siblings(dataType);
        String actualDataTypeName = this.manager.withDataType(dataType).withUniqueName("tCompany").get().getName();
        String expectedDataTypeName = "tCompany";
        Assert.assertEquals((Object)"tCompany", (Object)actualDataTypeName);
    }

    @Test
    public void testAsStructure() {
        DataType dataType = this.makeDataType("uuid");
        this.manager.withDataType(dataType).asStructure();
        ((DataTypeManager)Mockito.verify((Object)this.manager)).withType(STRUCTURE);
    }

    @Test
    public void testGetTopLevelDataTypeWithName() {
        String topLevelType = "tType";
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Optional<DataType> type = Optional.of(dataType);
        ((DataTypeManager)Mockito.doReturn(type).when((Object)this.manager)).findTopLevelDataTypeWithName("tType");
        Optional actual = this.manager.getTopLevelDataTypeWithName("tType");
        Assert.assertTrue((boolean)actual.isPresent());
        Assert.assertEquals((Object)dataType, actual.get());
    }

    @Test
    public void testFindTopLevelDataTypeWithName() {
        DataType dt1 = (DataType)Mockito.mock(DataType.class);
        String dt1Name = "The Name";
        Mockito.when((Object)dt1.getName()).thenReturn((Object)"The Name");
        DataType dt2 = (DataType)Mockito.mock(DataType.class);
        String dt2Name = "The Other Name";
        Mockito.when((Object)dt2.getName()).thenReturn((Object)"The Other Name");
        List<DataType> store = Arrays.asList(dt1, dt2);
        Mockito.when((Object)this.dataTypeStore.getTopLevelDataTypes()).thenReturn(store);
        Optional foundDt = this.manager.findTopLevelDataTypeWithName("The Name");
        Assert.assertTrue((boolean)foundDt.isPresent());
        Assert.assertEquals((Object)dt1, foundDt.get());
        foundDt = this.manager.findTopLevelDataTypeWithName("The Other Name");
        Assert.assertTrue((boolean)foundDt.isPresent());
        Assert.assertEquals((Object)dt2, foundDt.get());
        Optional notFoundDt = this.manager.findTopLevelDataTypeWithName("not present");
        Assert.assertFalse((boolean)notFoundDt.isPresent());
    }

    @Test
    public void testWithUniqueNameWhenNameIsNotUnique() {
        DataType dataType = this.makeDataType("uuid1");
        DataType tPerson = this.makeDataType("uuid2", "tPerson");
        DataType tCompany1 = this.makeDataType("uuid3", "tCompany");
        DataType tCompany2 = this.makeDataType("uuid3", "tCompany - 2");
        List<DataType> siblings = Arrays.asList(tPerson, tCompany1, tCompany2);
        ((DataTypeManager)Mockito.doReturn((Object)dataType).when((Object)this.manager)).get();
        ((DataTypeNameValidator)Mockito.doReturn(siblings).when((Object)this.dataTypeNameValidator)).siblings(dataType);
        String actualDataTypeName = this.manager.withDataType(dataType).withUniqueName("tCompany").get().getName();
        String expectedDataTypeName = "tCompany - 3";
        Assert.assertEquals((Object)"tCompany - 3", (Object)actualDataTypeName);
    }

    private ItemDefinition makeItem(String itemName, String itemType, boolean isCollection, ItemDefinition ... subItemDefinitions) {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>(Arrays.asList(subItemDefinitions));
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Name name = (Name)Mockito.mock(Name.class);
        QName typeRefMock = (QName)Mockito.mock(QName.class);
        QName typeRef = subItemDefinitions.length == 0 ? typeRefMock : null;
        Mockito.when((Object)name.getValue()).thenReturn((Object)itemName);
        Mockito.when((Object)typeRefMock.getLocalPart()).thenReturn((Object)itemType);
        Mockito.when((Object)itemDefinition.getName()).thenReturn((Object)name);
        Mockito.when((Object)itemDefinition.getItemComponent()).thenReturn(itemDefinitions);
        Mockito.when((Object)itemDefinition.getTypeRef()).thenReturn((Object)typeRef);
        Mockito.when((Object)itemDefinition.isIsCollection()).thenReturn((Object)isCollection);
        return itemDefinition;
    }

    private ItemDefinition makeItem(String itemName, String itemType, ItemDefinition ... subItemDefinitions) {
        return this.makeItem(itemName, itemType, false, subItemDefinitions);
    }

    private ItemDefinition makeItem(String itemName, String itemType, String constraint, ItemDefinition ... subItemDefinitions) {
        ItemDefinition itemDefinition = this.makeItem(itemName, itemType, false, subItemDefinitions);
        UnaryTests unaryTests = (UnaryTests)Mockito.mock(UnaryTests.class);
        Mockito.when((Object)unaryTests.getText()).thenReturn((Object)new Text(constraint));
        Mockito.when((Object)itemDefinition.getAllowedValues()).thenReturn((Object)unaryTests);
        return itemDefinition;
    }

    private DataType makeDataType(String uuid, String name, String type) {
        DataType dataType = this.makeDataType(uuid, name);
        ((DataType)Mockito.doReturn((Object)type).when((Object)dataType)).getType();
        return dataType;
    }

    private DataType makeDataType(String uuid, String name) {
        DataType dataType = this.makeDataType(uuid);
        ((DataType)Mockito.doReturn((Object)name).when((Object)dataType)).getName();
        return dataType;
    }

    private DataType makeDataType(String uuid) {
        DataType dataType = (DataType)Mockito.spy((Object)new DataType(null));
        ((DataType)Mockito.doReturn((Object)uuid).when((Object)dataType)).getUUID();
        ((DataType)Mockito.doReturn((Object)false).when((Object)dataType)).isReadOnly();
        return dataType;
    }

    class DataTypeManagerFake
    extends DataTypeManager {
        DataTypeManagerFake() {
            super(DataTypeManagerTest.this.translationService, DataTypeManagerTest.this.recordEngine, DataTypeManagerTest.this.itemDefinitionStore, DataTypeManagerTest.this.dataTypeStore, DataTypeManagerTest.this.itemDefinitionUtils, DataTypeManagerTest.this.dataTypeManagers, DataTypeManagerTest.this.dataTypeNameValidator, DataTypeManagerTest.this.typeStack);
        }

        DataTypeManager anotherManager() {
            return new DataTypeManagerFake();
        }
    }
}

