/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.core.client.JavaScriptObject;
import elemental2.dom.Element;
import elemental2.dom.HTMLElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.ScrollHelper;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.uberfire.client.views.pfly.selectpicker.JQuery;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScrollHelperTest {
    private ScrollHelper scrollHelper;

    @Before
    public void setup() {
        this.scrollHelper = (ScrollHelper)Mockito.spy((Object)new ScrollHelper());
    }

    @Test
    public void testScrollToBottom() {
        Element element = (Element)Mockito.mock(Element.class);
        ((ScrollHelper)Mockito.doNothing().when((Object)this.scrollHelper)).scrollTo(element, element);
        this.scrollHelper.scrollToBottom(element);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).scrollTo(element, element);
    }

    @Test
    public void testScrollToWithTwoArguments() {
        Element target = (Element)Mockito.mock(Element.class);
        Element container = (Element)Mockito.mock(Element.class);
        ((ScrollHelper)Mockito.doNothing().when((Object)this.scrollHelper)).scrollTo((Element)Matchers.any(), (Element)Matchers.any(), Matchers.anyInt());
        this.scrollHelper.scrollTo(target, container);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).scrollTo(target, container, 0);
    }

    @Test
    public void testScrollToWithThreeArguments() {
        HTMLElement target = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement container = (HTMLElement)Mockito.mock(HTMLElement.class);
        target.offsetTop = 8.0;
        container.offsetTop = 4.0;
        this.scrollHelper.scrollTo((Element)target, (Element)container, 2);
        Double expectedScrollTop = 2.0;
        Double actualScrollTop = container.scrollTop;
        Assert.assertEquals((Object)expectedScrollTop, (Object)actualScrollTop);
    }

    @Test
    public void testAnimatedScrollToBottomWithOneArgument() {
        Element element = (Element)Mockito.mock(Element.class);
        double scrollHeight = 123.0;
        element.scrollHeight = 123.0;
        ((ScrollHelper)Mockito.doNothing().when((Object)this.scrollHelper)).animatedScrollToBottom((Element)Matchers.any(), Matchers.anyDouble());
        this.scrollHelper.animatedScrollToBottom(element);
        ((ScrollHelper)Mockito.verify((Object)this.scrollHelper)).animatedScrollToBottom(element, 123.0);
    }

    @Test
    public void testAnimatedScrollToBottomWithTwoArguments() {
        Element element = (Element)Mockito.mock(Element.class);
        JQuery jQuery = (JQuery)Mockito.mock(JQuery.class);
        JavaScriptObject javaScriptObject = (JavaScriptObject)Mockito.mock(JavaScriptObject.class);
        double scrollHeight = 123.0;
        PowerMockito.when((Object)this.scrollHelper.elementJQuery(element)).thenReturn((Object)jQuery);
        ((ScrollHelper)Mockito.doReturn((Object)javaScriptObject).when((Object)this.scrollHelper)).property("scrollTop", 123.0);
        this.scrollHelper.animatedScrollToBottom(element, 123.0);
        ((JQuery)Mockito.verify((Object)jQuery)).animate(javaScriptObject, 800);
    }
}

