/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.common.errors;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsInvalidErrorMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeNameIsInvalidErrorMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetStrongMessage() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String expectedErrorMessage = "*Expected strong message.*";
        DataTypeNameIsInvalidErrorMessage errorMessage = new DataTypeNameIsInvalidErrorMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeNameIsInvalidErrorMessage.StrongMessage", new Object[0])).thenReturn((Object)"*Expected strong message.*");
        String actualErrorMessage = errorMessage.getStrongMessage(dataType);
        Assert.assertEquals((Object)"*Expected strong message.*", (Object)actualErrorMessage);
    }

    @Test
    public void testGetRegularMessage() {
        String expectedErrorMessage = "Expected regular message.";
        DataTypeNameIsInvalidErrorMessage errorMessage = new DataTypeNameIsInvalidErrorMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeNameIsInvalidErrorMessage.RegularMessage", new Object[0])).thenReturn((Object)"Expected regular message.");
        String actualErrorMessage = errorMessage.getRegularMessage();
        Assert.assertEquals((Object)"Expected regular message.", (Object)actualErrorMessage);
    }
}

