/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.imported.ImportDataObjectModal;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ImportDataObjectModalTest {
    @Mock
    private ImportDataObjectModal.View view;
    @Mock
    private DMNClientServicesProxy client;
    private ImportDataObjectModal modal;

    @Before
    public void setup() {
        this.modal = (ImportDataObjectModal)Mockito.spy((Object)new ImportDataObjectModal(this.view, this.client));
    }

    @Test
    public void testShow() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ServiceCallback serviceCallback = (ServiceCallback)Mockito.mock(ServiceCallback.class);
        ((ImportDataObjectModal)Mockito.doReturn((Object)serviceCallback).when((Object)this.modal)).wrap(consumer);
        ((ImportDataObjectModal)Mockito.doReturn((Object)consumer).when((Object)this.modal)).getConsumer();
        this.modal.show();
        ((DMNClientServicesProxy)Mockito.verify((Object)this.client)).loadDataObjects(serviceCallback);
    }

    @Test
    public void testWrap() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ServiceCallback service = this.modal.wrap(consumer);
        List items = (List)Mockito.mock(List.class);
        service.onSuccess((Object)items);
        ((Consumer)Mockito.verify((Object)consumer)).accept(items);
    }

    @Test
    public void testGetConsumer() {
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).superShow();
        Consumer consumer = this.modal.getConsumer();
        List items = (List)Mockito.mock(List.class);
        Mockito.when((Object)items.isEmpty()).thenReturn((Object)false);
        consumer.accept(items);
        ((ImportDataObjectModal.View)Mockito.verify((Object)this.view)).clear();
        ((ImportDataObjectModal.View)Mockito.verify((Object)this.view)).addItems(items);
        ((ImportDataObjectModal)Mockito.verify((Object)this.modal)).superShow();
    }

    @Test
    public void testSetup() {
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).callSuperSetup();
        this.modal.setup(consumer);
        ((ImportDataObjectModal)Mockito.verify((Object)this.modal)).callSuperSetup();
        Assert.assertEquals((Object)consumer, (Object)this.modal.getDataObjectsConsumer());
    }

    @Test
    public void testHide() {
        List importedObjects = (List)Mockito.mock(List.class);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).callSuperSetup();
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).superHide();
        this.modal.setup(consumer);
        this.modal.hide(importedObjects);
        ((Consumer)Mockito.verify((Object)consumer)).accept(importedObjects);
        ((ImportDataObjectModal)Mockito.verify((Object)this.modal)).superHide();
    }

    @Test
    public void testHideWhenThereIsNotConsumer() {
        List importedObjects = (List)Mockito.mock(List.class);
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).callSuperSetup();
        ((ImportDataObjectModal)Mockito.doNothing().when((Object)this.modal)).superHide();
        this.modal.hide(importedObjects);
        ((ImportDataObjectModal)Mockito.verify((Object)this.modal)).superHide();
    }
}

