/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListSubItem;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TreeListItemTest {
    @Mock
    private TreeListItem.View view;
    @Mock
    private HTMLElement viewElement;
    private TreeListItem treeListItem;

    @Before
    public void setup() {
        this.treeListItem = new TreeListItem(this.view);
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)this.viewElement);
    }

    @Test
    public void testSetup() {
        this.treeListItem.setup();
        ((TreeListItem.View)Mockito.verify((Object)this.view)).init((Object)this.treeListItem);
    }

    @Test
    public void testGetElement() {
        Node actual = this.treeListItem.getElement();
        Assert.assertEquals((Object)this.viewElement, (Object)actual);
    }

    @Test
    public void testGetSetDescription() {
        String description = "Description.";
        this.treeListItem.setDescription("Description.");
        String actual = this.treeListItem.getDescription();
        Assert.assertEquals((Object)"Description.", (Object)actual);
    }

    @Test
    public void testAddSubItem() {
        TreeListSubItem subItem = (TreeListSubItem)Mockito.mock(TreeListSubItem.class);
        this.treeListItem.addSubItem(subItem);
    }

    @Test
    public void testUpdateView() {
        this.treeListItem.updateView();
        ((TreeListItem.View)Mockito.verify((Object)this.view)).populate(this.treeListItem);
    }

    @Test
    public void testGetSetIsSelected() {
        this.treeListItem.setIsSelected(true);
        Assert.assertTrue((boolean)this.treeListItem.getIsSelected());
        this.treeListItem.setIsSelected(false);
        Assert.assertFalse((boolean)this.treeListItem.getIsSelected());
    }
}

