/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.imported.treelist;

import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeList;
import org.kie.workbench.common.dmn.client.editors.types.imported.treelist.TreeListItem;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TreeListTest {
    @Mock
    private TreeList.View view;
    @Mock
    private HTMLElement element;
    @Mock
    private TreeListItem itemOne;
    @Mock
    private TreeListItem itemTwo;
    @Mock
    private TreeListItem itemThree;
    private TreeList treeList;

    @Before
    public void setup() {
        this.treeList = (TreeList)Mockito.spy((Object)new TreeList(this.view));
        List<TreeListItem> currentItems = Arrays.asList(this.itemOne, this.itemTwo, this.itemThree);
        ((TreeList)Mockito.doReturn(currentItems).when((Object)this.treeList)).getCurrentItems();
        Mockito.when((Object)this.view.getElement()).thenReturn((Object)this.element);
    }

    @Test
    public void testPopulate() {
        ((TreeList)Mockito.doNothing().when((Object)this.treeList)).refresh();
        List items = (List)Mockito.mock(List.class);
        this.treeList.populate(items);
        ((TreeList)Mockito.verify((Object)this.treeList)).refresh();
    }

    @Test
    public void testRefresh() {
        this.treeList.refresh();
        ((TreeList)Mockito.verify((Object)this.treeList)).clear();
        ((TreeListItem)Mockito.verify((Object)this.itemOne)).updateView();
        ((TreeListItem)Mockito.verify((Object)this.itemTwo)).updateView();
        ((TreeListItem)Mockito.verify((Object)this.itemThree)).updateView();
        ((TreeList.View)Mockito.verify((Object)this.view)).add(this.itemOne);
        ((TreeList.View)Mockito.verify((Object)this.view)).add(this.itemTwo);
        ((TreeList.View)Mockito.verify((Object)this.view)).add(this.itemThree);
    }

    @Test
    public void testClear() {
        this.treeList.clear();
        ((TreeList.View)Mockito.verify((Object)this.view)).clear();
    }

    @Test
    public void testGetElement() {
        Node actual = this.treeList.getElement();
        Assert.assertEquals((Object)this.element, (Object)actual);
    }

    @Test
    public void testClearSelection() {
        this.treeList.clearSelection();
        ((TreeListItem)Mockito.verify((Object)this.itemOne)).setIsSelected(false);
        ((TreeListItem)Mockito.verify((Object)this.itemTwo)).setIsSelected(false);
        ((TreeListItem)Mockito.verify((Object)this.itemThree)).setIsSelected(false);
    }

    @Test
    public void testGetSelectedItems() {
        Mockito.when((Object)this.itemThree.getIsSelected()).thenReturn((Object)true);
        List selectedItems = this.treeList.getSelectedItems();
        Assert.assertTrue((boolean)selectedItems.contains(this.itemThree));
        Assert.assertFalse((boolean)selectedItems.contains(this.itemOne));
        Assert.assertFalse((boolean)selectedItems.contains(this.itemTwo));
    }
}

