/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItemView;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeListItemViewTest {
    @Mock
    private HTMLDivElement row;
    @Mock
    private HTMLElement arrow;
    @Mock
    private HTMLElement nameText;
    @Mock
    private HTMLInputElement nameInput;
    @Mock
    private HTMLElement type;
    @Mock
    private HTMLDivElement constraint;
    @Mock
    private HTMLDivElement listContainer;
    @Mock
    private HTMLDivElement listYes;
    @Mock
    private HTMLButtonElement editButton;
    @Mock
    private HTMLButtonElement saveButton;
    @Mock
    private HTMLButtonElement closeButton;
    @Mock
    private HTMLButtonElement insertNestedFieldButton;
    @Mock
    private HTMLButtonElement removeButton;
    @Mock
    private DataTypeListItem presenter;
    @Mock
    private HTMLElement dataTypeListElement;
    @Mock
    private HTMLElement dragAndDropElement;
    @Mock
    private TranslationService translationService;
    private DataTypeListItemView view;

    @Before
    public void setup() {
        this.view = (DataTypeListItemView)Mockito.spy((Object)new DataTypeListItemView(this.row, this.translationService));
        this.view.init(this.presenter);
        Mockito.when((Object)this.presenter.getDragAndDropElement()).thenReturn((Object)this.dragAndDropElement);
        ((DataTypeListItem)Mockito.doReturn((Object)this.dataTypeListElement).when((Object)this.presenter)).getDragAndDropListElement();
    }

    @Test
    public void testSetDataType() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupRowMetadata(dataType);
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupArrow(dataType);
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupReadOnly(dataType);
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupActionButtons();
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupEventHandlers();
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setupShortcutsTooltips();
        this.view.setDataType(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupRowMetadata(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupArrow(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupReadOnly(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupActionButtons();
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupEventHandlers();
    }

    @Test
    public void testSetupRowMetadata() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"1234");
        Mockito.when((Object)dataType.getParentUUID()).thenReturn((Object)"4567");
        this.dragAndDropElement.classList = classList;
        this.view.setupRowMetadata(dataType);
        ((HTMLElement)Mockito.verify((Object)this.dragAndDropElement)).setAttribute("data-row-uuid", "1234");
        ((HTMLElement)Mockito.verify((Object)this.dragAndDropElement)).setAttribute("data-parent-row-uuid", "4567");
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupRowCSSClass(dataType);
    }

    @Test
    public void testSetupSubDataTypesCSSClassWhenDataTypeHasSubDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dragAndDropElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)true);
        this.view.setupSubDataTypesCSSClass(dataType);
        ((DOMTokenList)Mockito.verify((Object)this.dragAndDropElement.classList)).add(new String[]{"has-sub-data-types"});
    }

    @Test
    public void testSetupSubDataTypesCSSClassWhenDataTypeDoesNotHaveSubDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dragAndDropElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)false);
        this.view.setupSubDataTypesCSSClass(dataType);
        ((DOMTokenList)Mockito.verify((Object)this.dragAndDropElement.classList)).remove(new String[]{"has-sub-data-types"});
    }

    @Test
    public void testSetupReadOnlyCSSClassWhenDataTypeHasSubDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dragAndDropElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dataType.isReadOnly()).thenReturn((Object)true);
        this.view.setupReadOnlyCSSClass(dataType);
        ((DOMTokenList)Mockito.verify((Object)this.dragAndDropElement.classList)).add(new String[]{"read-only"});
    }

    @Test
    public void testSetupReadOnlyCSSClassWhenDataTypeDoesNotHaveSubDataTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        this.dragAndDropElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)dataType.isReadOnly()).thenReturn((Object)false);
        this.view.setupReadOnlyCSSClass(dataType);
        ((DOMTokenList)Mockito.verify((Object)this.dragAndDropElement.classList)).remove(new String[]{"read-only"});
    }

    @Test
    public void testToggleArrowWhenTrue() {
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.arrow).when((Object)this.view)).getArrow();
        this.arrow.classList = classList;
        this.view.toggleArrow(true);
        ((DOMTokenList)Mockito.verify((Object)classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testToggleArrowWhenFalse() {
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.arrow).when((Object)this.view)).getArrow();
        this.arrow.classList = classList;
        this.view.toggleArrow(false);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testSetupArrowWhenDataTypeHasSubTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.arrow).when((Object)this.view)).getArrow();
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)true);
        this.arrow.classList = classList;
        this.view.setupArrow(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).toggleArrow(true);
    }

    @Test
    public void testSetupArrowWhenDataTypeDoesNotHaveSubTypes() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.arrow).when((Object)this.view)).getArrow();
        Mockito.when((Object)dataType.hasSubDataTypes()).thenReturn((Object)false);
        this.arrow.classList = classList;
        this.view.setupArrow(dataType);
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).toggleArrow(false);
    }

    @Test
    public void testSetupReadOnly() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        String name = "name";
        String constraint = "constraint";
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).setName("name");
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dataType.getConstraint()).thenReturn((Object)"constraint");
        this.nameInput.classList = classList;
        this.view.setupReadOnly(dataType);
        ((DOMTokenList)Mockito.verify((Object)classList)).add(new String[]{"hidden"});
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setName("name");
    }

    @Test
    public void testSetName() {
        String name = "name";
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameText).when((Object)this.view)).getNameText();
        this.view.setName("name");
        Assert.assertEquals((Object)"name", (Object)this.nameText.textContent);
        Assert.assertEquals((Object)"name", (Object)this.nameInput.value);
    }

    @Test
    public void testSetupShortcutsTooltips() {
        Element editButton = (Element)Mockito.mock(Element.class);
        Element saveButton = (Element)Mockito.mock(Element.class);
        Element insertNestedField = (Element)Mockito.mock(Element.class);
        Element closeButton = (Element)Mockito.mock(Element.class);
        Element removeButton = (Element)Mockito.mock(Element.class);
        Element arrow = (Element)Mockito.mock(Element.class);
        String arrowKeysTooltip = "arrowKeysTooltip";
        ((DataTypeListItemView)Mockito.doReturn((Object)editButton).when((Object)this.view)).getEditButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)saveButton).when((Object)this.view)).getSaveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)insertNestedField).when((Object)this.view)).getInsertNestedFieldButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)closeButton).when((Object)this.view)).getCloseButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)removeButton).when((Object)this.view)).getRemoveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        Mockito.when((Object)this.translationService.format("DataTypeListItemView.ArrowKeysTooltip", new Object[0])).thenReturn((Object)"arrowKeysTooltip");
        this.view.setupShortcutsTooltips();
        ((Element)Mockito.verify((Object)editButton)).setAttribute("data-title", "Ctrl + E");
        ((Element)Mockito.verify((Object)saveButton)).setAttribute("data-title", "Ctrl + S");
        ((Element)Mockito.verify((Object)insertNestedField)).setAttribute("data-title", "Ctrl + B");
        ((Element)Mockito.verify((Object)closeButton)).setAttribute("data-title", "Esc");
        ((Element)Mockito.verify((Object)removeButton)).setAttribute("data-title", "Ctrl + Backspace");
        ((Element)Mockito.verify((Object)arrow)).setAttribute("data-title", "arrowKeysTooltip");
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).setupTooltips();
    }

    @Test
    public void testSetupTooltips() {
        this.view.setupTooltips();
    }

    @Test
    public void testSetupEventHandlers() {
        Element editButton = (Element)Mockito.mock(Element.class);
        Element saveButton = (Element)Mockito.mock(Element.class);
        Element closeButton = (Element)Mockito.mock(Element.class);
        Element arrow = (Element)Mockito.mock(Element.class);
        Element insertNestedField = (Element)Mockito.mock(Element.class);
        Element removeButton = (Element)Mockito.mock(Element.class);
        Element.OnclickCallbackFn onEditAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        Element.OnclickCallbackFn onSaveAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        Element.OnclickCallbackFn onCloseAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        Element.OnclickCallbackFn onArrowClickAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        Element.OnclickCallbackFn onInsertNestedFieldAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        Element.OnclickCallbackFn onRemoveButtonAction = (Element.OnclickCallbackFn)Mockito.mock(Element.OnclickCallbackFn.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)editButton).when((Object)this.view)).getEditButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)saveButton).when((Object)this.view)).getSaveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)closeButton).when((Object)this.view)).getCloseButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        ((DataTypeListItemView)Mockito.doReturn((Object)insertNestedField).when((Object)this.view)).getInsertNestedFieldButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)removeButton).when((Object)this.view)).getRemoveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)onEditAction).when((Object)this.view)).getOnEditAction();
        ((DataTypeListItemView)Mockito.doReturn((Object)onSaveAction).when((Object)this.view)).getOnSaveAction();
        ((DataTypeListItemView)Mockito.doReturn((Object)onCloseAction).when((Object)this.view)).getOnCloseAction();
        ((DataTypeListItemView)Mockito.doReturn((Object)onArrowClickAction).when((Object)this.view)).getOnArrowClickAction();
        ((DataTypeListItemView)Mockito.doReturn((Object)onInsertNestedFieldAction).when((Object)this.view)).getOnInsertNestedFieldAction();
        ((DataTypeListItemView)Mockito.doReturn((Object)onRemoveButtonAction).when((Object)this.view)).getOnRemoveButtonAction();
        editButton.onclick = null;
        saveButton.onclick = null;
        closeButton.onclick = null;
        arrow.onclick = null;
        insertNestedField.onclick = null;
        removeButton.onclick = null;
        this.view.setupEventHandlers();
        Assert.assertEquals((Object)onEditAction, (Object)editButton.onclick);
        Assert.assertEquals((Object)onSaveAction, (Object)saveButton.onclick);
        Assert.assertEquals((Object)onCloseAction, (Object)closeButton.onclick);
        Assert.assertEquals((Object)onArrowClickAction, (Object)arrow.onclick);
        Assert.assertEquals((Object)onInsertNestedFieldAction, (Object)insertNestedField.onclick);
        Assert.assertEquals((Object)onRemoveButtonAction, (Object)removeButton.onclick);
    }

    @Test
    public void testOnArrowClickEvent() {
        Element.OnclickCallbackFn action = this.view.getOnArrowClickAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).expandOrCollapseSubTypes();
    }

    @Test
    public void testOnInsertNestedField() {
        Element.OnclickCallbackFn action = this.view.getOnInsertNestedFieldAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).insertNestedField();
    }

    @Test
    public void testOnRemoveButton() {
        Element.OnclickCallbackFn action = this.view.getOnRemoveButtonAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).remove();
    }

    @Test
    public void testOnEditClick() {
        Element.OnclickCallbackFn action = this.view.getOnEditAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).enableEditMode();
    }

    @Test
    public void testOnSaveClick() {
        Element.OnclickCallbackFn action = this.view.getOnSaveAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).saveAndCloseEditMode();
    }

    @Test
    public void testOnCloseClick() {
        Element.OnclickCallbackFn action = this.view.getOnCloseAction();
        Assert.assertTrue((boolean)((Boolean)action.onInvoke((Event)Mockito.mock(Event.class))));
        ((DataTypeListItem)Mockito.verify((Object)this.presenter)).disableEditMode();
    }

    @Test
    public void testSetupSelectComponent() {
        DataTypeSelect select = (DataTypeSelect)Mockito.mock(DataTypeSelect.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element element = (Element)Mockito.mock(Element.class);
        this.type.firstChild = element;
        ((DataTypeListItemView)Mockito.doReturn((Object)this.type).when((Object)this.view)).getType();
        Mockito.when((Object)select.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.type.removeChild((Node)element)).then(a -> {
            this.type.firstChild = null;
            return element;
        });
        this.view.setupSelectComponent(select);
        ((HTMLElement)Mockito.verify((Object)this.type)).removeChild((Node)element);
        ((HTMLElement)Mockito.verify((Object)this.type)).appendChild((Node)htmlElement);
    }

    @Test
    public void testSetupConstraintComponent() {
        DataTypeConstraint constraintComponent = (DataTypeConstraint)Mockito.mock(DataTypeConstraint.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element element = (Element)Mockito.mock(Element.class);
        this.constraint.firstChild = element;
        ((DataTypeListItemView)Mockito.doReturn((Object)this.constraint).when((Object)this.view)).getConstraintContainer();
        Mockito.when((Object)constraintComponent.getElement()).thenReturn((Object)htmlElement);
        Mockito.when((Object)this.constraint.removeChild((Node)element)).then(a -> {
            this.constraint.firstChild = null;
            return element;
        });
        this.view.setupConstraintComponent(constraintComponent);
        ((HTMLDivElement)Mockito.verify((Object)this.constraint)).removeChild((Node)element);
        ((HTMLDivElement)Mockito.verify((Object)this.constraint)).appendChild((Node)htmlElement);
    }

    @Test
    public void testSetupListComponent() {
        SmallSwitchComponent switchComponent = (SmallSwitchComponent)Mockito.mock(SmallSwitchComponent.class);
        HTMLElement htmlElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Element element = (Element)Mockito.mock(Element.class);
        this.listContainer.firstChild = element;
        Mockito.when((Object)switchComponent.getElement()).thenReturn((Object)htmlElement);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.listContainer).when((Object)this.view)).getListCheckBoxContainer();
        Mockito.when((Object)this.listContainer.removeChild((Node)element)).then(a -> {
            this.listContainer.firstChild = null;
            return element;
        });
        this.view.setupListComponent(switchComponent);
        ((HTMLDivElement)Mockito.verify((Object)this.listContainer)).removeChild((Node)element);
        ((HTMLDivElement)Mockito.verify((Object)this.listContainer)).appendChild((Node)htmlElement);
    }

    @Test
    public void testShowCollectionContainer() {
        ((DataTypeListItemView)Mockito.doReturn((Object)this.listContainer).when((Object)this.view)).getListContainer();
        this.listContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showListContainer();
        ((DOMTokenList)Mockito.verify((Object)this.listContainer.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideCollectionContainer() {
        ((DataTypeListItemView)Mockito.doReturn((Object)this.listContainer).when((Object)this.view)).getListContainer();
        this.listContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideListContainer();
        ((DOMTokenList)Mockito.verify((Object)this.listContainer.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowCollectionYesLabel() {
        ((DataTypeListItemView)Mockito.doReturn((Object)this.listYes).when((Object)this.view)).getListYes();
        this.listYes.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.showListYesLabel();
        ((DOMTokenList)Mockito.verify((Object)this.listYes.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideCollectionYesLabel() {
        ((DataTypeListItemView)Mockito.doReturn((Object)this.listYes).when((Object)this.view)).getListYes();
        this.listYes.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.hideListYesLabel();
        ((DOMTokenList)Mockito.verify((Object)this.listYes.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testSetupActionButtons() {
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).showEditButton();
        this.view.setupActionButtons();
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).showEditButton();
    }

    @Test
    public void testShowEditButton() {
        this.editButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.insertNestedFieldButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.removeButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.saveButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.closeButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.editButton).when((Object)this.view)).getEditButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.insertNestedFieldButton).when((Object)this.view)).getInsertNestedFieldButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.removeButton).when((Object)this.view)).getRemoveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.saveButton).when((Object)this.view)).getSaveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.closeButton).when((Object)this.view)).getCloseButton();
        this.view.showEditButton();
        ((DOMTokenList)Mockito.verify((Object)this.editButton.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.insertNestedFieldButton.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.removeButton.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.saveButton.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeButton.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testShowSaveButton() {
        this.editButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.insertNestedFieldButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.removeButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.saveButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.closeButton.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.editButton).when((Object)this.view)).getEditButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.insertNestedFieldButton).when((Object)this.view)).getInsertNestedFieldButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.removeButton).when((Object)this.view)).getRemoveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.saveButton).when((Object)this.view)).getSaveButton();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.closeButton).when((Object)this.view)).getCloseButton();
        this.view.showSaveButton();
        ((DOMTokenList)Mockito.verify((Object)this.editButton.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.insertNestedFieldButton.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.removeButton.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.saveButton.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeButton.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testExpand() {
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        ((DataTypeListItemView)Mockito.doReturn((Object)false).when((Object)this.view)).isCollapsed((Element)Matchers.any());
        arrow.classList = arrowClassList;
        DataType parentDataType = (DataType)Mockito.mock(DataType.class);
        String parentDataTypeUUID = "parentDataTypeUUID";
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element child1 = this.makeChildElement("child1UUID");
        Element child2 = this.makeChildElement("child2UUID");
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Mockito.when((Object)parentDataType.getUUID()).thenReturn((Object)"parentDataTypeUUID");
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentDataTypeUUID");
        ((DataTypeListItemView)Mockito.doReturn((Object)parentDataType).when((Object)this.view)).getDataType();
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        this.mockDOMElementByUUID("parentDataTypeUUID", parentElement);
        this.mockDOMElementsByParentUUID("parentDataTypeUUID", (NodeList<Element>)children);
        children.length = 2.0;
        this.view.expand();
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).add(new String[]{"fa-chevron-down"});
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).remove(new String[]{"fa-chevron-right"});
        ((DOMTokenList)Mockito.verify((Object)child1.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)child2.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testCollapse() {
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        DOMTokenList arrowClassList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        arrow.classList = arrowClassList;
        DataType parentDataType = (DataType)Mockito.mock(DataType.class);
        String parentDataTypeUUID = "parentDataTypeUUID";
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element child1 = this.makeChildElement("child1UUID");
        Element child2 = this.makeChildElement("child2UUID");
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Mockito.when((Object)parentDataType.getUUID()).thenReturn((Object)"parentDataTypeUUID");
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentDataTypeUUID");
        ((DataTypeListItemView)Mockito.doReturn((Object)parentDataType).when((Object)this.view)).getDataType();
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        this.mockDOMElementByUUID("parentDataTypeUUID", parentElement);
        this.mockDOMElementsByParentUUID("parentDataTypeUUID", (NodeList<Element>)children);
        children.length = 2.0;
        this.view.collapse();
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).remove(new String[]{"fa-chevron-down"});
        ((DOMTokenList)Mockito.verify((Object)arrowClassList)).add(new String[]{"fa-chevron-right"});
        ((DOMTokenList)Mockito.verify((Object)child1.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)child2.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testIsCollapsedWhenItIsRightArrow() {
        DOMTokenList classList;
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        arrow.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains((String)Matchers.eq((Object)"fa-chevron-right"))).thenReturn((Object)true);
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        Assert.assertTrue((boolean)this.view.isCollapsed());
    }

    @Test
    public void testIsCollapsedArrowWhenItIsNotRightArrow() {
        DOMTokenList classList;
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        arrow.classList = classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)classList.contains("fa-chevron-right")).thenReturn((Object)false);
        ((DataTypeListItemView)Mockito.doReturn((Object)arrow).when((Object)this.view)).getArrow();
        Assert.assertFalse((boolean)this.view.isCollapsed());
    }

    @Test
    public void testIsCollapsedWhenArrowIsARightArrow() {
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        arrow.classList = classList;
        Mockito.when((Object)classList.contains("fa-chevron-right")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.view.isCollapsed((Element)arrow));
    }

    @Test
    public void testIsCollapsedWhenArrowIsNotARightArrow() {
        DOMTokenList classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement arrow = (HTMLElement)Mockito.mock(HTMLElement.class);
        arrow.classList = classList;
        Mockito.when((Object)classList.contains("fa-chevron-right")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.view.isCollapsed((Element)arrow));
    }

    @Test
    public void testEnableFocusMode() {
        DataType parentDataType = (DataType)Mockito.mock(DataType.class);
        String parentDataTypeUUID = "parentDataTypeUUID";
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element child1 = this.makeChildElement("child1UUID");
        Element child2 = this.makeChildElement("child2UUID");
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Mockito.when((Object)parentDataType.getUUID()).thenReturn((Object)"parentDataTypeUUID");
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentDataTypeUUID");
        ((DataTypeListItemView)Mockito.doReturn((Object)parentDataType).when((Object)this.view)).getDataType();
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        this.mockDOMElementByUUID("parentDataTypeUUID", parentElement);
        this.mockDOMElementsByParentUUID("parentDataTypeUUID", (NodeList<Element>)children);
        children.length = 2.0;
        parentElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.enableFocusMode();
        ((DOMTokenList)Mockito.verify((Object)parentElement.classList)).add(new String[]{"focused-data-type"});
        ((DOMTokenList)Mockito.verify((Object)child1.classList)).add(new String[]{"focused-data-type"});
        ((DOMTokenList)Mockito.verify((Object)child2.classList)).add(new String[]{"focused-data-type"});
        ((HTMLInputElement)Mockito.verify((Object)this.nameInput)).select();
    }

    @Test
    public void testDisableFocusMode() {
        DataType parentDataType = (DataType)Mockito.mock(DataType.class);
        String parentDataTypeUUID = "parentDataTypeUUID";
        Element parentElement = (Element)Mockito.mock(Element.class);
        Element child1 = this.makeChildElement("child1UUID");
        Element child2 = this.makeChildElement("child2UUID");
        NodeList children = (NodeList)Mockito.spy((Object)new NodeList());
        Mockito.when((Object)parentDataType.getUUID()).thenReturn((Object)"parentDataTypeUUID");
        Mockito.when((Object)parentElement.getAttribute("data-row-uuid")).thenReturn((Object)"parentDataTypeUUID");
        ((DataTypeListItemView)Mockito.doReturn((Object)parentDataType).when((Object)this.view)).getDataType();
        ((NodeList)Mockito.doReturn((Object)child1).when((Object)children)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)child2).when((Object)children)).getAt(1);
        this.mockDOMElementByUUID("parentDataTypeUUID", parentElement);
        this.mockDOMElementsByParentUUID("parentDataTypeUUID", (NodeList<Element>)children);
        children.length = 2.0;
        parentElement.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.view.disableFocusMode();
        ((DOMTokenList)Mockito.verify((Object)parentElement.classList)).remove(new String[]{"focused-data-type"});
        ((DOMTokenList)Mockito.verify((Object)child1.classList)).remove(new String[]{"focused-data-type"});
        ((DOMTokenList)Mockito.verify((Object)child2.classList)).remove(new String[]{"focused-data-type"});
    }

    @Test
    public void testGetName() {
        String expectedName = "name";
        this.nameInput.value = "name";
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        String actualName = this.view.getName();
        Assert.assertEquals((Object)"name", (Object)actualName);
    }

    @Test
    public void testIsOnFocusModeWhenItReturnsTrue() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Element dataTypeRow = (Element)Mockito.mock(Element.class);
        dataTypeRow.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)dataType).when((Object)this.view)).getDataType();
        ((DataTypeListItemView)Mockito.doReturn((Object)dataTypeRow).when((Object)this.view)).getRowElement(dataType);
        Mockito.when((Object)dataTypeRow.classList.contains("focused-data-type")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.view.isOnFocusMode());
    }

    @Test
    public void testIsOnFocusModeWhenItReturnsFalse() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Element dataTypeRow = (Element)Mockito.mock(Element.class);
        dataTypeRow.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)dataType).when((Object)this.view)).getDataType();
        ((DataTypeListItemView)Mockito.doReturn((Object)dataTypeRow).when((Object)this.view)).getRowElement(dataType);
        Mockito.when((Object)dataTypeRow.classList.contains("focused-data-type")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.view.isOnFocusMode());
    }

    @Test
    public void testShowDataTypeNameInput() {
        this.nameText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.nameInput.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameText).when((Object)this.view)).getNameText();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).showLabels();
        this.view.showDataTypeNameInput();
        ((DOMTokenList)Mockito.verify((Object)this.nameText.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.nameInput.classList)).remove(new String[]{"hidden"});
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).showLabels();
    }

    @Test
    public void testHideDataTypeNameInput() {
        String expectedName = "name";
        this.nameInput.value = "name";
        this.nameText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.nameInput.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameText).when((Object)this.view)).getNameText();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).hideLabels();
        this.view.hideDataTypeNameInput();
        Assert.assertEquals((Object)"name", (Object)this.nameText.textContent);
        ((DOMTokenList)Mockito.verify((Object)this.nameText.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.nameInput.classList)).add(new String[]{"hidden"});
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).hideLabels();
    }

    @Test
    public void testHideDataTypeNameInputWhenNameIsBlank() {
        String expectedName = "-";
        this.nameInput.value = "";
        this.nameText.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.nameInput.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameText).when((Object)this.view)).getNameText();
        ((DataTypeListItemView)Mockito.doReturn((Object)this.nameInput).when((Object)this.view)).getNameInput();
        ((DataTypeListItemView)Mockito.doNothing().when((Object)this.view)).hideLabels();
        this.view.hideDataTypeNameInput();
        Assert.assertEquals((Object)"-", (Object)this.nameText.textContent);
        ((DOMTokenList)Mockito.verify((Object)this.nameText.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.nameInput.classList)).add(new String[]{"hidden"});
        ((DataTypeListItemView)Mockito.verify((Object)this.view)).hideLabels();
    }

    @Test
    public void testShowLabels() {
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        NodeList labels = (NodeList)Mockito.spy((Object)new NodeList());
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        labels.length = 2.0;
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)labels)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)labels)).getAt(1);
        ((DataTypeListItemView)Mockito.doReturn((Object)labels).when((Object)this.view)).getLabels();
        this.view.showLabels();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testHideLabels() {
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        NodeList labels = (NodeList)Mockito.spy((Object)new NodeList());
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        labels.length = 2.0;
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)labels)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)labels)).getAt(1);
        ((DataTypeListItemView)Mockito.doReturn((Object)labels).when((Object)this.view)).getLabels();
        this.view.hideLabels();
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).add(new String[]{"hidden"});
    }

    @Test
    public void testGetConstraintContainer() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("constraint-container");
        Assert.assertEquals((Object)element, (Object)this.view.getConstraintContainer());
    }

    @Test
    public void testGetCollectionContainer() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("list-container");
        Assert.assertEquals((Object)element, (Object)this.view.getListContainer());
    }

    @Test
    public void testGetCollectionYes() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("list-yes");
        Assert.assertEquals((Object)element, (Object)this.view.getListYes());
    }

    @Test
    public void testGetEditButton() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("edit-button");
        Assert.assertEquals((Object)element, (Object)this.view.getEditButton());
    }

    @Test
    public void testGetSaveButton() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("save-button");
        Assert.assertEquals((Object)element, (Object)this.view.getSaveButton());
    }

    @Test
    public void testGetCloseButton() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("close-button");
        Assert.assertEquals((Object)element, (Object)this.view.getCloseButton());
    }

    @Test
    public void testGetRemoveButton() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("remove-button");
        Assert.assertEquals((Object)element, (Object)this.view.getRemoveButton());
    }

    @Test
    public void testGetInsertNestedField() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("insert-nested-field");
        Assert.assertEquals((Object)element, (Object)this.view.getInsertNestedFieldButton());
    }

    @Test
    public void testGetLabels() {
        Element element1 = (Element)Mockito.mock(Element.class);
        Element element2 = (Element)Mockito.mock(Element.class);
        HTMLElement viewElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList labels = (NodeList)Mockito.spy((Object)new NodeList());
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        labels.length = 2.0;
        ((NodeList)Mockito.doReturn((Object)element1).when((Object)labels)).getAt(0);
        ((NodeList)Mockito.doReturn((Object)element2).when((Object)labels)).getAt(0);
        ((DataTypeListItemView)Mockito.doReturn((Object)viewElement).when((Object)this.view)).getElement();
        Mockito.when((Object)viewElement.querySelectorAll(".data-type-label")).thenReturn((Object)labels);
        Assert.assertEquals((Object)labels, (Object)this.view.getLabels());
    }

    @Test
    public void testGetArrow() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("arrow-button");
        Assert.assertEquals((Object)element, (Object)this.view.getArrow());
    }

    @Test
    public void testGetNameText() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("name-text");
        Assert.assertEquals((Object)element, (Object)this.view.getNameText());
    }

    @Test
    public void testGetNameInput() {
        HTMLInputElement element = (HTMLInputElement)Mockito.mock(HTMLInputElement.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("name-input");
        Assert.assertEquals((Object)element, (Object)this.view.getNameInput());
    }

    @Test
    public void testGetType() {
        Element element = (Element)Mockito.mock(Element.class);
        ((DataTypeListItemView)Mockito.doReturn((Object)element).when((Object)this.view)).querySelector("type");
        Assert.assertEquals((Object)element, (Object)this.view.getType());
    }

    public Element makeChildElement(String uuid) {
        Element element = (Element)Mockito.mock(Element.class);
        element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.mockDOMElementsByParentUUID(uuid, (NodeList<Element>)new NodeList());
        Mockito.when((Object)element.getAttribute("data-row-uuid")).thenReturn((Object)uuid);
        return element;
    }

    private void mockDOMElementByUUID(String uuid, Element element) {
        Mockito.when((Object)this.dataTypeListElement.querySelector("[data-row-uuid=\"" + uuid + "\"]")).thenReturn((Object)element);
    }

    private void mockDOMElementsByParentUUID(String parentUUID, NodeList<Element> elements) {
        Mockito.when((Object)this.dataTypeListElement.querySelectorAll("[data-parent-row-uuid=\"" + parentUUID + "\"]")).thenReturn(elements);
    }
}

