/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.confirmation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeConfirmation;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeHasFieldsWarningMessage;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.ReferencedDataTypeWarningMessage;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeConfirmationTest {
    private static final String STRUCTURE = "Structure";
    @Mock
    private DataTypeStore dataTypeStore;
    @Mock
    private ItemDefinitionStore itemDefinitionStore;
    @Mock
    private EventSourceMock<FlashMessage> flashMessageEvent;
    @Mock
    private DataTypeHasFieldsWarningMessage dataTypeHasFieldsWarningMessage;
    @Mock
    private ReferencedDataTypeWarningMessage referencedDataTypeWarningMessage;
    @Mock
    private TranslationService translationService;
    private DataTypeConfirmation confirmation;

    @Before
    public void setup() {
        this.confirmation = new DataTypeConfirmation(this.dataTypeStore, this.itemDefinitionStore, this.flashMessageEvent, this.dataTypeHasFieldsWarningMessage, this.referencedDataTypeWarningMessage, this.translationService);
        Mockito.when((Object)this.translationService.format("DataTypeManager.Structure", new Object[0])).thenReturn((Object)STRUCTURE);
    }

    @Test
    public void testIfDataTypeDoesNotHaveLostSubDataTypesWhenSuccessCallbackIsExecuted() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        Command onError = (Command)Mockito.mock(Command.class);
        String uuid = "uuid";
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)STRUCTURE);
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        this.confirmation.ifDataTypeDoesNotHaveLostSubDataTypes(dataType, onSuccess, onError);
        ((Command)Mockito.verify((Object)onSuccess)).execute();
    }

    @Test
    public void testIfDataTypeDoesNotHaveLostSubDataTypesWhenItemDefinitionItemComponentIsEmpty() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<Object> itemComponent = Collections.singletonList(Mockito.mock(ItemDefinition.class));
        Command onSuccess = (Command)Mockito.mock(Command.class);
        Command onError = (Command)Mockito.mock(Command.class);
        String uuid = "uuid";
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)STRUCTURE);
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)itemDefinition.getItemComponent()).thenReturn(itemComponent);
        this.confirmation.ifDataTypeDoesNotHaveLostSubDataTypes(dataType, onSuccess, onError);
        ((Command)Mockito.verify((Object)onSuccess)).execute();
    }

    @Test
    public void testIfDataTypeDoesNotHaveLostSubDataTypesWhenItemDefinitionItemComponentIsNotEmpty() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        ItemDefinition itemDefinition = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        List<Object> itemComponent = Collections.singletonList(Mockito.mock(ItemDefinition.class));
        Command onSuccess = (Command)Mockito.mock(Command.class);
        Command onError = (Command)Mockito.mock(Command.class);
        FlashMessage warningMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        String uuid = "uuid";
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"uuid");
        Mockito.when((Object)dataType.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)this.itemDefinitionStore.get("uuid")).thenReturn((Object)itemDefinition);
        Mockito.when((Object)itemDefinition.getItemComponent()).thenReturn(itemComponent);
        Mockito.when((Object)this.dataTypeHasFieldsWarningMessage.getFlashMessage(dataType, onSuccess, onError)).thenReturn((Object)warningMessage);
        this.confirmation.ifDataTypeDoesNotHaveLostSubDataTypes(dataType, onSuccess, onError);
        ((Command)Mockito.verify((Object)onSuccess, (VerificationMode)Mockito.never())).execute();
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)warningMessage);
    }

    @Test
    public void testIfIsNotReferencedDataTypeWhenCallbackIsExecuted() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> allDataTypes = Arrays.asList(dataType1, dataType2);
        Command callback = (Command)Mockito.mock(Command.class);
        String tCity = "tCity";
        String tPerson = "tPerson";
        String tDocument = "tDocument";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"tDocument");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.dataTypeStore.all()).thenReturn(allDataTypes);
        this.confirmation.ifIsNotReferencedDataType(dataType, callback);
        ((Command)Mockito.verify((Object)callback)).execute();
    }

    @Test
    public void testIfIsNotReferencedDataTypeWhenCallbackIsNotExecuted() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        List<DataType> allDataTypes = Arrays.asList(dataType1, dataType2);
        FlashMessage warningMessage = (FlashMessage)Mockito.mock(FlashMessage.class);
        Command onSuccess = (Command)Mockito.mock(Command.class);
        String tCity = "tCity";
        String tPerson = "tPerson";
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType1.getType()).thenReturn((Object)"tCity");
        Mockito.when((Object)dataType2.getType()).thenReturn((Object)"tPerson");
        Mockito.when((Object)this.referencedDataTypeWarningMessage.getFlashMessage((DataType)Matchers.eq((Object)dataType), (Command)Matchers.eq((Object)onSuccess), (Command)Matchers.any())).thenReturn((Object)warningMessage);
        Mockito.when((Object)this.dataTypeStore.all()).thenReturn(allDataTypes);
        this.confirmation.ifIsNotReferencedDataType(dataType, onSuccess);
        ((Command)Mockito.verify((Object)onSuccess, (VerificationMode)Mockito.never())).execute();
        ((EventSourceMock)Mockito.verify(this.flashMessageEvent)).fire((Object)warningMessage);
    }
}

