/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.confirmation;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.ReferencedDataTypeWarningMessage;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ReferencedDataTypeWarningMessageTest {
    @Mock
    private TranslationService translationService;

    @Test
    public void testGetStrongMessage() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        String dataTypeName = "name";
        String expectedWarningMessage = "*Expected strong message.*";
        ReferencedDataTypeWarningMessage warningMessage = new ReferencedDataTypeWarningMessage(this.translationService);
        Mockito.when((Object)dataType.getName()).thenReturn((Object)"name");
        Mockito.when((Object)this.translationService.format("ReferencedDataTypeWarningMessage.StrongMessage", new Object[]{"name"})).thenReturn((Object)"*Expected strong message.*");
        String actualWarningMessage = warningMessage.getStrongMessage(dataType);
        Assert.assertEquals((Object)"*Expected strong message.*", (Object)actualWarningMessage);
    }

    @Test
    public void testGetRegularMessage() {
        String expectedWarningMessage = "Expected regular message.";
        ReferencedDataTypeWarningMessage warningMessage = new ReferencedDataTypeWarningMessage(this.translationService);
        Mockito.when((Object)this.translationService.format("ReferencedDataTypeWarningMessage.RegularMessage", new Object[0])).thenReturn((Object)"Expected regular message.");
        String actualWarningMessage = warningMessage.getRegularMessage();
        Assert.assertEquals((Object)"Expected regular message.", (Object)actualWarningMessage);
    }

    @Test
    public void testGetErrorElementSelector() {
        DataType dataType = (DataType)Mockito.mock(DataType.class);
        Mockito.when((Object)dataType.getUUID()).thenReturn((Object)"1111-1111-1111-1111");
        String expectedSelector = "[data-row-uuid=\"1111-1111-1111-1111\"] select";
        String actualSelector = new ReferencedDataTypeWarningMessage(this.translationService).getErrorElementSelector(dataType);
        Assert.assertEquals((Object)"[data-row-uuid=\"1111-1111-1111-1111\"] select", (Object)actualSelector);
    }
}

