/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.CSSStyleDeclaration;
import elemental2.dom.DOMTokenList;
import elemental2.dom.Element;
import elemental2.dom.HTMLDocument;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import elemental2.dom.NodeList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListDOMHelper;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DNDListDOMHelperTest {
    @Mock
    private HTMLElement element;

    @Test
    public void testGetX() {
        Mockito.when((Object)this.element.getAttribute("data-x-position")).thenReturn((Object)"42.5px");
        Integer actual = DNDListDOMHelper.Position.getX((Element)this.element);
        Integer expected = 42;
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetX() {
        DNDListDOMHelper.Position.setX((Element)this.element, (double)42.0);
        ((HTMLElement)Mockito.verify((Object)this.element)).setAttribute("data-x-position", 42.0);
    }

    @Test
    public void testGetY() {
        Mockito.when((Object)this.element.getAttribute("data-y-position")).thenReturn((Object)"42.5px");
        Integer actual = DNDListDOMHelper.Position.getY((Element)this.element);
        Integer expected = 42;
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetDoubleY() {
        Mockito.when((Object)this.element.getAttribute("data-y-position")).thenReturn((Object)"42.5px");
        Double actual = DNDListDOMHelper.Position.getDoubleY((Element)this.element);
        Double expected = 42.5;
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSetY() {
        DNDListDOMHelper.Position.setY((Element)this.element, (double)42.0);
        ((HTMLElement)Mockito.verify((Object)this.element)).setAttribute("data-y-position", 42.0);
    }

    @Test
    public void testGetDraggableElement() {
        String selector = ".kie-dnd-draggable[data-y-position=\"42\"]";
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.element.querySelector(".kie-dnd-draggable[data-y-position=\"42\"]")).thenReturn((Object)expectedElement);
        HTMLElement actualElement = (HTMLElement)DNDListDOMHelper.querySelector((Element)this.element).getDraggableElement(42).orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testGetHoverElement() {
        String selector = ".kie-dnd-hover";
        HTMLElement expectedElement = (HTMLElement)Mockito.mock(HTMLElement.class);
        Mockito.when((Object)this.element.querySelector(".kie-dnd-hover")).thenReturn((Object)expectedElement);
        HTMLElement actualElement = (HTMLElement)DNDListDOMHelper.querySelector((Element)this.element).getHoverElement().orElseThrow(RuntimeException::new);
        Assert.assertEquals((Object)expectedElement, (Object)actualElement);
    }

    @Test
    public void testGetDraggableElements() {
        String selector = ".kie-dnd-draggable";
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList nodeList = (NodeList)Mockito.spy((Object)new NodeList());
        nodeList.length = 3.0;
        Mockito.when((Object)nodeList.getAt(0)).thenReturn((Object)element0);
        Mockito.when((Object)nodeList.getAt(1)).thenReturn((Object)element1);
        Mockito.when((Object)nodeList.getAt(2)).thenReturn((Object)element2);
        Mockito.when((Object)this.element.querySelectorAll(".kie-dnd-draggable")).thenReturn((Object)nodeList);
        List actualElements = DNDListDOMHelper.querySelector((Element)this.element).getDraggableElements();
        List<HTMLElement> expectElements = Arrays.asList(element0, element1, element2);
        Assert.assertEquals(expectElements, (Object)actualElements);
    }

    @Test
    public void testGetSortedDraggableElements() {
        String selector = ".kie-dnd-draggable";
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList nodeList = (NodeList)Mockito.spy((Object)new NodeList());
        nodeList.length = 3.0;
        Mockito.when((Object)nodeList.getAt(0)).thenReturn((Object)element0);
        Mockito.when((Object)nodeList.getAt(1)).thenReturn((Object)element1);
        Mockito.when((Object)nodeList.getAt(2)).thenReturn((Object)element2);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"-1");
        Mockito.when((Object)this.element.querySelectorAll(".kie-dnd-draggable")).thenReturn((Object)nodeList);
        List actualElements = DNDListDOMHelper.querySelector((Element)this.element).getSortedDraggableElements();
        List<HTMLElement> expectElements = Arrays.asList(element2, element1, element0);
        Assert.assertEquals(expectElements, (Object)actualElements);
    }

    @Test
    public void testGetVisibleDraggableElements() {
        String selector = ".kie-dnd-draggable";
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList nodeList = (NodeList)Mockito.spy((Object)new NodeList());
        nodeList.length = 3.0;
        Mockito.when((Object)nodeList.getAt(0)).thenReturn((Object)element0);
        Mockito.when((Object)nodeList.getAt(1)).thenReturn((Object)element1);
        Mockito.when((Object)nodeList.getAt(2)).thenReturn((Object)element2);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"-1");
        Mockito.when((Object)this.element.querySelectorAll(".kie-dnd-draggable")).thenReturn((Object)nodeList);
        List actualElements = DNDListDOMHelper.querySelector((Element)this.element).getVisibleDraggableElements();
        List<HTMLElement> expectElements = Arrays.asList(element0, element1);
        Assert.assertEquals(expectElements, (Object)actualElements);
    }

    @Test
    public void testGetVisibleAndSortedDraggableElements() {
        String selector = ".kie-dnd-draggable";
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        NodeList nodeList = (NodeList)Mockito.spy((Object)new NodeList());
        nodeList.length = 3.0;
        Mockito.when((Object)nodeList.getAt(0)).thenReturn((Object)element0);
        Mockito.when((Object)nodeList.getAt(1)).thenReturn((Object)element1);
        Mockito.when((Object)nodeList.getAt(2)).thenReturn((Object)element2);
        Mockito.when((Object)element0.getAttribute("data-y-position")).thenReturn((Object)"1");
        Mockito.when((Object)element1.getAttribute("data-y-position")).thenReturn((Object)"0");
        Mockito.when((Object)element2.getAttribute("data-y-position")).thenReturn((Object)"-1");
        Mockito.when((Object)this.element.querySelectorAll(".kie-dnd-draggable")).thenReturn((Object)nodeList);
        List actualElements = DNDListDOMHelper.querySelector((Element)this.element).getVisibleAndSortedDraggableElements();
        List<HTMLElement> expectElements = Arrays.asList(element1, element0);
        Assert.assertEquals(expectElements, (Object)actualElements);
    }

    @Test
    public void testSetCSSTop() {
        this.element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        DNDListDOMHelper.setCSSTop((HTMLElement)this.element, (int)123);
        ((CSSStyleDeclaration)Mockito.verify((Object)this.element.style)).setProperty("top", "123px");
    }

    @Test
    public void testSetCSSWidth() {
        this.element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        DNDListDOMHelper.setCSSWidth((HTMLElement)this.element, (int)321);
        ((CSSStyleDeclaration)Mockito.verify((Object)this.element.style)).setProperty("width", "calc(100% - 321px)");
    }

    @Test
    public void testSetCSSPaddingLeft() {
        this.element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        DNDListDOMHelper.setCSSPaddingLeft((HTMLElement)this.element, (int)321);
        ((CSSStyleDeclaration)Mockito.verify((Object)this.element.style)).setProperty("padding-left", "321px");
    }

    @Test
    public void testGetCSSTop() {
        this.element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)this.element.style.getPropertyValue("top")).thenReturn((Object)"123px");
        int actualTop = DNDListDOMHelper.getCSSTop((HTMLElement)this.element);
        int expectedTop = 123;
        Assert.assertEquals((long)123L, (long)actualTop);
    }

    @Test
    public void testGetCSSWidth() {
        this.element.style = (CSSStyleDeclaration)Mockito.mock(CSSStyleDeclaration.class);
        Mockito.when((Object)this.element.style.getPropertyValue("width")).thenReturn((Object)"calc(100% - 321px)");
        int actualWidth = DNDListDOMHelper.getCSSWidth((HTMLElement)this.element);
        int expectedWidth = 321;
        Assert.assertEquals((long)321L, (long)actualWidth);
    }

    @Test
    public void testAsHover() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement actual = DNDListDOMHelper.asHover((HTMLElement)this.element);
        HTMLElement expected = this.element;
        ((DOMTokenList)Mockito.verify((Object)this.element.classList)).add(new String[]{"kie-dnd-hover"});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAsNonHover() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement actual = DNDListDOMHelper.asNonHover((HTMLElement)this.element);
        HTMLElement expected = this.element;
        ((DOMTokenList)Mockito.verify((Object)this.element.classList)).remove(new String[]{"kie-dnd-hover"});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAsDragging() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement actual = DNDListDOMHelper.asDragging((HTMLElement)this.element);
        HTMLElement expected = this.element;
        ((DOMTokenList)Mockito.verify((Object)this.element.classList)).add(new String[]{"kie-dnd-current-dragging"});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAsNonDragging() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement actual = DNDListDOMHelper.asNonDragging((HTMLElement)this.element);
        HTMLElement expected = this.element;
        ((DOMTokenList)Mockito.verify((Object)this.element.classList)).remove(new String[]{"kie-dnd-current-dragging"});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAsDraggable() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        HTMLElement actual = DNDListDOMHelper.asDraggable((HTMLElement)this.element);
        HTMLElement expected = this.element;
        ((DOMTokenList)Mockito.verify((Object)this.element.classList)).add(new String[]{"kie-dnd-draggable"});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testIsDraggingElementWhenItsDragging() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.element.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)true);
        Assert.assertTrue((boolean)DNDListDOMHelper.isDraggingElement((HTMLElement)this.element));
    }

    @Test
    public void testIsDraggingElementWhenItsNotDragging() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.element.classList.contains("kie-dnd-current-dragging")).thenReturn((Object)false);
        Assert.assertFalse((boolean)DNDListDOMHelper.isDraggingElement((HTMLElement)this.element));
    }

    @Test
    public void testIsGripWhenItsGrip() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.element.classList.contains("kie-dnd-grip")).thenReturn((Object)true);
        Assert.assertTrue((boolean)DNDListDOMHelper.isGrip((HTMLElement)this.element));
    }

    @Test
    public void testIsGripWhenItsNotGrip() {
        this.element.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.element.classList.contains("kie-dnd-grip")).thenReturn((Object)false);
        Assert.assertFalse((boolean)DNDListDOMHelper.isGrip((HTMLElement)this.element));
    }

    @Test
    public void testCreateDiv() {
        HTMLDocument document = (HTMLDocument)Mockito.mock(HTMLDocument.class);
        HTMLElement expectedDiv = (HTMLElement)Mockito.mock(HTMLElement.class);
        String tagName = "div";
        DNDListDOMHelper.Factory.DOCUMENT = document;
        Mockito.when((Object)document.createElement("div")).thenReturn((Object)expectedDiv);
        HTMLElement actualDiv = DNDListDOMHelper.Factory.createDiv();
        Assert.assertEquals((Object)expectedDiv, (Object)actualDiv);
    }

    @Test
    public void testCreateGripElement() {
        HTMLDocument document = (HTMLDocument)Mockito.mock(HTMLDocument.class);
        HTMLElement expectedGrip = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement firstI = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement secondI = (HTMLElement)Mockito.mock(HTMLElement.class);
        String div = "div";
        String i = "i";
        DNDListDOMHelper.Factory.DOCUMENT = document;
        expectedGrip.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        firstI.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        secondI.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)document.createElement("div")).thenReturn((Object)expectedGrip);
        Mockito.when((Object)document.createElement("i")).thenReturn((Object)firstI, (Object[])new Element[]{secondI});
        HTMLElement actualGrip = DNDListDOMHelper.Factory.createGripElement();
        ((HTMLElement)Mockito.verify((Object)expectedGrip)).appendChild((Node)firstI);
        ((HTMLElement)Mockito.verify((Object)expectedGrip)).appendChild((Node)secondI);
        ((DOMTokenList)Mockito.verify((Object)expectedGrip.classList)).add(new String[]{"kie-dnd-grip"});
        ((DOMTokenList)Mockito.verify((Object)firstI.classList)).add(new String[]{"fa"});
        ((DOMTokenList)Mockito.verify((Object)secondI.classList)).add(new String[]{"fa"});
        ((DOMTokenList)Mockito.verify((Object)firstI.classList)).add(new String[]{"fa-ellipsis-v"});
        ((DOMTokenList)Mockito.verify((Object)secondI.classList)).add(new String[]{"fa-ellipsis-v"});
        Assert.assertEquals((Object)expectedGrip, (Object)actualGrip);
    }

    @Test
    public void testParseDouble() {
        Assert.assertEquals((Object)DNDListDOMHelper.parseDouble((String)"10"), (Object)new Double(10.0));
        Assert.assertEquals((Object)DNDListDOMHelper.parseDouble((String)"10.5"), (Object)new Double(10.5));
        Assert.assertEquals((Object)DNDListDOMHelper.parseDouble((String)"10.5px"), (Object)new Double(10.5));
        Assert.assertEquals((Object)DNDListDOMHelper.parseDouble((String)"something..."), (Object)new Double(0.0));
    }

    @Test
    public void testParseInt() {
        Assert.assertEquals((Object)DNDListDOMHelper.parseInt((String)"10"), (Object)new Integer(10));
        Assert.assertEquals((Object)DNDListDOMHelper.parseInt((String)"10.5"), (Object)new Integer(10));
        Assert.assertEquals((Object)DNDListDOMHelper.parseInt((String)"10.5px"), (Object)new Integer(10));
        Assert.assertEquals((Object)DNDListDOMHelper.parseInt((String)"something..."), (Object)new Integer(0));
    }
}

