/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.DOMTokenList;
import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.kie.workbench.common.dmn.client.editors.types.listview.draganddrop.DNDListComponent;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBar;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchBarView;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataTypeSearchBarViewTest {
    @Mock
    private HTMLInputElement searchBar;
    @Mock
    private HTMLElement searchIcon;
    @Mock
    private HTMLButtonElement closeSearch;
    @Mock
    private DataTypeSearchBar presenter;
    @Mock
    private TranslationService translationService;
    @Captor
    private ArgumentCaptor<DomGlobal.SetTimeoutCallbackFn> callback;
    private DataTypeSearchBarView view;

    @Before
    public void setup() {
        this.view = (DataTypeSearchBarView)Mockito.spy((Object)new DataTypeSearchBarView(this.searchBar, this.searchIcon, this.closeSearch, this.translationService));
        this.view.init(this.presenter);
        this.searchIcon.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        this.closeSearch.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
    }

    @Test
    public void testSetupSearchBar() {
        String search = "Search...";
        Mockito.when((Object)this.translationService.format("DataTypeSearchBarView.Search", new Object[0])).thenReturn((Object)"Search...");
        this.view.setupSearchBar();
        Assert.assertEquals((Object)this.searchBar.placeholder, (Object)"Search...");
    }

    @Test
    public void testOnSearchBarCloseButton() {
        this.view.onSearchBarCloseButton((ClickEvent)Mockito.mock(ClickEvent.class));
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)27);
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).reset();
    }

    @Test
    public void testOnSearchBarKeyUpEventWhenKeyPressedIsNotEscape() {
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        Mockito.when((Object)event.getNativeKeyCode()).thenReturn((Object)17);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).search();
        this.view.onSearchBarKeyUpEvent(event);
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).search();
    }

    @Test
    public void testOnSearchBarKeyDownEvent() {
        this.view.onSearchBarKeyDownEvent((KeyDownEvent)Mockito.mock(KeyDownEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testOnSearchBarChangeEvent() {
        this.view.onSearchBarChangeEvent((ChangeEvent)Mockito.mock(ChangeEvent.class));
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
    }

    @Test
    public void testShowSearchResults() {
        DNDListComponent dndListComponent = (DNDListComponent)Mockito.mock(DNDListComponent.class);
        DataType dataType0 = (DataType)Mockito.mock(DataType.class);
        DataType dataType1 = (DataType)Mockito.mock(DataType.class);
        DataType dataType2 = (DataType)Mockito.mock(DataType.class);
        DataTypeListItem listItem0 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem1 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem2 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        DataTypeListItem listItem3 = (DataTypeListItem)Mockito.mock(DataTypeListItem.class);
        HTMLElement element0 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element1 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element2 = (HTMLElement)Mockito.mock(HTMLElement.class);
        HTMLElement element3 = (HTMLElement)Mockito.mock(HTMLElement.class);
        List<DataType> results = Arrays.asList(dataType0, dataType1, dataType2);
        List<DataTypeListItem> listItems = Arrays.asList(listItem0, listItem1, listItem2, listItem3);
        element0.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element1.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element2.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        element3.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)listItem0.getDataType()).thenReturn((Object)dataType0);
        Mockito.when((Object)listItem1.getDataType()).thenReturn((Object)dataType1);
        Mockito.when((Object)listItem2.getDataType()).thenReturn((Object)dataType2);
        Mockito.when((Object)listItem0.getDragAndDropElement()).thenReturn((Object)element0);
        Mockito.when((Object)listItem1.getDragAndDropElement()).thenReturn((Object)element1);
        Mockito.when((Object)listItem2.getDragAndDropElement()).thenReturn((Object)element2);
        Mockito.when((Object)listItem3.getDragAndDropElement()).thenReturn((Object)element3);
        Mockito.when((Object)this.presenter.getDataTypeListItemsSortedByPositionY()).thenReturn(listItems);
        Mockito.when((Object)this.presenter.getDNDListComponent()).thenReturn((Object)dndListComponent);
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).enableSearch();
        this.view.showSearchResults(results);
        ((DOMTokenList)Mockito.verify((Object)element0.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element1.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element2.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)element3.classList)).add(new String[]{"hidden"});
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element0, 0.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element1, 1.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element2, 2.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).setPositionY((Element)element3, -1.0);
        ((DNDListComponent)Mockito.verify((Object)dndListComponent)).refreshItemsPosition();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).enableSearch();
    }

    @Test
    public void testResetSearchBar() {
        this.searchBar.value = "something";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).disableSearch();
        this.view.resetSearchBar();
        Assert.assertEquals((Object)this.searchBar.value, (Object)"");
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).refreshSearchBarState();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).disableSearch();
    }

    @Test
    public void testEnableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.enableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).add(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testDisableSearch() {
        HTMLElement resultsContainer = (HTMLElement)Mockito.mock(HTMLElement.class);
        resultsContainer.classList = (DOMTokenList)Mockito.mock(DOMTokenList.class);
        Mockito.when((Object)this.presenter.getResultsContainer()).thenReturn((Object)resultsContainer);
        this.view.disableSearch();
        ((DOMTokenList)Mockito.verify((Object)resultsContainer.classList)).remove(new String[]{"kie-search-engine-enabled"});
    }

    @Test
    public void testSearch() {
        String keyword = "keyword";
        ((DataTypeSearchBarView)Mockito.doNothing().when((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)Matchers.any(), (double)Matchers.anyInt());
        this.searchBar.value = "keyword";
        this.view.search();
        ((DataTypeSearchBarView)Mockito.verify((Object)this.view)).setTimeout((DomGlobal.SetTimeoutCallbackFn)this.callback.capture(), Matchers.eq((double)500.0));
        ((DomGlobal.SetTimeoutCallbackFn)this.callback.getValue()).onInvoke(new Object[0]);
        ((DataTypeSearchBar)Mockito.verify((Object)this.presenter)).search("keyword");
    }

    @Test
    public void testRefreshSearchBarStateWhenItsActive() {
        this.searchBar.value = "keyword";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).add(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).remove(new String[]{"hidden"});
    }

    @Test
    public void testRefreshSearchBarStateWhenItsNotActive() {
        this.searchBar.value = "";
        this.view.refreshSearchBarState();
        ((DOMTokenList)Mockito.verify((Object)this.searchIcon.classList)).remove(new String[]{"hidden"});
        ((DOMTokenList)Mockito.verify((Object)this.closeSearch.classList)).add(new String[]{"hidden"});
    }
}

