/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldDefinition;
import org.kie.workbench.common.dmn.client.property.dmn.QNameFieldRenderer;
import org.kie.workbench.common.forms.dynamic.client.rendering.formGroups.impl.def.DefaultFormGroup;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;
import org.kie.workbench.common.forms.dynamic.service.shared.RenderMode;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class QNameFieldRendererTest {
    @Mock
    private DataTypePickerWidget typePicker;
    @Mock
    private FormRenderingContext context;
    @Mock
    private FormRenderingContext parentContext;
    @Mock
    private QNameFieldDefinition definition;
    @Mock
    private DMNModelInstrumentedBase dmnModel;
    @Mock
    private ManagedInstance<DefaultFormGroup> formGroupInstance;
    @Mock
    private DefaultFormGroup formGroup;
    private QNameFieldRenderer renderer;

    @Before
    public void setup() {
        this.renderer = (QNameFieldRenderer)Mockito.spy((Object)new QNameFieldRenderer(this.typePicker));
        this.renderer.setFormGroup(this.formGroupInstance);
        Mockito.when((Object)this.context.getModel()).thenReturn(null);
        Mockito.when((Object)this.context.getParentContext()).thenReturn((Object)this.parentContext);
        Mockito.when((Object)this.parentContext.getModel()).thenReturn((Object)this.dmnModel);
        Mockito.when((Object)this.formGroupInstance.get()).thenReturn((Object)this.formGroup);
    }

    @Test
    public void testInit() {
        this.renderer.init(this.context, this.definition);
        ((DataTypePickerWidget)Mockito.verify((Object)this.typePicker)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.dmnModel));
        ((QNameFieldRenderer)Mockito.verify((Object)this.renderer)).superInit((FormRenderingContext)Matchers.eq((Object)this.context), (QNameFieldDefinition)Matchers.eq((Object)this.definition));
    }

    @Test
    public void testInitNoParent() {
        Mockito.when((Object)this.context.getModel()).thenReturn((Object)this.dmnModel);
        this.renderer.init(this.context, this.definition);
        ((DataTypePickerWidget)Mockito.verify((Object)this.typePicker)).setDMNModel((DMNModelInstrumentedBase)Matchers.eq((Object)this.dmnModel));
        ((QNameFieldRenderer)Mockito.verify((Object)this.renderer)).superInit((FormRenderingContext)Matchers.eq((Object)this.context), (QNameFieldDefinition)Matchers.eq((Object)this.definition));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)QNameFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.renderer.getName());
    }

    @Test
    public void testGetFormGroupWhenEditMode() {
        this.renderer.init(this.context, this.definition);
        this.assertFormGroup(RenderMode.EDIT_MODE, true);
    }

    @Test
    public void testGetFormGroupWhenReadOnlyMode() {
        this.renderer.init(this.context, this.definition);
        this.assertFormGroup(RenderMode.READ_ONLY_MODE, false);
    }

    @Test
    public void testGetFormGroupWhenPrettyMode() {
        this.renderer.init(this.context, this.definition);
        this.assertFormGroup(RenderMode.PRETTY_MODE, false);
    }

    private void assertFormGroup(RenderMode mode, boolean enabled) {
        this.renderer.getFormGroup(mode);
        ((DataTypePickerWidget)Mockito.verify((Object)this.typePicker)).setEnabled(enabled);
        ((DefaultFormGroup)Mockito.verify((Object)this.formGroup)).render((Widget)Matchers.eq((Object)this.typePicker), (FieldDefinition)Matchers.eq((Object)this.definition));
    }

    @Test
    public void testGetSupportedCode() {
        Assert.assertEquals((Object)QNameFieldDefinition.FIELD_TYPE.getTypeName(), (Object)this.renderer.getSupportedCode());
    }

    @Test
    public void testSetReadOnly() {
        this.renderer.setReadOnly(false);
        ((DataTypePickerWidget)Mockito.verify((Object)this.typePicker)).setEnabled(true);
        this.renderer.setReadOnly(true);
        ((DataTypePickerWidget)Mockito.verify((Object)this.typePicker)).setEnabled(false);
    }
}

