/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Text;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.NameAndDataTypeHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

public abstract class BaseNameAndDataTypeHeaderMetaDataTest {
    protected static final String NAME_DATA_TYPE_COLUMN_GROUP = "NameAndDataTypeHeaderMetaDataTest$NameAndDataTypeColumn";
    protected static final Optional<String> EDITOR_TITLE = Optional.of("editor");
    protected static final Name NAME = new Name("name");
    protected static final double BLOCK_WIDTH = 10.0;
    protected static final double BLOCK_HEIGHT = 20.0;
    protected static final double SPACING = 8.0;
    protected static final String FONT_STYLE_TYPE_REF = "italic";
    protected final String PLACEHOLDER = "placeholder";
    @Mock
    protected HasTypeRef hasTypeRef;
    @Mock
    protected Consumer<HasName> clearDisplayNameConsumer;
    @Mock
    protected BiConsumer<HasName, Name> setDisplayNameConsumer;
    @Mock
    protected BiConsumer<HasTypeRef, QName> setTypeRefConsumer;
    @Mock
    protected CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    protected NameAndDataTypePopoverView.Presenter headerEditor;
    @Mock
    protected EditableHeaderMetaData headerMetaData;
    @Mock
    protected GridHeaderColumnRenderContext context;
    @Mock
    protected NameAndDataTypeHeaderMetaData metaData;
    protected Decision hasExpression = new Decision();

    protected abstract void setup(Optional<HasName> var1);

    @Test
    public void testGetPresenter() {
        this.setup(Optional.empty());
        Assertions.assertThat((Object)this.metaData.getPresenter()).isEqualTo((Object)this.metaData);
    }

    @Test
    public void testGetTitleWithHasName() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Assertions.assertThat((String)this.metaData.getTitle()).isEqualTo((Object)NAME.getValue());
    }

    @Test
    public void testGetDisplayNameWithHasName() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Assertions.assertThat((Object)this.metaData.getName()).isEqualTo((Object)NAME);
    }

    @Test
    public void testGetTitleWithoutHasName() {
        this.setup(Optional.empty());
        Assertions.assertThat((String)this.metaData.getTitle()).isEqualTo((Object)HasName.NOP.getName().getValue());
    }

    @Test
    public void testGetDisplayNameWithoutHasName() {
        this.setup(Optional.empty());
        Assertions.assertThat((Object)this.metaData.getName()).isEqualTo((Object)HasName.NOP.getName());
    }

    @Test
    public void testGetTypeRef() {
        this.setup(Optional.empty());
        this.metaData.getTypeRef();
        ((HasTypeRef)Mockito.verify((Object)this.hasTypeRef)).getTypeRef();
    }

    @Test
    public void testSetDisplayNameWithHasName() {
        Decision decision = new Decision();
        this.setup(Optional.of(decision));
        this.metaData.setName(NAME);
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer)).accept(Matchers.eq((Object)decision), Matchers.eq((Object)NAME));
    }

    @Test
    public void testSetDisplayNameWithHasNameWithEmptyValue() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        this.metaData.setName(new Name());
        ((Consumer)Mockito.verify(this.clearDisplayNameConsumer)).accept(Matchers.eq((Object)decision));
    }

    @Test
    public void testSetDisplayNameWithHasNameWithoutChange() {
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        this.metaData.setName(NAME);
        ((Consumer)Mockito.verify(this.clearDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class));
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class), Matchers.any(Name.class));
    }

    @Test
    public void testSetDisplayNameWithoutHasName() {
        this.setup(Optional.empty());
        this.metaData.setName(NAME);
        ((BiConsumer)Mockito.verify(this.setDisplayNameConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasName.class), Matchers.any(Name.class));
    }

    @Test
    public void testSetTypeRef() {
        this.setup(Optional.empty());
        QName typeRef = new QName();
        this.metaData.setTypeRef(typeRef);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer)).accept(Matchers.eq((Object)this.hasTypeRef), Matchers.eq((Object)typeRef));
    }

    @Test
    public void testSetTypeRefWithoutChange() {
        this.setup(Optional.empty());
        QName typeRef = new QName();
        Mockito.when((Object)this.hasTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        this.metaData.setTypeRef(typeRef);
        ((BiConsumer)Mockito.verify(this.setTypeRefConsumer, (VerificationMode)Mockito.never())).accept(Matchers.any(HasTypeRef.class), Matchers.any(QName.class));
    }

    @Test
    public void testAsDMNModelInstrumentedBase() {
        Decision decision = new Decision();
        this.setup(Optional.empty());
        Mockito.when((Object)this.hasTypeRef.asDMNModelInstrumentedBase()).thenReturn((Object)decision);
        Assertions.assertThat((Object)this.metaData.asDMNModelInstrumentedBase()).isEqualTo((Object)decision);
    }

    @Test
    public void testRender() {
        QName typeRef = BuiltInType.DATE.asQName();
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        GridRendererTheme theme = (GridRendererTheme)Mockito.mock(GridRendererTheme.class);
        Text tName = (Text)Mockito.mock(Text.class);
        InformationItemPrimary hasExpressionVariable = new InformationItemPrimary();
        hasExpressionVariable.setTypeRef(typeRef);
        this.hasExpression.setVariable(hasExpressionVariable);
        Decision decision = new Decision();
        decision.setName(NAME);
        this.setup(Optional.of(decision));
        Mockito.when((Object)theme.getHeaderText()).thenReturn((Object)tName);
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getTheme()).thenReturn((Object)theme);
        Mockito.when((Object)this.hasTypeRef.getTypeRef()).thenReturn((Object)typeRef);
        this.metaData.render(this.context, 10.0, 20.0);
        ((Text)Mockito.verify((Object)tName)).setText(NAME.getValue());
        ((Text)Mockito.verify((Object)tName, (VerificationMode)Mockito.times((int)2))).setListening(false);
        ((Text)Mockito.verify((Object)tName, (VerificationMode)Mockito.times((int)2))).setX(5.0);
        ((Text)Mockito.verify((Object)tName)).setY(2.0);
        ((Text)Mockito.verify((Object)tName)).setFontStyle(FONT_STYLE_TYPE_REF);
        ((Text)Mockito.verify((Object)tName)).setFontSize(8.0);
        ((Text)Mockito.verify((Object)tName)).setText("(" + typeRef.toString() + ")");
        ((Text)Mockito.verify((Object)tName)).setY(18.0);
    }

    @Test
    public void testRenderPlaceHolder() {
        GridRenderer renderer = (GridRenderer)Mockito.mock(GridRenderer.class);
        GridRendererTheme theme = (GridRendererTheme)Mockito.mock(GridRendererTheme.class);
        Text text = (Text)Mockito.mock(Text.class);
        this.setup(Optional.empty());
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)renderer);
        Mockito.when((Object)renderer.getTheme()).thenReturn((Object)theme);
        Mockito.when((Object)theme.getPlaceholderText()).thenReturn((Object)text);
        this.metaData.renderPlaceHolder(this.context, 10.0, 20.0);
        ((Text)Mockito.verify((Object)text)).setX(5.0);
        ((Text)Mockito.verify((Object)text)).setY(10.0);
        ((Text)Mockito.verify((Object)text)).setText("placeholder");
        ((Text)Mockito.verify((Object)text)).setListening(false);
    }
}

