/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellEditAction;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class EditablePopupHeaderMetaDataTest {
    private static final double ABSOLUTE_CELL_X = 10.0;
    private static final double ABSOLUTE_CELL_Y = 20.0;
    private static final double CELL_WIDTH = 100.0;
    private static final double CELL_HEIGHT = 32.0;
    private static final double CLIP_MIN_Y = 5.0;
    private static final double CLIP_MIN_X = 15.0;
    private static final int ROW_INDEX = 1;
    private static final int COLUMN_INDEX = 2;
    private static final boolean IS_FLOATING = false;
    private static final double RELATIVE_X = 38.0;
    private static final double RELATIVE_Y = 16.0;
    private static final Optional<String> EDITOR_TITLE = Optional.of("editor");
    @Mock
    private CellEditorControlsView.Presenter cellEditorControls;
    @Mock
    private MockEditor editor;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private Transform transform;
    @Mock
    private GridRenderer renderer;
    private MockEditableHeaderMetaData header;

    @Before
    public void setup() {
        this.header = new MockEditableHeaderMetaData(this.cellEditorControls, this.editor, this.gridWidget);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetColumnGroup() {
        this.header.setColumnGroup("group");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetTitle() {
        this.header.setTitle("title");
    }

    @Test
    public void testEditWithRelationLocation() {
        GridBodyCellEditContext context = new GridBodyCellEditContext(10.0, 20.0, 100.0, 32.0, 5.0, 15.0, 1, 2, false, this.transform, this.renderer, Optional.of(new Point2D(38.0, 16.0)));
        this.header.edit(context);
        ((MockEditor)Mockito.verify((Object)this.editor)).bind(Matchers.eq((Object)this.gridWidget), Matchers.eq((int)1), Matchers.eq((int)2));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), (Optional)Matchers.any(Optional.class), Matchers.eq((int)38), Matchers.eq((int)16));
    }

    @Test
    public void testEditWithNoRelationLocation() {
        GridBodyCellEditContext context = new GridBodyCellEditContext(10.0, 20.0, 100.0, 32.0, 5.0, 15.0, 1, 2, false, this.transform, this.renderer, Optional.empty());
        this.header.edit(context);
        ((MockEditor)Mockito.verify((Object)this.editor)).bind(Matchers.eq((Object)this.gridWidget), Matchers.eq((int)1), Matchers.eq((int)2));
        ((CellEditorControlsView.Presenter)Mockito.verify((Object)this.cellEditorControls)).show((HasCellEditorControls.Editor)Matchers.eq((Object)this.editor), (Optional)Matchers.eq(EDITOR_TITLE), Matchers.eq((int)60), Matchers.eq((int)36));
    }

    @Test
    public void testDestroyResources() {
        this.header.destroyResources();
        ((MockEditor)Mockito.verify((Object)this.editor)).hide();
    }

    @Test
    public void testSupportedEditAction() {
        Assertions.assertThat((Comparable)this.header.getSupportedEditAction()).isEqualTo((Object)GridCellEditAction.SINGLE_CLICK);
    }

    private static interface MockEditor
    extends HasCellEditorControls.Editor<GridWidget> {
    }

    private static class MockEditableHeaderMetaData
    extends EditablePopupHeaderMetaData<GridWidget, MockEditor> {
        private final GridWidget gridWidget;

        public MockEditableHeaderMetaData(CellEditorControlsView.Presenter cellEditorControls, MockEditor editor, GridWidget gridWidget) {
            super(cellEditorControls, (HasCellEditorControls.Editor)editor, EDITOR_TITLE);
            this.gridWidget = gridWidget;
        }

        protected GridWidget getPresenter() {
            return this.gridWidget;
        }

        public String getColumnGroup() {
            return "GROUP";
        }

        public String getTitle() {
            return "TITLE";
        }
    }
}

