/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.keyboard;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.keyboard.KeyboardOperationEscapeGridCell;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=GwtMockitoTestRunner.class)
public class KeyboardOperationEscapeGridCellTest {
    @Mock
    private GridLayer gridLayer;
    private KeyboardOperationEscapeGridCell operation;

    @Before
    public void setUp() {
        this.operation = new KeyboardOperationEscapeGridCell(this.gridLayer);
    }

    @Test
    public void testReactsOnKey() {
        Assertions.assertThat((int)this.operation.getKeyCode()).isEqualTo(27);
    }

    @Test
    public void testNonBaseExpressionGrid() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.operation.isExecutable((GridWidget)Mockito.mock(GridWidget.class))).as("Widget have to be BaseExpressionWidget instance", new Object[0])).isFalse();
    }

    @Test
    public void testBaseExpressionGrid() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.operation.isExecutable((GridWidget)Mockito.mock(BaseExpressionGrid.class))).as("Widget can be BaseExpressionWidget instance", new Object[0])).isTrue();
    }

    @Test
    public void testEscapeFromNotChildCell() {
        Optional oParent = Optional.empty();
        BaseExpressionGrid gridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)gridWidget.findParentGrid()).thenReturn(oParent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.operation.perform((GridWidget)gridWidget, false, false)).as("No need to redraw", new Object[0])).isFalse();
    }

    @Test
    public void testEscapeFromChildCell() {
        BaseExpressionGrid parent = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Optional<BaseExpressionGrid> oParent = Optional.of(parent);
        BaseExpressionGrid gridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        Mockito.when((Object)gridWidget.findParentGrid()).thenReturn(oParent);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.operation.perform((GridWidget)gridWidget, false, false)).as("Need to redraw", new Object[0])).isTrue();
        ((GridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)parent);
        ((BaseExpressionGrid)Mockito.verify((Object)parent)).selectFirstCell();
    }
}

